/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;

class Doc {
    int opencount;
    String filename;
    String fullname;
    String home;
    String mode;
    RandomAccessFile file;
    Block0 block0;
    Hashtable<Integer, CacheBlock> blocks;
    Hashtable<Integer, StatementBlock> statementblocks;
    Hashtable<Integer, ChainBlock> chainblocks;
    int revertblk;

    public Doc(String f, String m) throws IOException {
        this.filename = f;
        this.mode = m;
        File tfile = new File(f);
        this.fullname = tfile.getAbsolutePath();
        File afile = new File(this.fullname);
        this.home = afile.getParent();
        this.filename = afile.getName();
        tfile = null;
        afile = null;
        this.blocks = new Hashtable();
        this.statementblocks = new Hashtable();
        this.chainblocks = new Hashtable();
        String tname = new String(this.fullname);
        try {
            this.file = new RandomAccessFile(tname, "r");
        }
        catch (IOException e) {
            tname = new String(this.fullname + ".tkr");
            this.file = new RandomAccessFile(tname, "r");
        }
        this.file.close();
        this.file = new RandomAccessFile(tname, this.mode);
        this.block0 = new Block0(this);
        if (!this.block0.isMagic()) {
            this.file.close();
            this.file = null;
            throw new IOException(this.fullname);
        }
        this.opencount = 1;
        this.revertblk = 0;
    }

    public void doHardClose(ThWindow frame) {
        this.opencount = 1;
        this.doClose(frame);
    }

    public void doClose(ThWindow frame) {
        int n;
        String query = new String("Save Changes - " + this.filename);
        if (this.needSave() && (n = JOptionPane.showConfirmDialog(frame, query, "Save or Discard Changes", 0)) == 0) {
            this.doSave();
        }
        if (this.opencount > 1) {
            --this.opencount;
            return;
        }
        if (this.file == null) {
            return;
        }
        try {
            this.file.close();
        }
        catch (IOException e) {
            this.file = null;
        }
        this.file = null;
        this.opencount = 0;
        this.revertblk = 0;
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public String getHome() {
        return this.home;
    }

    public String makeAbsolute(String fn) {
        if (this.file == null) {
            return "";
        }
        if (fn == null) {
            return this.fullname;
        }
        if (fn.charAt(0) == '/') {
            return new String(fn);
        }
        return new String(this.home + "/" + fn);
    }

    public void incrementOpencount() {
        ++this.opencount;
    }

    public int decrementOpencount() {
        --this.opencount;
        return this.opencount;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getFirstHash() {
        return this.block0.getFirstHash();
    }

    public int getNStatements() {
        return this.block0.getNstatements();
    }

    public void setNStatements(int ns) {
        this.block0.setNstatements(ns);
        this.block0.putBlock();
    }

    public int getFirstAvail() {
        return this.block0.getFirstAvail();
    }

    public int getFreeHead() {
        return this.block0.getFreeHead();
    }

    public void purgeCaches() {
        this.statementblocks.clear();
        this.chainblocks.clear();
    }

    public Block0 getBlock0() {
        return this.block0;
    }

    public StatementBlock getStatementBlock(int blocknumber) {
        if (this.file == null) {
            return null;
        }
        StatementBlock sb = this.statementblocks.get(new Integer(blocknumber));
        if (sb != null) {
            return sb;
        }
        sb = new StatementBlock(this, blocknumber);
        this.statementblocks.put(new Integer(blocknumber), sb);
        return sb;
    }

    public StatementBlock getStatementBlock() {
        if (this.file == null) {
            return null;
        }
        StatementBlock sb = new StatementBlock(this);
        this.statementblocks.put(new Integer(sb.getBlockNumber()), sb);
        return sb;
    }

    public StatementBlock getOriginStatementBlock() {
        return this.getStatementBlock(this.block0.getFirstBlock());
    }

    public ChainBlock getChainBlock(int blocknumber) {
        if (this.file == null) {
            return null;
        }
        ChainBlock cb = this.chainblocks.get(new Integer(blocknumber));
        if (cb != null) {
            return cb;
        }
        cb = new ChainBlock(this, blocknumber);
        this.chainblocks.put(new Integer(blocknumber), cb);
        return cb;
    }

    public ChainBlock getChainBlock() {
        if (this.file == null) {
            return null;
        }
        ChainBlock cb = new ChainBlock(this);
        this.chainblocks.put(new Integer(cb.getBlockNumber()), cb);
        return cb;
    }

    public Statement getStatement(int blocknumber, Options opts) {
        if (this.file == null) {
            return null;
        }
        return StatementFactory.make(this, blocknumber, opts);
    }

    public Statement getStatement(Options opts, boolean isimage) {
        if (this.file == null) {
            return null;
        }
        return StatementFactory.make(this, opts, isimage);
    }

    public TextStatement getStatement(int blocknumber) {
        TextStatement st = (TextStatement)StatementFactory.make(this, blocknumber);
        return st;
    }

    public TextStatement getStatement() {
        TextStatement st = (TextStatement)StatementFactory.make(this);
        return st;
    }

    public Labels getLabels() {
        return new Labels(this);
    }

    public Options getOptions(ThWindow frame) {
        return new Options(this, frame);
    }

    public boolean needSave() {
        return !this.blocks.isEmpty();
    }

    public boolean doSave() {
        if (this.file == null) {
            return false;
        }
        Enumeration<CacheBlock> e = this.blocks.elements();
        while (e.hasMoreElements()) {
            CacheBlock cb = e.nextElement();
            byte[] tbuf = new byte[128];
            cb.getData(tbuf, 0);
            int blk = cb.getBlock();
            this.putBlock(tbuf, 0, blk, true);
        }
        this.blocks.clear();
        this.statementblocks.clear();
        this.chainblocks.clear();
        this.revertblk = 0;
        return true;
    }

    public boolean doSaveAs(String fname) {
        RandomAccessFile ofile;
        byte[] buf = new byte[4096];
        try {
            ofile = new RandomAccessFile(fname, "rw");
        }
        catch (IOException ioe) {
            return false;
        }
        try {
            boolean bytes = false;
            int lenread = 4096;
            this.file.seek(0L);
            ofile.seek(0L);
            while (lenread == 4096) {
                lenread = this.file.read(buf, 0, 4096);
                ofile.write(buf, 0, lenread);
            }
        }
        catch (IOException ioe) {
            try {
                ofile.close();
            }
            catch (IOException ioce) {
                // empty catch block
            }
            return false;
        }
        Enumeration<CacheBlock> e = this.blocks.elements();
        while (e.hasMoreElements()) {
            CacheBlock cb = e.nextElement();
            byte[] tbuf = new byte[128];
            cb.getData(tbuf, 0);
            int blk = cb.getBlock();
            try {
                ofile.seek(blk * 128);
                ofile.write(tbuf, 0, 128);
            }
            catch (IOException ioe) {
                try {
                    ofile.close();
                }
                catch (IOException ioce) {
                    // empty catch block
                }
                return false;
            }
        }
        try {
            ofile.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.blocks.clear();
        this.statementblocks.clear();
        this.chainblocks.clear();
        return true;
    }

    public int doRevert() {
        if (this.file == null) {
            return 0;
        }
        this.blocks.clear();
        this.statementblocks.clear();
        this.chainblocks.clear();
        this.block0 = new Block0(this);
        return this.revertblk;
    }

    public int getRevertBlk() {
        return this.revertblk;
    }

    public void clearRevertBlk() {
        this.revertblk = 0;
    }

    public void setRevertBlk(int blk) {
        this.revertblk = blk;
    }

    public void putBlock(byte[] buf, int offset, int blocknumber, boolean todisk) {
        if (this.file == null) {
            return;
        }
        if (!todisk) {
            this.blocks.put(new Integer(blocknumber), new CacheBlock(this, blocknumber, buf, offset));
            return;
        }
        try {
            this.file.seek(blocknumber * 128);
            this.file.write(buf, offset, 128);
        }
        catch (IOException e) {
            System.out.println("Write Failed");
        }
    }

    public void getBlock(byte[] buf, int offset, int blocknumber) {
        if (this.file == null) {
            return;
        }
        CacheBlock cb = this.blocks.get(new Integer(blocknumber));
        if (cb != null) {
            cb.getData(buf, offset);
            return;
        }
        try {
            this.file.seek(blocknumber * 128);
            this.file.read(buf, offset, 128);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public int getFirstBlock() {
        return this.block0.getFirstBlock();
    }

    public void setFirstBlock(int fb) {
        this.block0.setFirstBlock(fb);
        this.block0.putBlock();
    }

    public int getResourcesBlock() {
        return this.block0.getResources();
    }

    public void setResourcesBlock(int block) {
        this.block0.setResources(block);
        this.block0.putBlock();
    }

    public int getPosition(int blk) {
        if (this.file == null) {
            return 0;
        }
        int position = 0;
        if (this.block0.getNstatements() == 0) {
            return 0;
        }
        StatementBlock sb = this.getStatementBlock(blk);
        while (blk != 0) {
            int tblk;
            while ((tblk = sb.getPrev()) != 0) {
                sb = this.getStatementBlock(tblk);
                position = position + sb.getV2Nstatements() + 1;
            }
            blk = sb.getUp();
            if (blk == 0) continue;
            sb = this.getStatementBlock(blk);
            ++position;
        }
        return position;
    }

    public int positionToBlock(int position) {
        if (this.file == null) {
            return 0;
        }
        int myposition = 0;
        int block = this.getFirstBlock();
        if (this.block0.getNstatements() == 0) {
            return block;
        }
        while (block != 0) {
            StatementBlock sb = this.getStatementBlock(block);
            int tblk = sb.getNext();
            if (sb.getV2Nstatements() + 1 + myposition > position || tblk == 0) {
                if (sb.getDown() == 0) {
                    Statement s = this.getStatement(sb.getBlockNumber(), null);
                    return s.getPredecessor(99, null, null);
                }
                if (++myposition > position) {
                    Statement s = this.getStatement(sb.getBlockNumber(), null);
                    return s.getPredecessor(99, null, null);
                }
                tblk = sb.getDown();
            } else {
                myposition = myposition + 1 + sb.getV2Nstatements();
            }
            block = tblk;
        }
        return 0;
    }

    public String whatsMyLevel(StatementBlock sb, String separator) {
        int level = sb.getLevel();
        int prev = sb.getPrev();
        int count = (sb.getV2Fmt() & 0x20) == 32 ? 0 : 1;
        while (prev != 0) {
            sb = this.getStatementBlock(prev);
            if ((sb.getV2Fmt() & 0x20) != 32) {
                ++count;
            }
            prev = sb.getPrev();
        }
        if (level == 0) {
            return new String("" + count);
        }
        sb = this.getStatementBlock(sb.getUp());
        return new String(this.whatsMyLevel(sb, separator) + separator + count);
    }

    public StatementBlock whatsMyPage(StatementBlock sb) {
        if (sb.isPage()) {
            return sb;
        }
        while (sb.getUp() != 0) {
            if ((sb = this.getStatementBlock(sb.getUp())) == null) {
                return null;
            }
            if (!sb.isPage()) continue;
            return sb;
        }
        return null;
    }

    public boolean validateStatementBlock(int block) {
        StatementBlock tsb;
        if (block == 0) {
            return false;
        }
        StatementBlock sb = this.getStatementBlock(block);
        if (sb == null) {
            return false;
        }
        if (sb.isUnused()) {
            return false;
        }
        if (sb.getPrev() == 0 && sb.getNext() == 0 && sb.getUp() == 0) {
            return false;
        }
        if (sb.getPrev() != 0) {
            tsb = this.getStatementBlock(sb.getPrev());
            if (tsb == null) {
                return false;
            }
            if (tsb.getNext() != block) {
                return false;
            }
        }
        if (sb.getNext() != 0) {
            tsb = this.getStatementBlock(sb.getNext());
            if (tsb == null) {
                return false;
            }
            if (tsb.getPrev() != block) {
                return false;
            }
        }
        if (sb.getPrev() == 0 && sb.getUp() != 0) {
            tsb = this.getStatementBlock(sb.getUp());
            if (tsb == null) {
                return false;
            }
            if (tsb.getDown() != block) {
                return false;
            }
        }
        if (sb.getDown() != 0) {
            tsb = this.getStatementBlock(sb.getDown());
            if (tsb == null) {
                return false;
            }
            if (tsb.getUp() != block) {
                return false;
            }
        }
        return true;
    }

    public int allocateBlock() {
        byte[] buf = new byte[128];
        int freehead = this.block0.getFreeHead();
        int firstavail = this.block0.getFirstAvail();
        if (freehead != 0) {
            this.getBlock(buf, 0, freehead);
            this.block0.setFreeHead(Cbytes.byteToInt(buf, 16));
            Cbytes.intToByte(0, buf, 16);
            buf[23] = 0;
            this.putBlock(buf, 0, freehead, false);
            this.block0.putBlock();
            return freehead;
        }
        this.block0.setFirstAvail(firstavail + 1);
        this.block0.putBlock();
        for (int i = 0; i < 128; ++i) {
            buf[i] = 0;
        }
        this.putBlock(buf, 0, firstavail, true);
        return firstavail;
    }

    public void freeBlock(int block) {
        byte[] buf = new byte[128];
        this.getBlock(buf, 0, block);
        for (int i = 0; i < 128; ++i) {
            buf[i] = 0;
        }
        buf[23] = -128;
        int freehead = this.block0.getFreeHead();
        Cbytes.intToByte(freehead, buf, 16);
        this.putBlock(buf, 0, block, false);
        this.statementblocks.remove(new Integer(block));
        this.chainblocks.remove(new Integer(block));
        this.block0.setFreeHead(block);
        this.block0.putBlock();
    }
}

