/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

class DocLink {
    Doc document;
    int block;
    Vector<Integer> blocks = null;
    Vector<String> labels;
    boolean multiple = false;
    int i;
    String msg = null;
    String modifiers = null;

    public DocLink(Doc d, int b) {
        this.document = d;
        this.block = b;
    }

    public DocLink(ThWindow frame, LabelString ls, int x, int y) {
        String fullname;
        this.document = ls.getDoc();
        if (this.document == null) {
            this.document = frame.getDoc();
        }
        if (this.document == null) {
            fullname = ls.getFilename();
            this.document = frame.getDocManager().openDoc(fullname);
        } else {
            fullname = this.document.makeAbsolute(ls.getFilename());
            if (!fullname.equalsIgnoreCase(this.document.getFullname())) {
                this.document = frame.getDocManager().openDoc(fullname);
            }
        }
        this.block = 0;
        if (this.document != null) {
            try {
                Labels labels = this.document.getLabels();
                DocLink dl = labels.lookupLabel(ls.getLabel());
                this.block = x == 0 && y == 0 ? dl.getBlock() : dl.getBlock(frame, x, y);
                this.modifiers = ls.getModifiers();
                if (this.modifiers != null) {
                    this.block = this.dodots(this.document, this.block, this.modifiers);
                }
            }
            catch (NoSuchElementException ex) {
                this.document = null;
                this.block = 0;
                this.msg = new String(ls.getLabel() + " Not Found");
            }
        } else {
            this.msg = new String("File: " + fullname + " Not Found");
        }
    }

    public String getMsg() {
        return this.msg;
    }

    public void addBlock(int b) {
        if (this.blocks == null) {
            this.blocks = new Vector();
            this.blocks.addElement(new Integer(this.block));
        }
        this.blocks.addElement(new Integer(b));
        this.multiple = true;
    }

    public boolean compare(DocLink dl) {
        if (dl == null) {
            return false;
        }
        if (dl.getDocument() != this.document) {
            return false;
        }
        return dl.getBlock() == this.block;
    }

    public Doc getDocument() {
        return this.document;
    }

    public int getBlock() {
        return this.block;
    }

    public int getBlock(ThWindow frame, int x, int y) {
        if (this.blocks == null) {
            return this.block;
        }
        this.labels = new Vector();
        Enumeration<Integer> e = this.blocks.elements();
        while (e.hasMoreElements()) {
            Integer I = e.nextElement();
            int blk = I;
            Statement s = this.document.getStatement(blk, null);
            int length = s.length;
            if (length > 60) {
                length = 60;
            }
            String str = new String(s.text, 0, length);
            this.labels.addElement(str);
        }
        SimpleResponse r = new SimpleResponse();
        RLDialog d = new RLDialog(frame, this.blocks, this.labels, r, x, y, "Choose a Link");
        d.setVisible(true);
        return r.getResponse();
    }

    private int dodots(Doc doc, int blk, String mod) {
        if (mod != null) {
            String lmod = mod.toLowerCase();
            while (lmod.length() > 0) {
                StatementBlock sb;
                int tblk;
                char c = lmod.charAt(0);
                if (c == 's' && (tblk = (sb = doc.getStatementBlock(blk)).getNext()) != 0) {
                    blk = tblk;
                }
                if (c == 'p') {
                    sb = doc.getStatementBlock(blk);
                    tblk = sb.getPrev();
                    if (tblk != 0) {
                        blk = tblk;
                    }
                } else if (c == 'u') {
                    sb = doc.getStatementBlock(blk);
                    tblk = sb.getUp();
                    if (tblk != 0) {
                        blk = tblk;
                    }
                } else if (c == 'd') {
                    sb = doc.getStatementBlock(blk);
                    tblk = sb.getDown();
                    if (tblk != 0) {
                        blk = tblk;
                    }
                } else if (c == 't') {
                    int tblk2 = blk;
                    while (blk != 0) {
                        StatementBlock sb2 = doc.getStatementBlock(blk);
                        if ((blk = sb2.getNext()) == 0) continue;
                        tblk2 = blk;
                    }
                    blk = tblk2;
                } else if (c == 'h') {
                    int tblk3 = blk;
                    while (blk != 0) {
                        StatementBlock sb3 = doc.getStatementBlock(blk);
                        if ((blk = sb3.getPrev()) == 0) continue;
                        tblk3 = blk;
                    }
                    blk = tblk3;
                }
                lmod = lmod.substring(1);
            }
        }
        return blk;
    }
}

