/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFileChooser;

class DocManager {
    Hashtable<String, Doc> directory = new Hashtable();

    public Doc openDoc(String filename) {
        File tfile = new File(filename);
        String fullname = tfile.getAbsolutePath();
        if (this.directory.containsKey(fullname.toUpperCase())) {
            Doc d = this.directory.get(fullname.toUpperCase());
            d.incrementOpencount();
            return d;
        }
        try {
            Doc d = new Doc(fullname, "rw");
            this.directory.put(fullname.toUpperCase(), d);
            return d;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void closeAllDoc(ThWindow frame) {
        Enumeration<Doc> e = this.directory.elements();
        while (e.hasMoreElements()) {
            Doc doc = e.nextElement();
            doc.doHardClose(frame);
        }
    }

    public void closeDoc(Doc d, ThWindow frame) {
        if (d == null) {
            return;
        }
        int count = d.decrementOpencount();
        if (count == 0) {
            this.directory.remove(d.getFullname().toUpperCase());
            d.doClose(frame);
        }
    }

    public LabelString findDoc(ThWindow frame) throws IOException {
        JFileChooser file_dialog = new JFileChooser(frame.getHome());
        file_dialog.setDialogType(0);
        file_dialog.setDialogTitle("Choose a Thinker Document");
        int retval = file_dialog.showOpenDialog(frame);
        if (retval == 0) {
            File file = file_dialog.getSelectedFile();
            String fname = file.getPath();
            fname = new String(fname + ",");
            LabelString ls = new LabelString(fname, frame.getOptions(), frame.getDoc());
            return ls;
        }
        return null;
    }
}

