/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;

class DocView
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener,
Printable,
MouseWheelListener {
    MyCaret mycaret;
    CharFormat cf = null;
    CharFormat scf = null;
    ThWindow frame;
    Toolkit toolkit;
    ThEdit thedit = null;
    ThJump thjump = null;
    VBar vbar;
    Hashtable<Doc, Hashtable<Integer, Doc>> docs;
    ThPrint printObject = null;
    protected static final int NORMALINDENT = 30;
    Statement firststatement;
    Statement laststatement;
    int anchorBlock;
    Doc doc;
    Options options;
    Vector<Integer> marked;
    Hashtable<Integer, OpenGadget> opengadgets;
    Hashtable<Integer, DragGadget> draggadgets;
    DragGadget activedrag = null;
    int clipping = 5;
    String title;
    int offset = 0;
    int vbarpos = 1;
    Statement repaintStatement = null;
    Rectangle repaintRectangle;
    Doc selectingdoc;
    int selectingblock;
    int selectbegin;
    int selectend;
    ThCommand activecommand;
    boolean marking;

    public DocView(ThWindow f, VBar v, MyCaret mc, Options opts) {
        this.setBackground(Color.white);
        this.frame = f;
        this.vbar = v;
        this.mycaret = mc;
        this.options = opts;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.anchorBlock = 0;
        this.marked = new Vector();
        this.opengadgets = new Hashtable();
        this.draggadgets = new Hashtable();
        this.docs = new Hashtable();
        this.firststatement = null;
        this.laststatement = null;
        this.doc = null;
        this.setFocusTraversalKeysEnabled(false);
    }

    public void repaintImmediately() {
        Rectangle rv = this.getBounds(null);
        rv.y = 0;
        this.paintImmediately(rv);
    }

    public void repaintselected(Statement s) {
        this.repaintRectangle = s.getRectangle();
        this.repaintStatement = s;
        this.repaint(this.repaintRectangle);
        this.paintImmediately(this.repaintRectangle);
    }

    public void recompute() {
        Graphics g = this.getGraphics();
        Dimension bounds = this.getSize();
        this.draw(g, bounds, false, this.cf);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        VBar vbar = this.frame.getVbar();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.anchorBlock == 0) {
            return;
        }
        if (this.doc == null) {
            this.frame.errormsg("Doc = null");
            return;
        }
        if (!this.doc.isOpen()) {
            this.frame.errormsg("Doc not open");
            return;
        }
        if (this.repaintStatement != null) {
            Dimension d = this.getSize();
            int displaywidth = this.setdisplaywidth(d.width);
            Rectangle r = new Rectangle(30, 0, displaywidth, d.height);
            int off = 0;
            if (this.repaintStatement == this.getFirstStatement()) {
                off = this.offset;
            }
            this.repaintStatement.draw(g2d, r, this.repaintStatement.getTop(), off, this.mycaret, true, this.cf, this);
            Rectangle newr = this.repaintStatement.getRectangle();
            this.repaintStatement = null;
            if (newr.height != this.repaintRectangle.height) {
                this.repaint();
            }
            return;
        }
        this.mycaret.clearCaret();
        this.mycaret.hideCaret();
        Dimension bounds = this.getSize();
        this.draw(g2d, bounds, true, this.cf);
        if (!this.mycaret.isCaretOnscreen()) {
            this.frame.updateReorgMenu(false, false);
        }
    }

    public void setAnchorBlock(int anchor) {
        if (this.doc == null) {
            return;
        }
        this.flush();
        this.anchorBlock = anchor;
        this.offset = 0;
        this.vbar.setPosition(this.anchorBlock, this.doc);
    }

    public int getAnchorBlock() {
        return this.anchorBlock;
    }

    public void setPrintObject(ThPrint tp) {
        this.printObject = tp;
    }

    public void setOffset(int o) {
        this.offset = o;
    }

    public void setDoc(Doc d) {
        this.flush();
        this.doc = d;
        this.firststatement = null;
    }

    public void setOptions(Options opt) {
        this.options = opt;
    }

    public void clearAllMarked() {
        this.marked.removeAllElements();
    }

    public void addMarkStatement(int block) {
        this.marked.addElement(new Integer(block));
    }

    public void setClipping(int clip) {
        this.clipping = clip;
    }

    public int getClipping() {
        return this.clipping;
    }

    public void flush() {
        for (Statement s = this.firststatement; s != null; s = s.getNextStatement()) {
            s.putStatement(this.getDisplayCharFormat());
        }
    }

    public void flushrelease() {
        this.flush();
        this.firststatement = null;
    }

    public void clearselect() {
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            st.clearSelect();
        }
    }

    public Statement findstatement(int x, int y) {
        if (this.firststatement == null) {
            return null;
        }
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            if (!st.isInStatement(x, y)) continue;
            return st;
        }
        return null;
    }

    public Statement findstatementbyblock(int block) {
        if (this.firststatement == null) {
            return null;
        }
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            if (block != st.getBlockNumber()) continue;
            return st;
        }
        return null;
    }

    public Statement findpreviousstatement(Statement tst) {
        if (this.firststatement == null) {
            return null;
        }
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            if (st.getNextStatement() != tst) continue;
            return st;
        }
        return null;
    }

    public Statement findfocus() {
        if (this.firststatement == null) {
            return null;
        }
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            if (!st.isInFocus()) continue;
            return st;
        }
        return null;
    }

    public void clearFocus() {
        if (this.firststatement == null) {
            return;
        }
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            st.setFocus(false);
        }
    }

    public boolean clickGadget(MouseEvent e, int x, int y) {
        if (!this.opengadgets.isEmpty()) {
            Enumeration<OpenGadget> ienum = this.opengadgets.elements();
            while (ienum.hasMoreElements()) {
                OpenGadget g = ienum.nextElement();
                if (!g.contains(x, y)) continue;
                g.mouseDown();
                this.repaint();
                return true;
            }
        }
        return false;
    }

    public boolean clickStatement(MouseEvent e, int x, int y) {
        Statement st = this.findstatement(x, y);
        if (st != null) {
            this.clearFocus();
            st.setFocus(true);
            st.mouseDown(this, this.mycaret, e, x, y);
            return true;
        }
        return false;
    }

    public void insertedBranch(StatementBlock sb) {
        int up;
        int level = sb.getLevel() + 1;
        if (level > this.clipping && (up = sb.getUp()) != 0) {
            this.addForced(this.doc, up);
        }
    }

    public void setDisplayCharFormat(CharFormat tcf) {
        this.cf = tcf;
    }

    public CharFormat getDisplayCharFormat() {
        return this.cf;
    }

    public void setStatementCharFormat(CharFormat tcf) {
        this.scf = tcf;
    }

    public CharFormat getStatementCharFormat() {
        return this.scf;
    }

    public ThWindow getFrame() {
        return this.frame;
    }

    public void mypoll() {
        if (this.mycaret != null && this.isDocOnScreen(this.mycaret.getDoc())) {
            this.mycaret.mypoll();
        }
    }

    private boolean isDocOnScreen(Doc d) {
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            if (!st.isDrawn() || st.getVDoc() != d) continue;
            return true;
        }
        return false;
    }

    public void doSaveSeeThrough() {
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            if (st.getVDoc() == this.doc) continue;
            st.getVDoc().doSave();
        }
    }

    public void doRevertSeeThrough() {
        for (Statement st = this.firststatement; st != null; st = st.getNextStatement()) {
            if (st.getVDoc() == this.doc) continue;
            st.getVDoc().doRevert();
        }
    }

    public void setSelected(Doc d, int b, int begin, int end) {
        this.selectingdoc = d;
        this.selectingblock = b;
        this.selectbegin = begin;
        this.selectend = end;
    }

    public void clearSelected() {
        this.selectingdoc = null;
    }

    public void scrollBarPosition() {
        StatementBlock tSb;
        int clipping = this.getClipping();
        if (this.doc == null) {
            return;
        }
        StatementBlock pageHead = this.doc.whatsMyPage(this.doc.getStatementBlock(this.anchorBlock));
        int block = this.vbar.getBlkPosition(this.doc);
        if (this.options.getPageMode() && pageHead != (tSb = this.doc.whatsMyPage(this.doc.getStatementBlock(block)))) {
            return;
        }
        if (block != 0) {
            block = this.uptoclip(block, clipping);
            this.setAnchorBlock(block);
            this.repaintImmediately();
        }
    }

    public boolean scrollPageUp() {
        int block = this.getAnchorBlock();
        Dimension b = this.getSize();
        if (this.doc == null) {
            return false;
        }
        int lastoffset = this.getOffset();
        int lastblock = this.getAnchorBlock();
        CharFormat tcf = this.getDisplayCharFormat();
        Cursor saveCursor = this.vbar.getCursor();
        this.vbar.setCursor(Cursor.getPredefinedCursor(3));
        while (this.scrollLineUp()) {
            this.draw(this.getGraphics(), b, false, tcf);
            if (this.isOnScreen(block)) continue;
            this.scrollLineDown();
            this.vbar.setCursor(saveCursor);
            return true;
        }
        this.vbar.setCursor(saveCursor);
        return false;
    }

    public boolean scrollLineUp() {
        if (this.doc == null) {
            return false;
        }
        StatementBlock sb = this.doc.getStatementBlock(this.getAnchorBlock());
        StatementBlock pageHead = this.doc.whatsMyPage(sb);
        if (this.options.getPageMode() && sb.isPage()) {
            return false;
        }
        int clip = this.clipping;
        int tclip = sb.getLevel() + 1;
        if (tclip > clip) {
            clip = tclip;
        }
        this.mycaret.clearCaret();
        this.mycaret.hideCaret();
        int o = this.getOffset();
        if (0 == o) {
            StatementBlock tSb;
            Statement s = this.getFirstStatement();
            int previous = s.getPredecessor(clip, this.options, this);
            if (0 == previous) {
                return false;
            }
            if (this.options.getPageMode() && this.doc.whatsMyPage(tSb = this.doc.getStatementBlock(previous)) != pageHead) {
                if (pageHead == null) {
                    while (previous != 0 && (previous = s.getPrev()) != 0 && this.doc.whatsMyPage(tSb = this.doc.getStatementBlock(previous)) != null) {
                    }
                    if (previous == 0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            previous = this.uptoclip(previous, clip);
            this.insertAnchorBlock(previous);
            this.vbar.setPosition(previous, this.doc);
            s = this.getFirstStatement();
            if (s.isText()) {
                TextStatement ts = (TextStatement)s;
                Graphics g = this.getGraphics();
                Dimension bounds = this.getSize();
                int displaywidth = this.setdisplaywidth(bounds.width);
                Rectangle r = new Rectangle(30, 0, displaywidth, bounds.height);
                ts.playDraw(g, r, this.getDisplayCharFormat());
                Vector rows = ts.getRows();
                int index = rows.size() - 1;
                o = (Integer)rows.elementAt(index);
                this.setOffset(o);
            }
            if (s.isImage()) {
                o = 0;
                this.setOffset(o);
            }
            this.repaint();
            return true;
        }
        Dimension bounds = this.getSize();
        Statement s = this.getFirstStatement();
        if (s.isText()) {
            boolean inrange = false;
            TextStatement ts = (TextStatement)s;
            int displaywidth = this.setdisplaywidth(bounds.width);
            Rectangle r = new Rectangle(30, 0, displaywidth, bounds.height);
            Graphics g = this.getGraphics();
            ts.playDraw(g, r, this.getDisplayCharFormat());
            Vector rows = ts.getRows();
            for (int index = 1; index < rows.size(); ++index) {
                if (o > (Integer)rows.elementAt(index)) continue;
                o = (Integer)rows.elementAt(index - 1);
                inrange = true;
                break;
            }
            if (!inrange) {
                o = 0;
            }
            this.setOffset(o);
            ts.setCalcsizes();
        }
        if (s.isImage()) {
            int previous = s.getPredecessor(clip, this.options, this);
            if (0 == previous) {
                return false;
            }
            this.setAnchorBlock(previous);
            s = this.getFirstStatement();
            this.setOffset(0);
            this.vbar.setPosition(previous, this.doc);
        }
        this.repaint();
        return true;
    }

    public boolean scrollPageDown() {
        int block;
        Statement s = this.getLastStatement();
        if (this.doc == null) {
            return false;
        }
        if (null == s) {
            return false;
        }
        this.mycaret.clearCaret();
        this.mycaret.hideCaret();
        if (s.isText()) {
            TextStatement ts = (TextStatement)s;
            block = ts.getBlockNumber();
            int o = ts.getLastOffset();
            this.setAnchorBlock(block);
            this.setOffset(o);
            ts.setCalcsizes();
        } else {
            block = s.getBlockNumber();
            if (block == this.getAnchorBlock()) {
                block = s.getSuccessor(this.clipping);
            }
            this.setAnchorBlock(block);
        }
        this.vbar.setPosition(block, this.doc);
        this.repaint();
        return true;
    }

    public boolean scrollLineDown() {
        if (this.doc == null) {
            return false;
        }
        int clip = this.clipping;
        this.mycaret.clearCaret();
        this.mycaret.hideCaret();
        int o = this.getOffset();
        Statement s = this.getFirstStatement();
        StatementBlock pageHead = this.doc.whatsMyPage(s.getStatementBlock());
        int tclip = s.getLevel() + 1;
        if (tclip > clip) {
            clip = tclip;
        }
        if (null != s) {
            int block = this.getAnchorBlock();
            if (s.isText()) {
                TextStatement ts = (TextStatement)s;
                Vector v = ts.getRows();
                int index = v.indexOf(new Integer(o));
                if (v.size() > index + 1) {
                    o = (Integer)v.elementAt(index + 1);
                    this.setOffset(o);
                    ts.setCalcsizes();
                    this.vbar.setPosition(block, this.doc);
                    this.repaint();
                    return true;
                }
            }
            if (this.isForced(this.doc, block) && (tclip = s.getLevel() + 2) > this.clipping) {
                clip = tclip;
            }
            if (null != (s = this.getNextStatement(s, clip, false))) {
                StatementBlock tPageHead;
                tclip = s.getLevel() + 1;
                if (tclip < clip) {
                    clip = tclip;
                }
                if (clip < this.clipping) {
                    clip = this.clipping;
                }
                block = s.getBlockNumber();
                if (this.options.getPageMode() && (tPageHead = this.doc.whatsMyPage(s.getStatementBlock())) != pageHead) {
                    if (pageHead != null) {
                        this.repaint();
                        return false;
                    }
                    s = this.getFirstStatement();
                    block = s.getSuccessor(s.getLevel() + 1);
                    if (block == 0) {
                        this.repaint();
                        return false;
                    }
                }
            } else {
                this.repaint();
                return false;
            }
            this.setAnchorBlock(block);
            this.vbar.setPosition(block, this.doc);
            this.repaint();
            return true;
        }
        this.repaint();
        return false;
    }

    public boolean isMarking() {
        return this.marking;
    }

    public void startMarking(ThCommand command, int code) {
        this.activecommand = command;
        this.marking = this.activecommand.cmdStart(code);
        if (this.marking) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void cancelMarking() {
        if (this.activecommand != null) {
            this.activecommand.cmdCancel();
        }
        this.marking = false;
        this.activecommand = null;
        this.frame.getDocView().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void draw(Graphics g, Dimension bounds, boolean reallydraw, CharFormat dcf) {
        int o = 0;
        Statement s = this.getFirstStatement();
        StatementBlock pageHead = this.doc.whatsMyPage(s.getStatementBlock());
        if (s == null) {
            return;
        }
        int place = 5;
        if (this.options.getPageMode()) {
            Statement pageStatement;
            String pageName = this.doc.getFilename();
            place = 25;
            StatementBlock sb = s.getStatementBlock();
            if ((sb = this.doc.whatsMyPage(sb)) != null && (pageStatement = this.doc.getStatement(sb.getBlockNumber(), this.options)) != null && (pageName = new String(pageStatement.getBytes(), 0, pageStatement.getLength())).length() > 80) {
                pageName = pageName.substring(0, 80);
            }
            FontMetrics fm = g.getFontMetrics();
            int nameLength = fm.stringWidth(pageName);
            int rX = 5;
            int rY = 5;
            int rWidth = bounds.width - 10;
            int rHeight = 15;
            int textLeft = (rWidth - nameLength) / 2;
            if (textLeft < 0) {
                textLeft = 10;
            }
            g.clearRect(rX, rY, rWidth, rHeight);
            g.drawRect(rX, rY, rWidth, rHeight);
            g.drawString(pageName, textLeft, place - 8);
        }
        o = this.getOffset();
        this.clearAllDrawn();
        this.opengadgets.clear();
        this.draggadgets.clear();
        int clip = this.clipping;
        int tclip = s.getLevel() + 1;
        if (tclip > clip) {
            clip = tclip;
        }
        this.frame.updateAddLabel(false);
        this.frame.updateCutCopy(false);
        this.frame.updatePaste();
        while (place < bounds.height) {
            int block;
            if (s.isSelecting()) {
                this.frame.updateCutCopy(true);
            }
            if (s.getDoc() == this.selectingdoc && s.getBlockNumber() == this.selectingblock) {
                ((TextStatement)s).setSelected(this.selectbegin, this.selectend);
                s.setFocus(true);
                this.selectingdoc = null;
                this.selectingblock = 0;
                this.selectbegin = 0;
                this.selectend = 0;
            }
            int displaywidth = this.setdisplaywidth(bounds.width);
            if (this.options.getShowFormat()) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.lightGray);
                g2d.drawLine(displaywidth, place, displaywidth, bounds.height);
                g2d.setColor(Color.black);
            }
            int newplace = s.draw(g, new Rectangle(30, 0, displaywidth, bounds.height), place, o, this.mycaret, reallydraw, dcf, this);
            if (!s.isDrawn()) break;
            if (s.isSelecting()) {
                this.frame.updateAddLabel(true);
            }
            if (this.marked.indexOf(new Integer(block = s.getBlockNumber())) != -1) {
                s.markOn(g);
                displaywidth = this.setdisplaywidth(bounds.width);
                s.draw(g, new Rectangle(30, 0, displaywidth, bounds.height), place, o, this.mycaret, reallydraw, dcf, this);
            }
            if (reallydraw) {
                Rectangle rect;
                int clevel = s.getLevel() + 1;
                if (this.isForced(this.doc, block)) {
                    g.drawString("\u2013", 5, place + 9);
                    g.drawString("\u2013", 5, place + 9);
                    rect = new Rectangle(4, place + 2, 6, 6);
                    this.opengadgets.put(new Integer(block), new OpenGadget(rect, block, this.doc, this));
                } else if (clevel >= this.clipping && s.getDown() != 0) {
                    g.drawString("+", 5, place + 9);
                    g.drawString("+", 5, place + 9);
                    rect = new Rectangle(4, place + 2, 6, 6);
                    this.opengadgets.put(new Integer(block), new OpenGadget(rect, block, this.doc, this));
                }
                g.setColor(Color.gray);
                rect = new Rectangle(1, place + 1, 3, newplace - place - 4);
                g.fillRect(1, place + 1, 3, newplace - place - 4);
                this.draggadgets.put(new Integer(block), new DragGadget(rect, block, this.doc, this));
                g.setColor(Color.black);
            }
            place = newplace;
            this.laststatement = s;
            if (this.isForced(this.doc, block) && (tclip = s.getLevel() + 2) > this.clipping) {
                clip = tclip;
            }
            if ((s = this.getNextStatement(s, clip, false)) == null) break;
            if (this.options.getPageMode()) {
                StatementBlock tPageHead;
                while (s.getStatementBlock().isPage() && (s = this.getNextStatement(s, clip, true)) != null) {
                }
                if (s == null || pageHead != (tPageHead = this.doc.whatsMyPage(s.getStatementBlock()))) break;
            }
            if ((tclip = s.getLevel() + 1) < clip) {
                clip = tclip;
            }
            if (clip < this.clipping) {
                clip = this.clipping;
            }
            o = 0;
        }
        if (this.doc.needSave() || this.isDirty()) {
            this.frame.updateSaveMenu(true);
            this.frame.updateRevertMenu(true);
            this.frame.updateUndo(true);
            this.title = new String("* ") + this.doc.getFilename();
            this.frame.setTitle(this.title);
        } else {
            this.frame.updateSaveMenu(false);
            this.frame.updateRevertMenu(false);
            this.title = this.doc.getFilename();
            this.frame.setTitle(this.title);
        }
    }

    Dimension getViewSize() {
        int dw = this.setdisplaywidth(this.getSize().width);
        return new Dimension(dw, this.getSize().height);
    }

    private int setdisplaywidth(int dw) {
        if (this.options.getShowFormat()) {
            int paperwidth = this.options.getPWidth() - this.options.getPLM() - this.options.getPRM();
            if ((paperwidth = paperwidth * 72 / 100 + 30) < dw) {
                dw = paperwidth;
            }
        }
        return dw;
    }

    private Statement getNextStatement(Statement s, int clip, boolean realnext) {
        Statement nextstatement;
        int next;
        if (realnext) {
            int sLevel = s.getLevel();
            clip = sLevel + 1;
        }
        if ((next = s.getSuccessor(clip)) == 0) {
            return null;
        }
        for (nextstatement = s.getNextStatement(); null != nextstatement; nextstatement = nextstatement.getNextStatement()) {
            if (next == nextstatement.getBlockNumber()) {
                return nextstatement;
            }
            if (nextstatement.isDirty()) {
                nextstatement.putStatement(this.getDisplayCharFormat());
            }
            s.setNextStatement(nextstatement);
        }
        nextstatement = this.doc.getStatement(next, this.options);
        s.setNextStatement(nextstatement);
        return nextstatement;
    }

    private void clearAllDrawn() {
        for (Statement s = this.getFirstStatement(); s != null; s = s.getNextStatement()) {
            s.clearDrawn();
        }
    }

    private boolean isDirty() {
        for (Statement s = this.getFirstStatement(); s != null; s = s.getNextStatement()) {
            if (!s.isDirty()) continue;
            return true;
        }
        return false;
    }

    private int uptoclip(int block, int clip) {
        int tblk;
        StatementBlock sb = this.doc.getStatementBlock(block);
        int level = sb.getLevel();
        while (level + 1 > clip && (tblk = sb.getUp()) != 0) {
            block = tblk;
            sb = this.doc.getStatementBlock(block);
            level = sb.getLevel();
        }
        return block;
    }

    private int getOffset() {
        return this.offset;
    }

    public Doc getDoc() {
        return this.doc;
    }

    private boolean isOnScreen(int block) {
        for (Statement s = this.getFirstStatement(); s != null; s = s.getNextStatement()) {
            if (block != s.getBlockNumber()) continue;
            return s.isDrawn();
        }
        return false;
    }

    Statement getFirstStatement() {
        if (this.anchorBlock == 0) {
            return null;
        }
        while (null != this.firststatement) {
            if (this.anchorBlock == this.firststatement.getBlockNumber() && this.doc == this.firststatement.getDoc()) {
                return this.firststatement;
            }
            if (this.firststatement.isDirty()) {
                this.firststatement.putStatement(this.getDisplayCharFormat());
            }
            this.firststatement = this.firststatement.getNextStatement();
        }
        this.firststatement = this.doc.getStatement(this.anchorBlock, this.options);
        return this.firststatement;
    }

    public Statement getLastStatement() {
        return this.laststatement;
    }

    private void insertAnchorBlock(int anchor) {
        if (this.doc == null) {
            return;
        }
        this.flush();
        Statement s = this.doc.getStatement(anchor, this.options);
        s.setNextStatement(this.firststatement);
        this.firststatement = s;
        this.anchorBlock = anchor;
        this.offset = 0;
        this.vbar.setPosition(this.anchorBlock, this.doc);
    }

    public void clearAllForced(Doc d) {
        if (this.docs.containsKey(d)) {
            this.docs.put(d, new Hashtable());
        }
    }

    public void addForced(Doc d, int block) {
        if (!this.docs.containsKey(d)) {
            this.docs.put(d, new Hashtable());
        }
        Hashtable<Integer, Doc> hd = this.docs.get(d);
        hd.put(new Integer(block), d);
    }

    public void delForced(Doc d, int block) {
        if (!this.docs.containsKey(d)) {
            this.docs.put(d, new Hashtable());
        }
        Hashtable<Integer, Doc> hd = this.docs.get(d);
        hd.remove(new Integer(block));
    }

    public boolean isForced(Doc d, int block) {
        if (!this.docs.containsKey(d)) {
            return false;
        }
        Hashtable<Integer, Doc> hd = this.docs.get(d);
        return hd.containsKey(new Integer(block));
    }

    protected void processComponentKeyEvent(KeyEvent e) {
        if (this.thedit == null) {
            this.thedit = new ThEdit(this.frame);
        }
        if (e.getKeyChar() == '\t' && e.getID() == 401) {
            this.thedit.editKey(5, e);
            e.consume();
        }
    }

    public void keyTyped(KeyEvent e) {
        Dimension bounds = this.getSize();
        if (this.marking) {
            this.toolkit.beep();
            return;
        }
        if (this.thedit == null) {
            this.thedit = new ThEdit(this.frame);
        }
        this.thedit.editKey(5, e);
        Point caretpoint = this.mycaret.getCaretPoint();
        if (caretpoint.y > bounds.height - 15) {
            this.scrollLineDown();
            this.recompute();
        }
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        char character = e.getKeyChar();
        Dimension bounds = this.getSize();
        if (character == '\uffff' && (code == 38 || code == 40 || code == 37 || code == 39)) {
            if (this.thedit == null) {
                this.thedit = new ThEdit(this.frame);
            }
            this.thedit.editKey(6, e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        int modifiers = e.getModifiers();
        int x = e.getX();
        int y = e.getY();
        if (e.getClickCount() == 1 && this.options.getSCJ() && 4 == (modifiers & 4)) {
            if (this.marking) {
                this.toolkit.beep();
                return;
            }
            this.options.setSCJ(false);
            this.thjump = new ThJump(this.frame);
            this.thjump.doubleClick(e, x, y);
            this.thjump = null;
            this.options.setSCJ(true);
        }
        if (e.getClickCount() == 2) {
            if (this.marking) {
                this.toolkit.beep();
                return;
            }
            this.thjump = new ThJump(this.frame);
            this.thjump.doubleClick(e, x, y);
            this.thjump = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.frame.errormsg("");
        this.activedrag = null;
        if (this.marking) {
            if (!this.activecommand.cmdContinue(e)) {
                this.marking = false;
                this.activecommand = null;
                this.setCursor(Cursor.getPredefinedCursor(2));
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        if (!this.draggadgets.isEmpty()) {
            Enumeration<DragGadget> enumi = this.draggadgets.elements();
            while (enumi.hasMoreElements()) {
                DragGadget g = enumi.nextElement();
                if (!g.contains(x, y)) continue;
                g.mouseDown(x, y);
                this.activedrag = g;
                return;
            }
        }
        if (this.thedit == null) {
            this.thedit = new ThEdit(this.frame);
        }
        this.thedit.editMouse(1, e);
        this.requestFocusInWindow();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.activedrag != null) {
            this.activedrag.mouseUp();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.findfocus() != null) {
            this.requestFocus();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int mouseX = e.getX();
        int mouseY = e.getY();
        if (this.marking) {
            return;
        }
        if (this.firststatement != null) {
            Statement st;
            Object g;
            Enumeration<Object> ienum;
            if (!this.opengadgets.isEmpty()) {
                ienum = this.opengadgets.elements();
                while (ienum.hasMoreElements()) {
                    g = ienum.nextElement();
                    if (!((OpenGadget)g).contains(mouseX, mouseY)) continue;
                    this.setCursor(Cursor.getPredefinedCursor(1));
                    return;
                }
            }
            if (!this.draggadgets.isEmpty()) {
                ienum = this.draggadgets.elements();
                while (ienum.hasMoreElements()) {
                    g = (DragGadget)ienum.nextElement();
                    if (!((DragGadget)g).contains(mouseX, mouseY)) continue;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
            }
            if ((st = this.findstatement(mouseX, mouseY)) != null && st.isText()) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        Statement st;
        int mouseX = e.getX();
        int mouseY = e.getY();
        if (this.activedrag != null) {
            this.activedrag.mouseDrag(e, mouseX, mouseY);
            return;
        }
        if (this.firststatement != null && (st = this.findfocus()) != null) {
            st.mouseDrag(this, e, mouseX, mouseY);
            this.repaintselected(st);
            this.requestFocus();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int wheelmoved = e.getWheelRotation();
        if (wheelmoved > 0) {
            this.scrollLineDown();
        } else {
            this.scrollLineUp();
        }
    }

    public int print(Graphics g, PageFormat pf, int index) {
        return this.printObject.print(g, pf, index);
    }
}

