/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DragGadget {
    Rectangle rect;
    int block;
    DocView docview;
    Doc doc;
    int initialx;
    int initialy;
    JLabel line1;
    JLabel line2;
    JPanel pane = null;
    int offset;
    int level = -1;
    Icon rightarrow;
    Icon downarrow;
    Icon rightarrowp;
    Icon downarrowp;
    JPanel bar;
    int targetblk;
    protected boolean isCopy = false;

    public DragGadget(Rectangle r, int b, Doc d, DocView dv) {
        this.rect = r;
        this.block = b;
        this.doc = d;
        this.docview = dv;
        this.initialx = 0;
        this.initialy = 0;
        this.rightarrow = new ArrowIcon(ArrowIcon.RIGHT, this);
        this.downarrow = new ArrowIcon(ArrowIcon.DOWN, this);
    }

    public boolean contains(int x, int y) {
        return this.rect.contains(x, y);
    }

    public void mouseDown(int x, int y) {
        this.initialx = x;
        this.initialy = y;
        this.line1 = null;
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        Statement s;
        if (this.pane == null) {
            this.docview.getFrame().getWindowManager().flushAllWindows(this.doc);
            Statement s2 = this.doc.getStatement(this.block, null);
            byte[] text = s2.getBytes();
            int len = Cbytes.strlen(text, 0);
            if (len > 40) {
                len = 40;
            }
            String str = new String(text, 0, len);
            int lvl = s2.getLevel();
            this.offset = lvl * 3 * 9 + 10;
            this.bar = new JPanel();
            this.bar.setSize(this.rect.width, this.rect.height);
            this.bar.setBackground(Color.gray);
            this.line1 = new JLabel(str);
            Dimension d = new Dimension(16, 200);
            this.line1.setPreferredSize(d);
            this.line2 = new JLabel();
            d = new Dimension(16, 200);
            this.pane = new JPanel();
            this.line2.setPreferredSize(d);
            this.pane.setOpaque(false);
            this.pane.setSize(200, 34);
            this.pane.setBackground(Color.white);
            this.pane.setLayout(new GridLayout(0, 1));
            if (s2.isImage()) {
                double ratio;
                this.pane.setSize(200, 134);
                ImageIcon imI = ((ImageStatement)s2).getImageIcon();
                int iH = imI.getIconHeight();
                int iW = imI.getIconWidth();
                Image im = imI.getImage();
                if (iH > 100) {
                    ratio = 100.0 / (double)iH;
                    iH = 100;
                    double diW = (double)iW * ratio;
                    iW = (int)diW;
                }
                if (iW > 100) {
                    ratio = 100.0 / (double)iW;
                    iW = 100;
                    double diH = (double)iH * ratio;
                    iH = (int)diH;
                }
                this.pane.setSize(iW, iH + 14);
                Image sim = im.getScaledInstance(iW, iH, 1);
                imI = new ImageIcon(sim);
                myPictPanel gp = new myPictPanel(imI);
                this.pane.add(gp);
                this.pane.add(this.line2);
            } else {
                this.pane.add(this.line1);
                this.pane.add(this.line2);
            }
            this.docview.getFrame().addDrag(this.pane);
            this.docview.getFrame().addDrag(this.bar);
            this.pane.repaint();
            this.pane.setLocation(this.rect.x + this.offset, this.rect.y + ThWindow.ACTIONVERT);
            this.bar.setLocation(this.rect.x, this.rect.y + ThWindow.ACTIONVERT);
        }
        int dx = x - this.initialx;
        int dy = y - this.initialy;
        this.pane.setLocation(this.rect.x + dx + this.offset, this.rect.y + dy + ThWindow.ACTIONVERT);
        this.bar.setLocation(this.rect.x + dx, this.rect.y + dy + ThWindow.ACTIONVERT);
        int modifiers = e.getModifiers();
        this.isCopy = false;
        if ((modifiers & 1) != 0) {
            this.isCopy = true;
        }
        if ((s = this.docview.findstatement(x, y)) != null) {
            this.level = this.validateTarget(x, s);
            this.line2.setIcon(null);
            if (this.level == 0) {
                this.line2.setIcon(this.downarrow);
            }
            if (this.level == 1) {
                this.line2.setIcon(this.rightarrow);
            }
            this.pane.repaint();
            Rectangle bounds = this.docview.getBounds();
            if (y > bounds.height - 15) {
                this.docview.scrollLineDown();
            }
            if (y < bounds.y - ThWindow.ACTIONVERT + 10) {
                this.docview.scrollLineUp();
            }
        }
    }

    public void mouseUp() {
        if (this.pane == null) {
            return;
        }
        this.docview.getFrame().removeDrag(this.pane);
        this.docview.getFrame().removeDrag(this.bar);
        this.docview.repaint();
        if (this.level != -1) {
            StatementBlock movesb = this.doc.getStatementBlock(this.block);
            StatementBlock targetsb = this.doc.getStatementBlock(this.targetblk);
            if (this.isCopy) {
                new ThCopy(this.docview.getFrame()).copyBranch(movesb, targetsb, this.level);
            } else {
                new ThMove(this.docview.getFrame()).moveBranch(movesb, targetsb, this.level);
            }
        }
    }

    private int validateTarget(int x, Statement s) {
        int lvl = s.getLevel();
        int targetoffset = lvl * 3 * 9 + 10;
        int blk = this.targetblk = s.getBlockNumber();
        if (!this.isCopy || blk != this.block) {
            while (blk != 0) {
                if (blk == this.block) {
                    return -1;
                }
                StatementBlock sb = this.doc.getStatementBlock(blk);
                blk = sb.getUp();
            }
        }
        if (x < targetoffset) {
            return -1;
        }
        if (x > targetoffset + 30) {
            return 1;
        }
        return 0;
    }
}

