/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class EditMenu
extends JMenu
implements ActionListener {
    ThWindow frame;
    JMenuItem mcut;
    JMenuItem mcopy;
    JMenuItem mpaste;
    JMenuItem mundo;
    JMenuItem mfind;
    JMenuItem mfindagain;
    JMenuItem mreplace;
    ThSearch thsearch = null;

    public EditMenu(ThWindow f) {
        super("Edit");
        this.frame = f;
        this.mcut = new JMenuItem("Cut");
        this.mcut.setAccelerator(KeyStroke.getKeyStroke(88, 4));
        this.mcopy = new JMenuItem("Copy");
        this.mcopy.setAccelerator(KeyStroke.getKeyStroke(67, 4));
        this.mpaste = new JMenuItem("Paste");
        this.mpaste.setAccelerator(KeyStroke.getKeyStroke(86, 4));
        this.mundo = new JMenuItem("Undo typing");
        this.mundo.setAccelerator(KeyStroke.getKeyStroke(90, 4));
        this.mfind = new JMenuItem("Find");
        this.mfindagain = new JMenuItem("Find Again");
        this.mreplace = new JMenuItem("Replace");
        this.mcut.setEnabled(false);
        this.mcopy.setEnabled(false);
        this.mpaste.setEnabled(false);
        this.add(this.mundo);
        this.mundo.addActionListener(this);
        this.mundo.setEnabled(false);
        this.addSeparator();
        this.add(this.mcut);
        this.mcut.addActionListener(this);
        this.add(this.mcopy);
        this.mcopy.addActionListener(this);
        this.add(this.mpaste);
        this.mpaste.addActionListener(this);
        this.addSeparator();
        this.add(this.mfind);
        this.mfind.addActionListener(this);
        this.mfind.setAccelerator(KeyStroke.getKeyStroke(70, 4));
        this.add(this.mfindagain);
        this.mfindagain.addActionListener(this);
        this.mfindagain.setAccelerator(KeyStroke.getKeyStroke(71, 4));
        this.mfindagain.setEnabled(false);
        this.add(this.mreplace);
        this.mreplace.addActionListener(this);
        this.mreplace.setAccelerator(KeyStroke.getKeyStroke(61, 4));
        this.mreplace.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem mi = (JMenuItem)e.getSource();
        if (mi == this.mcopy || mi == this.mcut) {
            DocView docview = this.frame.getDocView();
            Statement st = docview.findfocus();
            if (st != null) {
                Clipboard cb;
                if (!st.isText()) {
                    return;
                }
                String str = st.returnSelected();
                if (str != null && (cb = Toolkit.getDefaultToolkit().getSystemClipboard()) != null) {
                    StringSelection ss = new StringSelection(str);
                    cb.setContents(ss, null);
                    if (mi == this.mcut) {
                        ((TextStatement)st).removeSelected();
                        this.frame.getWindowManager().repaintAllWindows(this.frame.getDoc());
                    }
                }
            }
        } else if (mi == this.mpaste) {
            try {
                String str = clipContents.getClipContents(this);
                if (str != null) {
                    Statement st = this.frame.getDocView().findfocus();
                    if (!st.isText()) {
                        return;
                    }
                    TextStatement tst = (TextStatement)st;
                    CharFormat cf = this.frame.getDocView().getDisplayCharFormat();
                    tst.removeSelected();
                    tst.insertString(str, cf);
                    this.frame.getWindowManager().repaintAllWindows(this.frame.getDoc());
                }
            }
            catch (Exception er) {}
        } else if (mi == this.mundo) {
            DocView docview = this.frame.getDocView();
            Statement st = docview.findfocus();
            if (st != null) {
                st.unDo();
            }
            this.mundo.setEnabled(false);
            docview.repaint();
        } else if (mi == this.mfind) {
            this.mfindagain.setEnabled(false);
            this.mreplace.setEnabled(false);
            this.frame.errormsg("");
            this.thsearch = new ThSearch(this.frame);
            if (this.thsearch.startSearch()) {
                this.mfindagain.setEnabled(true);
                this.mreplace.setEnabled(true);
            } else {
                this.thsearch = null;
                this.frame.errormsg("Search Ended");
            }
        } else if (mi == this.mfindagain) {
            if (this.thsearch == null) {
                return;
            }
            this.frame.errormsg("");
            if (this.thsearch.continueSearch()) {
                this.mfindagain.setEnabled(true);
                this.mreplace.setEnabled(true);
            } else {
                this.mfindagain.setEnabled(false);
                this.mreplace.setEnabled(false);
                this.thsearch = null;
                this.frame.errormsg("Search Ended");
            }
        } else if (mi == this.mreplace) {
            if (this.thsearch == null) {
                return;
            }
            this.thsearch.doreplace();
        }
    }

    public void updateUndo(boolean undo) {
        this.mundo.setEnabled(undo);
    }

    public void updateCutCopy(boolean selected) {
        this.mcopy.setEnabled(selected);
        this.mcut.setEnabled(selected);
    }

    public void updatePaste() {
        this.mpaste.setEnabled(true);
    }
}

