/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

class FileMenu
extends JMenu
implements ActionListener {
    ThWindow frame;
    ThPrint thp;
    JMenuItem mnew;
    JMenuItem mopen;
    JMenuItem msave;
    JMenuItem msaveas;
    JMenuItem msaveopts;
    JMenuItem mrevert;
    JMenuItem mprint;
    JMenuItem mpagesetup;
    JMenuItem mquit;
    JMenuItem mexport;
    JMenuItem mGetOptions;
    JMenuItem mBuildIndex;
    JMenuItem mimport;
    JMenuItem mRegister;

    public FileMenu(ThWindow f) {
        super("File");
        this.frame = f;
        this.mnew = new JMenuItem("New");
        this.mopen = new JMenuItem("Open", 79);
        this.mopen.setAccelerator(KeyStroke.getKeyStroke(79, 4));
        this.msave = new JMenuItem("Save", 83);
        this.msave.setAccelerator(KeyStroke.getKeyStroke(83, 4));
        this.msaveas = new JMenuItem("SaveAs");
        this.msaveopts = new JMenuItem("Save Options");
        this.mrevert = new JMenuItem("Revert");
        this.mquit = new JMenuItem("Quit", 81);
        this.mquit.setAccelerator(KeyStroke.getKeyStroke(81, 4));
        this.mprint = new JMenuItem("Print");
        this.mpagesetup = new JMenuItem("Page Setup");
        this.mexport = new JMenuItem("Export...");
        this.mimport = new JMenuItem("Import...");
        this.mGetOptions = new JMenuItem("Get Options");
        this.mBuildIndex = new JMenuItem("Build Index");
        this.mRegister = new JMenuItem("Register");
        this.add(this.mnew);
        this.mnew.addActionListener(this);
        this.add(this.mopen);
        this.mopen.addActionListener(this);
        this.add(this.msave);
        this.msave.addActionListener(this);
        this.add(this.msaveas);
        this.msaveas.addActionListener(this);
        this.add(this.msaveopts);
        this.msaveopts.addActionListener(this);
        this.add(this.mGetOptions);
        this.mGetOptions.addActionListener(this);
        this.add(this.mrevert);
        this.mrevert.addActionListener(this);
        this.addSeparator();
        this.add(this.mexport);
        this.mexport.addActionListener(this);
        this.add(this.mimport);
        this.mimport.addActionListener(this);
        this.add(this.mpagesetup);
        this.mpagesetup.addActionListener(this);
        this.add(this.mprint);
        this.mprint.addActionListener(this);
        this.addSeparator();
        this.add(this.mBuildIndex);
        this.mBuildIndex.addActionListener(this);
        this.add(this.mRegister);
        this.mRegister.addActionListener(this);
        this.addSeparator();
        this.add(this.mquit);
        this.mquit.addActionListener(this);
    }

    public void updateSaveMenu(boolean en) {
        this.msave.setEnabled(en);
        this.msaveas.setEnabled(true);
    }

    public void updateRevertMenu(boolean en) {
        this.mrevert.setEnabled(en);
    }

    public void updateRegistration(boolean en) {
        this.mRegister.setEnabled(en);
    }

    public void actionPerformed(ActionEvent e) {
        Registration r;
        JMenuItem mi = (JMenuItem)e.getSource();
        LabelString ls = null;
        if (mi == this.mnew) {
            this.donew();
            return;
        }
        if (mi == this.mopen) {
            try {
                DocManager docmanager = this.frame.getDocManager();
                ls = docmanager.findDoc(this.frame);
            }
            catch (IOException ie) {
                ls = null;
            }
            if (ls == null) {
                return;
            }
            Rectangle bounds = this.frame.getBounds();
            int x = bounds.width / 2;
            int y = bounds.height / 2;
            new ThJump(this.frame).jumpLabelString(ls, x, y);
        } else if (mi == this.msave) {
            DocView docview = this.frame.getDocView();
            Doc doc = this.frame.getDoc();
            docview.flushrelease();
            doc.doSave();
            docview.doSaveSeeThrough();
            docview.repaint();
        } else if (mi == this.msaveas) {
            String fullname;
            DocView docview = this.frame.getDocView();
            Doc doc = this.frame.getDoc();
            if (doc == null) {
                this.donew();
                return;
            }
            docview.flushrelease();
            NewDoc newdoc = new NewDoc(this.frame);
            try {
                fullname = newdoc.makeDocument("SaveAs");
            }
            catch (IOException ioe) {
                this.frame.errormsg(ioe.getMessage());
                return;
            }
            doc = this.frame.getDoc();
            if (!doc.doSaveAs(fullname)) {
                this.frame.errormsg("SaveAs failed");
            }
            this.frame.getWindowManager().revertAllWindows(doc);
            String docname = new String(fullname + ",");
            ls = new LabelString(docname, this.frame.getOptions(), this.frame.getDoc());
            this.frame.setDoc(ls, true);
            this.frame.getOptions().saveOptions();
        } else if (mi == this.msaveopts) {
            Rectangle bounds = this.frame.getBounds();
            this.frame.getOptions().setWindowRect(bounds);
            this.frame.getOptions().saveOptions();
            this.frame.getWindowManager().repaintAllWindows(this.frame.getDoc());
        } else if (mi == this.mGetOptions) {
            this.frame.setOptions();
            this.frame.getDocView().flushrelease();
            this.frame.getDocView().repaint();
        } else if (mi == this.mrevert) {
            DocView docview = this.frame.getDocView();
            Doc doc = this.frame.getDoc();
            WindowManager windowmanager = this.frame.getWindowManager();
            docview.flushrelease();
            int n = JOptionPane.showConfirmDialog(this.frame, "Confirm Discard of Changes", "Discard Changes?", 0);
            if (n == 0) {
                windowmanager.revertAllWindows(doc);
                doc.clearRevertBlk();
            }
            docview.repaint();
        } else if (mi == this.mexport) {
            DocView docview = this.frame.getDocView();
            Doc doc = docview.getDoc();
            docview.startMarking(new ThExport(this.frame, doc), 0);
        } else if (mi == this.mimport) {
            DocView docview = this.frame.getDocView();
            Doc doc = docview.getDoc();
            docview.startMarking(new ThImport(this.frame, doc), 0);
        } else if (mi == this.mquit) {
            WindowManager wm = this.frame.getWindowManager();
            wm.quit(this.frame);
        } else if (mi == this.mBuildIndex) {
            DocView docview = this.frame.getDocView();
            docview.startMarking(new ThBuildIndex(this.frame), 0);
        } else if (mi == this.mprint) {
            DocView docview = this.frame.getDocView();
            Doc doc = docview.getDoc();
            this.thp = new ThPrint(this.frame, doc, this.frame.getDocView());
            docview.startMarking(this.thp, 0);
        } else if (mi == this.mpagesetup) {
            PageSetup ps = new PageSetup(this.frame, this.frame.getOptions());
            ps.setVisible(true);
            this.frame.getDocView().repaint();
        } else if (mi == this.mRegister && !(r = new Registration(this.frame)).do_register()) {
            this.frame.errormsg("Registration Failed");
        }
    }

    private void donew() {
        ThWindow tframe;
        String fullname;
        NewDoc newdoc = new NewDoc(this.frame);
        try {
            fullname = newdoc.makeDocument("Create");
        }
        catch (IOException ioe) {
            this.frame.errormsg(ioe.getMessage());
            return;
        }
        Doc doc = this.frame.getDocManager().openDoc(fullname);
        if (doc == null) {
            this.frame.errormsg("Document Create Failed");
            return;
        }
        String winname = doc.getFilename();
        Rectangle fbounds = this.frame.getBounds();
        try {
            tframe = this.frame.getWindowManager().makeWindow(winname, fbounds.x + 40, fbounds.y + 40, 600, 400);
        }
        catch (IOException ioe) {
            this.frame.errormsg("Window Create Failed");
            return;
        }
        String docname = new String(fullname + ",");
        LabelString ls = new LabelString(docname, this.frame.getOptions(), this.frame.getDoc());
        tframe.setDoc(ls, true);
        tframe.setVisible(true);
    }
}

