/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GraphicsEnvironment;
import java.util.Properties;

class FontTable {
    String[] faces = new String[]{"Monaco", "System", "Arial", "Geneva", "Console", "Times Roman", "Helvetica", "Courier", "Symbol", "Impact", "Arial Black", "Palatino", "Palatino", "Verdana", "New Century Schoolbook"};
    int[] fontnum = new int[]{0, 1, 2, 3, 4, 20, 21, 22, 23, 25, 26, 28, 29, 31, 34};
    String[] systemFontNames;

    public FontTable() {
        Properties sp = System.getProperties();
        String version = sp.getProperty("java.version");
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.systemFontNames = gEnv.getAvailableFontFamilyNames();
        if (this.verifyFont("Times")) {
            for (int i = 0; i < this.fontnum.length; ++i) {
                if (this.fontnum[i] != 20) continue;
                this.faces[i] = "Times";
                break;
            }
        }
    }

    public boolean verifyFont(String fontname) {
        for (int i = 0; i < this.systemFontNames.length; ++i) {
            if (fontname.compareTo(this.systemFontNames[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public String whatFace(int num) {
        for (int i = 0; i < this.fontnum.length; ++i) {
            if (this.fontnum[i] != num) continue;
            return this.faces[i];
        }
        return this.faces[0];
    }

    public int whatNum(String face) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (face.compareTo(this.faces[i]) != 0) continue;
            return this.fontnum[i];
        }
        return this.fontnum[0];
    }

    public String[] fontNames() {
        return this.faces;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.systemFontNames;
    }
}

