/*
 * Decompiled with CFR 0.152.
 */
class HeadFootBlock {
    int block1;
    int block2;
    Doc doc;
    String lefthead;
    String righthead;
    String leftfoot;
    String rightfoot;

    public HeadFootBlock(Doc d, int b) {
        byte[] buf = new byte[128];
        this.doc = d;
        this.block1 = b;
        d.getBlock(buf, 0, this.block1);
        this.block2 = Cbytes.byteToInt(buf, 0);
        this.lefthead = new String(buf, 4, Cbytes.strlen(buf, 4));
        this.leftfoot = new String(buf, 66, Cbytes.strlen(buf, 66));
        d.getBlock(buf, 0, this.block2);
        this.righthead = new String(buf, 4, Cbytes.strlen(buf, 4));
        this.rightfoot = new String(buf, 66, Cbytes.strlen(buf, 66));
    }

    public HeadFootBlock(Doc d) {
        this.doc = d;
        this.block1 = this.doc.allocateBlock();
        this.block2 = this.doc.allocateBlock();
        this.righthead = new String();
        this.lefthead = new String();
        this.rightfoot = new String();
        this.leftfoot = new String();
    }

    public String getRightHead() {
        return this.righthead;
    }

    public String getLeftHead() {
        return this.lefthead;
    }

    public String getRightFoot() {
        return this.rightfoot;
    }

    public String getLeftFoot() {
        return this.leftfoot;
    }

    public int getBlockNumber() {
        return this.block1;
    }

    public void putRightHead(String rh) {
        this.righthead = rh;
    }

    public void putLeftHead(String lh) {
        this.lefthead = lh;
    }

    public void putRightFoot(String rf) {
        this.rightfoot = rf;
    }

    public void putLeftFoot(String lf) {
        this.leftfoot = lf;
    }

    public void putBlock() {
        int i;
        byte[] buf = new byte[128];
        Cbytes.intToByte(this.block2, buf, 0);
        byte[] tbytes = this.lefthead.getBytes();
        int len = this.lefthead.length();
        if (len > 61) {
            len = 61;
        }
        for (i = 0; i < len; ++i) {
            buf[i + 4] = tbytes[i];
        }
        tbytes = this.leftfoot.getBytes();
        len = this.leftfoot.length();
        if (len > 61) {
            len = 61;
        }
        for (i = 0; i < len; ++i) {
            buf[i + 66] = tbytes[i];
        }
        this.doc.putBlock(buf, 0, this.block1, false);
        for (i = 0; i < 128; ++i) {
            buf[i] = 0;
        }
        tbytes = this.righthead.getBytes();
        len = this.righthead.length();
        if (len > 61) {
            len = 61;
        }
        for (i = 0; i < len; ++i) {
            buf[i + 4] = tbytes[i];
        }
        tbytes = this.rightfoot.getBytes();
        len = this.rightfoot.length();
        if (len > 61) {
            len = 61;
        }
        for (i = 0; i < len; ++i) {
            buf[i + 66] = tbytes[i];
        }
        this.doc.putBlock(buf, 0, this.block2, false);
    }

    public void freeBlocks() {
        this.doc.freeBlock(this.block1);
        this.doc.freeBlock(this.block2);
    }
}

