/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

class ImageStatement
extends Statement {
    int stheight;
    Image image;
    ImageIcon iI;
    byte[] backupText;
    boolean backupDirty;
    int backupLength;
    boolean backedup;
    String backupRHead = null;
    String backupRFoot = null;
    String backupLHead = null;
    String backupLFoot = null;

    public ImageStatement(Doc d, int anchor, Options opts) {
        int tl;
        this.sttop = 0;
        this.stleft = 0;
        this.stright = 0;
        this.stbottom = 0;
        this.drawn = false;
        this.isanimage = true;
        this.dirty = false;
        this.rhead = null;
        this.lhead = null;
        this.rfoot = null;
        this.lfoot = null;
        this.stheight = 12;
        this.focus = false;
        this.nextstatement = null;
        this.doc = d;
        this.options = opts;
        this.sb = d.getStatementBlock(anchor);
        this.length = this.sb.getLength();
        this.text = new byte[this.length + 100];
        int offset = 0;
        int i = tl = this.length;
        if (i > 80) {
            i = 80;
        }
        this.sb.getV2Data(this.text, offset, i);
        tl -= i;
        offset += i;
        int chain = this.sb.getChain();
        while (tl > 0) {
            ChainBlock cb = this.doc.getChainBlock(chain);
            i = tl;
            if (i > 124) {
                i = 124;
            }
            cb.getData(this.text, offset, i);
            tl -= i;
            offset += i;
            chain = cb.getChain();
        }
        this.iI = new ImageIcon(this.text);
        this.image = this.iI.getImage();
        if ((this.sb.getV2Fmt() & 2) == 2) {
            this.hfb = new HeadFootBlock(this.doc, this.sb.getHeadFoot());
            this.lhead = this.hfb.getLeftHead();
            this.rhead = this.hfb.getRightHead();
            this.lfoot = this.hfb.getLeftFoot();
            this.rfoot = this.hfb.getRightFoot();
        }
    }

    public ImageIcon getImageIcon() {
        return this.iI;
    }

    public byte[] getText() {
        return this.text;
    }

    public boolean putStatement(CharFormat cf) {
        int tchainblock;
        ChainBlock chain;
        if (!this.isDirty()) {
            return false;
        }
        if (this.freed) {
            return false;
        }
        int len = this.length;
        this.sb.putLength(len);
        this.sb.setImage(true);
        this.sb.setTime();
        int offset = 0;
        int i = this.sb.putV2Data(this.text, offset, len);
        len -= i;
        offset += i;
        int chainblock = this.sb.getChain();
        this.sb.putChain(0);
        this.sb.putBlock();
        while (chainblock != 0) {
            chain = this.doc.getChainBlock(chainblock);
            tchainblock = chain.getChain();
            this.doc.freeBlock(chainblock);
            chainblock = tchainblock;
        }
        if (len > 0) {
            ChainBlock tchain = this.doc.getChainBlock();
            tchainblock = tchain.getBlockNumber();
            i = tchain.setData(this.text, offset, len);
            len -= i;
            offset += i;
            this.sb.putChain(tchainblock);
            this.sb.putBlock();
            tchain.putBlock();
            chainblock = 0;
            chain = null;
            while (len != 0) {
                chain = this.doc.getChainBlock();
                chainblock = chain.getBlockNumber();
                i = chain.setData(this.text, offset, len);
                len -= i;
                offset += i;
                tchain.setChain(chainblock);
                tchain.putBlock();
                tchainblock = chainblock;
                tchain = chain;
            }
            if (chainblock != 0) {
                chain.setChain(0);
                chain.putBlock();
            }
        }
        if (this.lhead != null) {
            if (this.hfb == null) {
                this.hfb = new HeadFootBlock(this.doc);
            }
            this.hfb.putLeftHead(this.lhead);
            this.hfb.putRightHead(this.rhead);
            this.hfb.putLeftFoot(this.lfoot);
            this.hfb.putRightFoot(this.rfoot);
            this.hfb.putBlock();
            int hfblk = this.hfb.getBlockNumber();
            this.sb.putHeadFoot(hfblk);
        }
        this.dirty = false;
        return true;
    }

    public void getStatementImage(ThWindow frame) {
        JFileChooser file_dialog = new JFileChooser(frame.getHome());
        file_dialog.setDialogType(0);
        file_dialog.setDialogTitle("Choose an Image file");
        int retval = file_dialog.showOpenDialog(frame);
        if (retval == 0) {
            File file = file_dialog.getSelectedFile();
            String fname = file.getPath();
            FileInputStream istream = null;
            try {
                istream = new FileInputStream(file);
            }
            catch (FileNotFoundException fnf) {
                return;
            }
            try {
                this.length = istream.available();
                this.text = new byte[this.length + 100];
                istream.read(this.text, 0, this.length);
                istream.close();
                this.iI = new ImageIcon(this.text);
                this.image = this.iI.getImage();
                if (this.image == null) {
                    this.text = new byte[100];
                    this.length = 0;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.dirty = true;
            this.putStatement(null);
        }
    }

    public StatementBlock copyStatement() {
        ImageStatement newst = (ImageStatement)this.doc.getStatement(this.options, true);
        newst.text = new byte[this.length + 100];
        for (int i = 0; i < this.length; ++i) {
            newst.text[i] = this.text[i];
        }
        newst.length = this.length;
        if (this.lhead != null) {
            newst.lhead = new String(this.lhead);
            newst.rhead = new String(this.rhead);
            newst.lfoot = new String(this.lfoot);
            newst.rfoot = new String(this.rfoot);
        }
        newst.dirty = true;
        newst.putStatement(null);
        return newst.sb;
    }

    public int draw(Graphics g, Rectangle d, int top, int offset, MyCaret mycaret, boolean drawit, CharFormat dcf, Component c) {
        int indent = d.x;
        if (this.options.getShowLevel()) {
            indent += 20;
        }
        this.sttop = top;
        this.stleft = this.sb.getLevel() * 2 * 9 + indent;
        this.stright = d.width;
        this.drawn = false;
        if (this.image == null) {
            if (drawit) {
                g.drawRect(this.stleft, top, 100, 100);
            }
            if (drawit) {
                g.setFont(new Font("Times", 1, 12));
            }
            if (drawit) {
                g.drawString("Mac Pict Image", this.stleft + 10, top + 55);
            }
            this.drawn = true;
            this.stbottom = this.sttop + 100 + this.stheight / 2;
            return this.sttop + 100 + this.stheight / 2;
        }
        MediaTracker mt = new MediaTracker(c);
        mt.addImage(this.image, 1);
        try {
            mt.waitForID(1);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.stbottom = this.sttop + this.image.getHeight(null);
        if (d.x != 30 && this.stbottom > d.height) {
            return top;
        }
        if (drawit) {
            this.iI.paintIcon(c, g, this.stleft, this.sttop);
        }
        this.drawn = true;
        if (drawit && this.options.getShowLevel() && (this.sb.getV2Fmt() & 0x20) != 32) {
            g.drawString(this.doc.whatsMyLevel(this.sb, "."), d.x, this.sttop + this.stheight - 3);
        }
        if (this.selecting) {
            g.drawRect(this.stleft - 2, this.sttop - 2, this.image.getWidth(null) + 3, this.image.getHeight(null) + 3);
        }
        if (drawit && this.options.getShowDate()) {
            this.drawDateLine(g, d, this.stbottom, this.stheight);
            this.stbottom += this.stheight;
        }
        int place = this.stbottom;
        short spacing = this.options.getSpacing();
        if (spacing == 1) {
            place += this.stheight;
        }
        if (spacing == 2) {
            place += this.stheight / 2;
        }
        if (spacing == 3) {
            place += this.stheight / 3;
        }
        return place;
    }

    public boolean mouseDown(DocView docview, MyCaret mycaret, MouseEvent e, int x, int y) {
        if (this.focus) {
            this.selecting = true;
            mycaret.clearCaret();
            mycaret.hideCaret();
            mycaret.setCaretStatement(null, 0, 0);
        }
        this.backupStatement();
        return true;
    }

    public boolean mouseUp(DocView docview, MouseEvent e, int x, int y) {
        return true;
    }

    public void unDo() {
        if (this.backedup) {
            this.restoreStatement();
        }
    }

    public boolean isGIF() {
        return this.text[0] == 71 && this.text[1] == 73 && this.text[2] == 70;
    }

    public boolean isJPG() {
        return this.text[6] == 74 && this.text[7] == 70 && this.text[8] == 73;
    }

    private void backupStatement() {
        this.backupLength = this.length;
        if (this.backupText == null) {
            this.backupText = new byte[this.length];
        }
        for (int i = 0; i < this.length; ++i) {
            this.backupText[i] = this.text[i];
        }
        this.backupDirty = this.isDirty();
        if (this.rhead != null) {
            this.backupRHead = new String(this.rhead);
        }
        if (this.lhead != null) {
            this.backupLHead = new String(this.lhead);
        }
        if (this.rfoot != null) {
            this.backupRFoot = new String(this.rfoot);
        }
        if (this.lfoot != null) {
            this.backupLFoot = new String(this.lfoot);
        }
        this.backedup = true;
    }

    private void restoreStatement() {
        this.length = this.backupLength;
        this.dirty = this.backupDirty;
        for (int i = 0; i < this.length; ++i) {
            this.text[i] = this.backupText[i];
        }
        if (this.backupRHead != null) {
            this.rhead = this.backupRHead;
            this.backupRHead = null;
        }
        if (this.backupRFoot != null) {
            this.rfoot = this.backupRFoot;
            this.backupRFoot = null;
        }
        if (this.backupLHead != null) {
            this.lhead = this.backupLHead;
            this.backupLHead = null;
        }
        if (this.backupLFoot != null) {
            this.lfoot = this.backupLFoot;
            this.backupLFoot = null;
        }
        this.backedup = false;
        this.image = Gif.arraytoGif(this.text, this.length);
    }
}

