/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JTextArea;

class Labels {
    Doc doc;
    private final int LOOKUP = 0;
    private final int ADD = 1;
    private final int DELETE = 2;

    public Labels(Doc d) {
        this.doc = d;
    }

    public Labels(int firsthash, RandomAccessFile file) throws IOException {
        byte[] buf = new byte[128];
        file.seek(firsthash * 128);
        file.write(buf, 0, 128);
        file.write(buf, 0, 128);
        file.write(buf, 0, 128);
        file.write(buf, 0, 128);
    }

    public void addLabel(String label, int blocknumber) {
        this.lookup(label, blocknumber, 1);
    }

    public void delLabel(String label, int blocknumber) {
        this.lookup(label, blocknumber, 2);
    }

    public DocLink lookupLabel(String label) throws NoSuchElementException {
        DocLink dl;
        if (label != null && label.indexOf(48) == 0) {
            int i = label.indexOf(98);
            if (i < 0) {
                i = label.indexOf(66);
            }
            if (i != -1) {
                try {
                    int block = Integer.parseInt(label.substring(0, i));
                    if (this.doc.validateStatementBlock(block)) {
                        return new DocLink(this.doc, block);
                    }
                    throw new NoSuchElementException(label);
                }
                catch (NumberFormatException ne) {
                    throw new NoSuchElementException(label);
                }
            }
            if (label.indexOf(46) > 0) {
                int block = this.locateBlock(label);
                if (this.doc.validateStatementBlock(block)) {
                    return new DocLink(this.doc, block);
                }
                throw new NoSuchElementException(label);
            }
        }
        if ((dl = this.lookup(label, 0, 0)) == null) {
            throw new NoSuchElementException(label);
        }
        return dl;
    }

    private DocLink lookup(String label, int blocknumber, int type) {
        int j;
        int i;
        int[] heads = new int[128];
        int[] chains = new int[32];
        byte[] hashes = new byte[512];
        DocLink dl = null;
        int emptyblock = 0;
        int emptyindex = 0;
        if (label == null) {
            return new DocLink(this.doc, this.doc.getFirstBlock());
        }
        label = label.toUpperCase();
        byte[] tbytes = label.getBytes();
        int len = label.length();
        if (len > 19) {
            len = 19;
        }
        label = new String(tbytes, 0, len);
        int nh = this.doc.getFirstHash();
        this.doc.getBlock(hashes, 0, nh);
        this.doc.getBlock(hashes, 128, nh + 1);
        this.doc.getBlock(hashes, 256, nh + 2);
        this.doc.getBlock(hashes, 384, nh + 3);
        for (i = 0; i < 128; ++i) {
            heads[i] = Cbytes.byteToInt(hashes, i * 4);
        }
        short wholehash = Cbytes.hashlabel(label);
        int blk = wholehash & 0x7F;
        int n = wholehash >> 7;
        int block = heads[blk];
        if (block == 0) {
            if (type == 1) {
                heads[blk] = block = this.doc.allocateBlock();
                Cbytes.intToByte(block, hashes, blk * 4);
                this.doc.putBlock(hashes, 0, nh, false);
                this.doc.putBlock(hashes, 128, nh + 1, false);
                this.doc.putBlock(hashes, 256, nh + 2, false);
                this.doc.putBlock(hashes, 384, nh + 3, false);
            } else {
                return null;
            }
        }
        blk = block;
        this.doc.getBlock(hashes, 0, blk);
        for (i = 0; i < 32; ++i) {
            chains[i] = Cbytes.byteToInt(hashes, i * 4);
        }
        block = chains[n];
        if (block == 0) {
            if (type == 1) {
                chains[n] = block = this.doc.allocateBlock();
                Cbytes.intToByte(block, hashes, n * 4);
                this.doc.putBlock(hashes, 0, blk, false);
            } else {
                return null;
            }
        }
        int next = block;
        this.doc.getBlock(hashes, 0, next);
        while (true) {
            for (i = 0; i < 5; ++i) {
                j = i * 24 + 12;
                while (hashes[j] != 0) {
                    ++j;
                }
                String lbl = new String(hashes, i * 24 + 12, j - (i * 24 + 12));
                lbl = lbl.toUpperCase();
                block = Cbytes.byteToInt(hashes, i * 24 + 8);
                if (block == 0) {
                    emptyblock = next;
                    emptyindex = i;
                }
                if (!lbl.equalsIgnoreCase(label)) continue;
                if (type == 2) {
                    if (block != blocknumber) continue;
                    Cbytes.intToByte(0, hashes, i * 24 + 8);
                    for (j = 0; j < 20; ++j) {
                        hashes[i * 24 + 12 + j] = 0;
                    }
                    this.doc.putBlock(hashes, 0, next, false);
                    return null;
                }
                if (type == 1) {
                    if (block != blocknumber) continue;
                    return null;
                }
                if (dl == null) {
                    dl = new DocLink(this.doc, block);
                    continue;
                }
                dl.addBlock(block);
            }
            blk = next;
            next = Cbytes.byteToInt(hashes, 0);
            if (next == 0) break;
            this.doc.getBlock(hashes, 0, next);
        }
        if (dl == null && type == 1) {
            if (emptyblock == 0) {
                emptyblock = this.doc.allocateBlock();
                Cbytes.intToByte(emptyblock, hashes, 0);
                this.doc.putBlock(hashes, 0, blk, false);
                this.doc.getBlock(hashes, 0, emptyblock);
                Cbytes.intToByte(blk, hashes, 4);
                emptyindex = 0;
            }
            Cbytes.intToByte(blocknumber, hashes, emptyindex * 24 + 8);
            len = label.length();
            if (len > 19) {
                len = 19;
            }
            tbytes = label.getBytes();
            for (j = 0; j < len; ++j) {
                hashes[emptyindex * 24 + 12 + j] = tbytes[j];
                hashes[emptyindex * 24 + 12 + len] = 0;
            }
            this.doc.putBlock(hashes, 0, emptyblock, false);
        }
        return dl;
    }

    public Vector getLabels() {
        int i;
        int[] heads = new int[128];
        int[] chains = new int[32];
        byte[] hashes = new byte[512];
        Vector<IndexItem> labels = new Vector<IndexItem>();
        int nh = this.doc.getFirstHash();
        this.doc.getBlock(hashes, 0, nh);
        this.doc.getBlock(hashes, 128, nh + 1);
        this.doc.getBlock(hashes, 256, nh + 2);
        this.doc.getBlock(hashes, 384, nh + 3);
        for (i = 0; i < 128; ++i) {
            heads[i] = Cbytes.byteToInt(hashes, i * 4);
        }
        for (int headi = 0; headi < 128; ++headi) {
            if (heads[headi] == 0) continue;
            this.doc.getBlock(hashes, 0, heads[headi]);
            for (i = 0; i < 32; ++i) {
                chains[i] = Cbytes.byteToInt(hashes, i * 4);
            }
            for (int chaini = 0; chaini < 32; ++chaini) {
                int blk = chains[chaini];
                while (blk != 0) {
                    this.doc.getBlock(hashes, 0, blk);
                    for (i = 0; i < 5; ++i) {
                        int j = i * 24 + 12;
                        while (hashes[j] != 0) {
                            ++j;
                        }
                        String lbl = new String(hashes, i * 24 + 12, j - (i * 24 + 12));
                        int block = Cbytes.byteToInt(hashes, i * 24 + 8);
                        if (block == 0) continue;
                        labels.addElement(new IndexItem(lbl, block));
                    }
                    blk = Cbytes.byteToInt(hashes, 0);
                }
            }
        }
        return labels;
    }

    public void validateLabels(JTextArea ta, Hashtable inuse) {
        int i;
        int[] heads = new int[128];
        int[] chains = new int[32];
        byte[] hashes = new byte[512];
        int nh = this.doc.getFirstHash();
        this.doc.getBlock(hashes, 0, nh);
        this.doc.getBlock(hashes, 128, nh + 1);
        this.doc.getBlock(hashes, 256, nh + 2);
        this.doc.getBlock(hashes, 384, nh + 3);
        for (i = 0; i < 128; ++i) {
            heads[i] = Cbytes.byteToInt(hashes, i * 4);
        }
        for (int headi = 0; headi < 128; ++headi) {
            if (heads[headi] == 0) continue;
            this.doc.getBlock(hashes, 0, heads[headi]);
            for (i = 0; i < 32; ++i) {
                chains[i] = Cbytes.byteToInt(hashes, i * 4);
            }
            for (int chaini = 0; chaini < 32; ++chaini) {
                int blk = chains[chaini];
                while (blk != 0) {
                    this.doc.getBlock(hashes, 0, blk);
                    for (i = 0; i < 5; ++i) {
                        int block = Cbytes.byteToInt(hashes, i * 24 + 8);
                        if (block == 0 || inuse.containsKey(new Integer(block))) continue;
                        int j = i * 24 + 12;
                        while (hashes[j] != 0) {
                            ++j;
                        }
                        String lbl = new String(hashes, i * 24 + 12, j - (i * 24 + 12));
                        ta.append("Label '");
                        ta.append(lbl);
                        ta.append("' Removed\n");
                        block = 0;
                        this.doc.putBlock(hashes, 0, blk, false);
                    }
                    blk = Cbytes.byteToInt(hashes, 0);
                }
            }
        }
    }

    private int locateBlock(String l) {
        StatementBlock sb = this.doc.getOriginStatementBlock();
        String levelstr = "";
        while (l.length() > 0) {
            int levelnum;
            int index = l.indexOf(46);
            if (index > 0) {
                levelstr = new String(l.substring(0, index));
                l = new String(l.substring(index + 1));
            } else {
                levelstr = l;
                l = "";
            }
            try {
                levelnum = Integer.parseInt(levelstr);
            }
            catch (NumberFormatException ne) {
                return 0;
            }
            for (int i = 1; i < levelnum; ++i) {
                if (sb.getNext() == 0) {
                    return 0;
                }
                if ((sb.getV2Fmt() & 0x20) == 32) continue;
                sb = this.doc.getStatementBlock(sb.getNext());
            }
            if (l.length() <= 0) continue;
            if (sb.getDown() == 0) {
                return 0;
            }
            sb = this.doc.getStatementBlock(sb.getDown());
        }
        return sb.getBlockNumber();
    }
}

