/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

class SizeMenu
extends JMenu
implements ActionListener {
    ThWindow frame;
    DocView docview;
    FontTable fonttable;
    JMenu msizes;
    int[] sizes = new int[]{8, 9, 10, 12, 14, 18, 24, 32, 48};

    public SizeMenu(ThWindow f) {
        super("Size");
        this.frame = f;
        this.docview = this.frame.getDocView();
        this.fonttable = new FontTable();
        CharFormat cf = this.docview.getDisplayCharFormat();
        for (int i = 0; i < this.sizes.length; ++i) {
            Integer I = new Integer(this.sizes[i]);
            String s = I.toString();
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(s + " Point");
            this.add(mi);
            mi.addActionListener(this);
            if (cf.getSize() != this.sizes[i]) continue;
            mi.setSelected(true);
        }
        this.msizes = this;
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        JRadioButtonMenuItem mi = (JRadioButtonMenuItem)e.getSource();
        CharFormat defaultcf = this.docview.getDisplayCharFormat();
        CharFormat statementcf = this.docview.getStatementCharFormat();
        int menusize = this.msizes.getItemCount();
        short newsize = (short)this.sizes[0];
        for (int i = 0; i < menusize; ++i) {
            JRadioButtonMenuItem mit = (JRadioButtonMenuItem)this.msizes.getItem(i);
            if (mit == mi) {
                mit.setSelected(true);
                newsize = (short)this.sizes[i];
                continue;
            }
            mit.setSelected(false);
        }
        int charfont = defaultcf.getFace();
        byte charstyle = defaultcf.getStyle();
        if (statementcf != null) {
            charfont = statementcf.getFace();
            charstyle = statementcf.getStyle();
        }
        CharFormat cf = new CharFormat(charfont, newsize, charstyle, this.fonttable);
        Statement st = this.docview.findfocus();
        if (st != null) {
            if (st.isSelecting()) {
                st.updateSelectedCharFormatfont(cf, charfont, newsize);
                this.docview.flushrelease();
                this.docview.repaint();
            }
        } else {
            this.docview.setDisplayCharFormat(cf);
            this.docview.setStatementCharFormat(null);
            this.docview.flushrelease();
            this.docview.repaint();
            this.frame.getOptions().setFontSize(newsize);
            return;
        }
        this.docview.setStatementCharFormat(cf);
    }

    public void updateMenu(CharFormat tcf) {
        short newsize = tcf.getSize();
        int menusize = this.msizes.getItemCount();
        for (int i = 0; i < menusize; ++i) {
            JRadioButtonMenuItem mit = (JRadioButtonMenuItem)this.msizes.getItem(i);
            if (newsize == this.sizes[i]) {
                mit.setSelected(true);
                continue;
            }
            mit.setSelected(false);
        }
    }
}

