/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;

class Statement {
    protected static final int LEVELINDENT = 50;
    protected static final int NORMALINDENT = 30;
    StatementBlock sb = null;
    Doc doc;
    Statement nextstatement;
    boolean focus;
    int caretoffset = -1;
    Options options;
    boolean drawn;
    int beginselect;
    int endselect;
    int startselect;
    boolean selecting = false;
    String lhead;
    String rhead;
    String lfoot;
    String rfoot;
    boolean isanimage = false;
    int sttop;
    int stleft;
    int stright;
    int stbottom;
    byte[] text;
    Rectangle bounds;
    int length;
    boolean dirty;
    boolean freed = false;
    Vector labels;
    HeadFootBlock hfb;

    Statement() {
    }

    public Statement getNextStatement() {
        return this.nextstatement;
    }

    public boolean isText() {
        return !this.isanimage;
    }

    public boolean isImage() {
        return this.isanimage;
    }

    public boolean isPage() {
        return this.sb.isPage();
    }

    public boolean isDrawn() {
        return this.drawn;
    }

    public void clearDrawn() {
        this.drawn = false;
    }

    public void clearSelect() {
        this.selecting = false;
    }

    public boolean isSelecting() {
        return this.selecting;
    }

    public Statement setNextStatement(Statement ns) {
        Statement s = this.nextstatement;
        this.nextstatement = ns;
        return s;
    }

    public void setPage(boolean sp) {
        this.sb.setPage(sp);
        this.dirty = true;
    }

    public StatementBlock getStatementBlock() {
        return this.sb;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public Doc getVDoc() {
        return this.doc;
    }

    public int getBlockNumber() {
        return this.sb.getBlockNumber();
    }

    public int getVBlockNumber() {
        return this.sb.getBlockNumber();
    }

    public int getLevel() {
        return this.sb.getLevel();
    }

    public int getNext() {
        return this.sb.getNext();
    }

    public int getPrev() {
        return this.sb.getPrev();
    }

    public int getDown() {
        return this.sb.getDown();
    }

    public int getUp() {
        return this.sb.getUp();
    }

    public int getNstatements() {
        return this.sb.getV2Nstatements();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        this.length = len;
    }

    public byte[] getBytes() {
        return this.text;
    }

    public int getSuccessor(int clip) {
        if (0 != this.sb.getDown() && this.sb.getLevel() < clip - 1) {
            return this.sb.getDown();
        }
        if (0 != this.sb.getNext() && this.sb.getLevel() < clip) {
            return this.sb.getNext();
        }
        int blk = this.sb.getUp();
        while (0 != blk) {
            StatementBlock tsb = this.doc.getStatementBlock(blk);
            if (0 != tsb.getNext()) {
                return tsb.getNext();
            }
            blk = tsb.getUp();
        }
        return 0;
    }

    public int getPredecessor(int clip, Options opts, DocView docview) {
        if (this.sb.getPrev() == 0) {
            return this.sb.getUp();
        }
        int retblk = this.sb.getPrev();
        if (retblk == 0) {
            return 0;
        }
        StatementBlock tsb = this.doc.getStatementBlock(retblk);
        int tclip = tsb.getLevel() + 1;
        if (tclip > clip) {
            if (docview == null) {
                return retblk;
            }
            if (!docview.isForced(this.doc, retblk)) {
                return retblk;
            }
        }
        while (tsb.getDown() != 0) {
            tsb = this.doc.getStatementBlock(tsb.getDown());
            while (tsb.getNext() != 0) {
                tsb = this.doc.getStatementBlock(tsb.getNext());
            }
        }
        retblk = tsb.getBlockNumber();
        return retblk;
    }

    public int getTop() {
        return this.sttop;
    }

    public int getBottom() {
        return this.stbottom;
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.stleft, this.sttop, this.stright - this.stleft, this.stbottom - this.sttop);
    }

    public String getLhead() {
        return this.lhead;
    }

    public String getRhead() {
        return this.rhead;
    }

    public String getLfoot() {
        return this.lfoot;
    }

    public String getRfoot() {
        return this.rfoot;
    }

    public void putLhead(String lh) {
        this.lhead = lh;
        this.dirty = true;
    }

    public void putRhead(String rh) {
        this.rhead = rh;
        this.dirty = true;
    }

    public void putLfoot(String lf) {
        this.lfoot = lf;
        this.dirty = true;
    }

    public void putRfoot(String rf) {
        this.rfoot = rf;
        this.dirty = true;
    }

    public void markOn(Graphics g) {
        if (this.sttop != 0) {
            g.setColor(Color.lightGray);
            g.fillRect(this.stleft, this.sttop, this.stright - this.stleft, this.stbottom - this.sttop);
            g.setColor(Color.black);
        }
    }

    public void erase(Graphics g) {
        if (this.sttop != 0) {
            g.setColor(Color.white);
            g.fillRect(this.stleft, this.sttop, this.stright - this.stleft, this.stbottom - this.sttop);
        }
    }

    public int draw(Graphics g, Rectangle d, int top, int offset, MyCaret mycaret, boolean drawit, CharFormat dcf, Component c) {
        return 0;
    }

    public boolean isInStatement(int x, int y) {
        return y >= this.sttop && y < this.stbottom;
    }

    public boolean isInFocus() {
        return this.focus;
    }

    public void setFocus(boolean f) {
        this.focus = f;
    }

    public boolean isDirty() {
        if (this.sb.isDirty()) {
            return true;
        }
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isCenter() {
        return this.sb.isCenter();
    }

    public boolean isRight() {
        return this.sb.isRight();
    }

    public boolean isNoHeaders() {
        return this.sb.isNoHeaders();
    }

    public boolean isNoLevels() {
        return this.sb.isNoLevels();
    }

    public boolean isEven() {
        return this.sb.isEven();
    }

    public boolean isOdd() {
        return this.sb.isOdd();
    }

    public void setCenter(boolean c) {
        this.sb.setCenter(c);
    }

    public void setRight(boolean c) {
        this.sb.setRight(c);
    }

    public void setNoHeaders(boolean c) {
        this.sb.setNoHeaders(c);
    }

    public void setNoLevels(boolean c) {
        this.sb.setNoLevels(c);
    }

    public void setEven(boolean c) {
        this.sb.setEven(c);
    }

    public void setOdd(boolean c) {
        this.sb.setOdd(c);
    }

    public int getNeed() {
        return this.sb.getV2Need();
    }

    public int getIndent() {
        return this.sb.getV2Indent();
    }

    public int getRindent() {
        return this.sb.getV2Rindent();
    }

    public int getV2Fmt() {
        return this.sb.getV2Fmt();
    }

    public void setV2Fmt(int fmt) {
        this.sb.putV2Fmt(fmt);
    }

    public void setNeed(int i) {
        this.sb.putV2Need(i);
    }

    public void setIndent(int i) {
        this.sb.putV2Indent(i);
    }

    public void setRindent(int i) {
        this.sb.putV2Rindent(i);
    }

    protected void drawDateLine(Graphics g, Rectangle d, int place, int height) {
        FontMetrics fm = g.getFontMetrics();
        Date date = new Date(this.sb.getTime());
        String datestr = date.toString();
        String blocknum = new String("[" + this.sb.getBlockNumber() + "] ");
        String nstatements = new String("(" + this.sb.getV2Nstatements() + ") ");
        datestr = new String(blocknum + nstatements + " " + this.sb.getV2Id() + " " + datestr);
        int datestrlen = fm.stringWidth(datestr);
        int dateleft = d.width - datestrlen;
        g.drawString(datestr, dateleft, place + height - 3);
    }

    public StatementBlock copyStatement() {
        return null;
    }

    public boolean putStatement(CharFormat cf) {
        return false;
    }

    public String returnSelected() {
        return null;
    }

    public CharFormat getCharFormat(int index) {
        return null;
    }

    public boolean mouseDown(DocView docview, MyCaret mycaret, MouseEvent e, int x, int y) {
        return true;
    }

    public boolean mouseUp(DocView docview, MouseEvent e, int x, int y) {
        return true;
    }

    public boolean mouseMove(DocView docview, MouseEvent e, int x, int y) {
        return true;
    }

    public boolean mouseDrag(DocView docview, MouseEvent e, int x, int y) {
        return true;
    }

    public LabelString doubleClick(MyCaret mycaret) {
        return null;
    }

    public void updateSelectedCharFormat(CharFormat ucf) {
    }

    public void updateSelectedCharFormatfont(CharFormat ucf, int nefont, int newsize) {
    }

    public void updateSelectedCharFormatstyle(CharFormat ucf, int newsize) {
    }

    public void freeStatement() {
        if (this.isText()) {
            this.text = ((TextStatement)this).restoreText();
            Vector tlabels = null;
            ((TextStatement)this).comparelabels(((TextStatement)this).getLabels(), tlabels);
        }
        if (this.hfb != null) {
            this.hfb.freeBlocks();
        }
        int chain = this.sb.getChain();
        while (chain != 0) {
            ChainBlock cb = this.doc.getChainBlock(chain);
            int tchain = cb.getChain();
            this.doc.freeBlock(chain);
            chain = tchain;
        }
        this.doc.freeBlock(this.sb.getBlockNumber());
        this.freed = true;
    }

    public void unDo() {
    }
}

