/*
 * Decompiled with CFR 0.152.
 */
class StatementFormat {
    int[] font;
    short[] size;
    byte[] style;
    int length;
    int statementfont = 0;
    short statementsize = 0;
    int i;
    FontTable fonttable = new FontTable();
    int labelOffset = 0;

    public StatementFormat() {
        this.font = new int[2020];
        this.size = new short[2020];
        this.style = new byte[2020];
    }

    public StatementFormat(byte[] fmtstring, int offset, int maxoffset) {
        this.font = new int[2020];
        this.size = new short[2020];
        this.style = new byte[2020];
        if (maxoffset - offset < 2) {
            return;
        }
        this.statementfont = (short)Cbytes.byteToShort(fmtstring, offset);
        this.statementsize = Cbytes.charToShort(fmtstring[offset + 2]);
        if ((offset += 3) < maxoffset) {
            this.length = this.expand(fmtstring, offset, this.style, maxoffset - offset + 1);
            if ((offset += this.length) < maxoffset) {
                this.length = this.fzexpand(fmtstring, offset, this.font, maxoffset - offset + 1);
                this.i = 0;
                while (this.i < this.length) {
                    this.size[this.i] = (short)(this.font[this.i] >> 16 & 0xFF);
                    this.font[this.i] = this.font[this.i] & 0xFFFF;
                    ++this.i;
                }
            }
            this.i = offset;
        }
    }

    public void setLabelOffset(int lo) {
        this.labelOffset = lo;
    }

    public StatementFormat splitStatementFormat(int index, int length) {
        index += this.labelOffset;
        length += this.labelOffset;
        StatementFormat newsf = new StatementFormat();
        newsf.statementfont = this.statementfont;
        newsf.statementsize = this.statementsize;
        this.i = 0;
        while (this.i < length - index) {
            newsf.font[this.i] = this.font[index + this.i];
            this.font[index + this.i] = 0;
            newsf.size[this.i] = this.size[index + this.i];
            this.size[index + this.i] = 0;
            newsf.style[this.i] = this.style[index + this.i];
            this.style[index + this.i] = 0;
            ++this.i;
        }
        return newsf;
    }

    public StatementFormat copyStatementFormat(int length) {
        length += this.labelOffset;
        StatementFormat newsf = new StatementFormat();
        newsf.statementfont = this.statementfont;
        newsf.statementsize = this.statementsize;
        this.i = 0;
        while (this.i < length) {
            newsf.font[this.i] = this.font[this.i];
            newsf.size[this.i] = this.size[this.i];
            newsf.style[this.i] = this.style[this.i];
            ++this.i;
        }
        newsf.labelOffset = this.labelOffset;
        return newsf;
    }

    public void joinStatementFormat(StatementFormat sf, int sflen, int mylen) {
        mylen += this.labelOffset;
        this.i = 0;
        while (this.i < sflen) {
            this.font[mylen + this.i] = sf.font[this.i];
            this.size[mylen + this.i] = sf.size[this.i];
            this.style[mylen + this.i] = sf.style[this.i];
            ++this.i;
        }
    }

    public CharFormat getCharFormat(CharFormat defcf, int index) {
        index += this.labelOffset;
        if (defcf == null) {
            defcf = new CharFormat();
        }
        if (this.font != null) {
            if (this.size[index] != 0) {
                return new CharFormat(this.font[index], this.size[index], this.style[index], this.fonttable);
            }
            return new CharFormat(defcf.getFace(), defcf.getSize(), this.style[index], this.fonttable);
        }
        if (this.style != null) {
            return new CharFormat(defcf.getFace(), defcf.getSize(), this.style[index], this.fonttable);
        }
        return new CharFormat(defcf.getFace(), defcf.getSize(), 0, this.fonttable);
    }

    public CharFormat getStatementFormat() {
        if (this.statementfont == 0) {
            return null;
        }
        if (this.statementsize == 0) {
            return null;
        }
        return new CharFormat(this.statementfont, this.statementsize, 0, this.fonttable);
    }

    public void insertCharFormat(CharFormat cf, int index, int length) {
        index += this.labelOffset;
        for (int i = length += this.labelOffset; i > index; --i) {
            this.font[i] = this.font[i - 1];
            this.size[i] = this.size[i - 1];
            this.style[i] = this.style[i - 1];
        }
        if (cf.getFace() != this.statementfont || cf.getSize() != this.statementsize) {
            this.font[index] = cf.getFace();
            this.size[index] = cf.getSize();
        }
        this.style[index] = cf.getStyle();
    }

    public void deleteCharFormat(int index, int length) {
        length += this.labelOffset;
        for (int i = index += this.labelOffset; i < length - 1; ++i) {
            this.font[i] = this.font[i + 1];
            this.size[i] = this.size[i + 1];
            this.style[i] = this.style[i + 1];
        }
    }

    public void updateCharFormat(CharFormat cf, int index) {
        this.font[index += this.labelOffset] = cf.getFace();
        this.size[index] = cf.getSize();
        this.style[index] = cf.getStyle();
    }

    public void updateCharFormatstyle(CharFormat cf, int index, int newstyle) {
        this.style[index += this.labelOffset] = (byte)newstyle;
    }

    public void updateCharFormatfont(CharFormat cf, int index, int newfont, int newsize) {
        this.size[index += this.labelOffset] = (short)newsize;
        this.font[index] = newfont;
    }

    public int getFormatString(byte[] here, int offset, int length, CharFormat cf) {
        int i;
        int cfont = this.font[0];
        short csize = this.size[0];
        byte cstyle = 0;
        boolean fontallsame = true;
        boolean styleallzero = true;
        for (i = 0; i < length; ++i) {
            if (this.font[i] == cfont && this.size[i] == csize) continue;
            fontallsame = false;
            break;
        }
        if (fontallsame && cfont != 0 && csize != 0) {
            this.statementfont = cfont;
            this.statementsize = csize;
            for (i = 0; i < length; ++i) {
                this.font[i] = 0;
                this.size[i] = 0;
            }
            if (cf == null) {
                this.statementfont = 0;
                this.statementsize = 0;
            } else if (cfont == cf.getFace() && csize == cf.getSize()) {
                this.statementfont = 0;
                this.statementsize = 0;
            }
        }
        for (i = 0; i < length; ++i) {
            if (this.style[i] == cstyle) continue;
            styleallzero = false;
            break;
        }
        int t = this.statementfont << 8;
        Cbytes.intToByte(t += this.statementsize & 0xFF, here, offset);
        int ocnt = 4;
        offset += 4;
        if (!styleallzero || !fontallsame) {
            int cnt = this.compress(this.style, here, offset, length);
            ocnt += cnt;
            offset += cnt;
            cnt = this.fzcompress(this.font, this.size, here, offset, length);
            ocnt += cnt;
            offset += cnt;
        } else if (this.statementfont + this.statementsize == 0) {
            ocnt = 1;
        }
        return ocnt;
    }

    private int compress(byte[] in, byte[] out, int offset, int len) {
        short t;
        int ocnt = 0;
        int cnt = 0;
        short current = Cbytes.charToShort(in[0]);
        int i = 0;
        while (len > 0) {
            if (cnt == 0) {
                current = Cbytes.charToShort(in[i]);
                cnt = 1;
            } else if (Cbytes.charToShort(in[i]) == current) {
                if (++cnt == 62) {
                    t = 190;
                    out[offset] = Cbytes.shortToChar(t);
                    ++ocnt;
                    out[++offset] = Cbytes.shortToChar(current);
                    ++offset;
                    ++ocnt;
                    cnt = 0;
                }
            } else {
                if (cnt > 1) {
                    t = (short)(cnt + 128);
                    out[offset] = Cbytes.shortToChar(t);
                    ++offset;
                    ++ocnt;
                }
                out[offset] = Cbytes.shortToChar(current);
                ++offset;
                ++ocnt;
                current = Cbytes.charToShort(in[i]);
                cnt = 1;
            }
            i = (short)(i + 1);
            --len;
        }
        if (cnt != 0) {
            if (cnt > 1) {
                t = (short)(cnt + 128);
                out[offset] = Cbytes.shortToChar(t);
                ++ocnt;
                ++offset;
            }
            out[offset] = Cbytes.shortToChar(current);
            ++offset;
            ++ocnt;
        }
        t = 255;
        out[offset] = Cbytes.shortToChar(t);
        ++offset;
        return ++ocnt;
    }

    private int expand(byte[] in, int offset, byte[] out, int len) {
        int consumed = 0;
        int outindex = 0;
        while (len != 0) {
            int cnt;
            short src = Cbytes.charToShort(in[offset]);
            if (src == 255) {
                ++consumed;
                break;
            }
            if ((src & 0x80) != 0) {
                cnt = src & 0x3F;
                ++offset;
                ++consumed;
                --len;
            } else {
                cnt = 1;
            }
            while (cnt != 0) {
                out[outindex] = in[offset];
                ++outindex;
                --cnt;
            }
            ++offset;
            ++consumed;
            --len;
        }
        return consumed;
    }

    private int fzcompress(int[] f, short[] s, byte[] out, int offset, int len) {
        int ocnt = 0;
        int cnt = 0;
        int i = 0;
        int current = (s[i] << 16) + f[i];
        while (len > 0) {
            if (cnt == 0) {
                current = (s[i] << 16) + f[i];
                cnt = 1;
            } else if (current == (s[i] << 16) + f[i]) {
                if (++cnt == 16384) {
                    Cbytes.intToByte(-cnt, out, offset);
                    ocnt += 4;
                    Cbytes.intToByte(current, out, offset += 4);
                    ocnt += 4;
                    offset += 4;
                    cnt = 0;
                }
            } else {
                if (cnt > 1) {
                    Cbytes.intToByte(-cnt, out, offset);
                    offset += 4;
                    ocnt += 4;
                }
                Cbytes.intToByte(current, out, offset);
                offset += 4;
                ocnt += 4;
                current = (s[i] << 16) + f[i];
                cnt = 1;
            }
            ++i;
            --len;
        }
        if (cnt > 0) {
            if (cnt > 1) {
                Cbytes.intToByte(-cnt, out, offset);
                offset += 4;
                ocnt += 4;
            }
            Cbytes.intToByte(current, out, offset);
            offset += 4;
            ocnt += 4;
        }
        Cbytes.intToByte(-1, out, offset);
        return ocnt += 4;
    }

    private int fzexpand(byte[] in, int offset, int[] out, int len) {
        int src;
        int outindex = 0;
        while (len != 0 && (src = Cbytes.byteToInt(in, offset)) != -1) {
            int cnt;
            if (src < 0) {
                cnt = -src;
                offset += 4;
                len -= 4;
            } else {
                cnt = 1;
            }
            while (cnt != 0) {
                out[outindex] = Cbytes.byteToInt(in, offset);
                ++outindex;
                --cnt;
            }
            offset += 4;
            len -= 4;
        }
        return outindex;
    }
}

