/*
 * Decompiled with CFR 0.152.
 */
public class StatementOptions {
    boolean center;
    boolean right;
    boolean nolevels;
    boolean noheaders;
    boolean forceodd;
    boolean forceeven;
    int needlines;
    int indent;
    int rindent;
    String lefthead;
    String leftfoot;
    String righthead;
    String rightfoot;
    boolean changed;
    public static final int CANCEL = 1;
    public static final int OK = 0;

    public StatementOptions(Statement s) {
        this.center = s.isCenter();
        this.right = s.isRight();
        this.forceeven = s.isEven();
        this.forceodd = s.isOdd();
        this.noheaders = s.isNoHeaders();
        this.nolevels = s.isNoLevels();
        this.needlines = s.getNeed();
        this.indent = s.getIndent();
        this.rindent = s.getRindent();
        this.lefthead = s.getLhead();
        this.leftfoot = s.getLfoot();
        this.righthead = s.getRhead();
        this.rightfoot = s.getRfoot();
        this.changed = false;
    }

    public StatementOptions() {
        this.center = false;
        this.right = false;
        this.noheaders = false;
        this.nolevels = false;
        this.forceeven = false;
        this.forceodd = false;
        this.needlines = 0;
        this.indent = 0;
        this.rindent = 0;
        this.lefthead = null;
        this.leftfoot = null;
        this.righthead = null;
        this.rightfoot = null;
        this.changed = false;
    }

    public StatementOptions(Options op) {
        this.center = (op.getV2FMT() & 0x80) == 128;
        this.right = (op.getV2FMT() & 0x40) == 64;
        this.noheaders = (op.getV2FMT() & 0x10) == 16;
        this.nolevels = (op.getV2FMT() & 0x20) == 32;
        this.forceeven = (op.getV2FMT() & 4) == 4;
        this.forceodd = (op.getV2FMT() & 8) == 8;
        this.needlines = op.getNeed();
        this.indent = op.getIndent();
        this.rindent = op.getRIndent();
        this.lefthead = op.getPLefthead();
        this.leftfoot = op.getPLeftfoot();
        this.righthead = op.getPRighthead();
        this.rightfoot = op.getPRightfoot();
        this.changed = false;
    }

    public void setStatementOptions(Statement s, boolean doheaders) {
        if (doheaders) {
            s.putLhead(this.lefthead);
            s.putRhead(this.righthead);
            s.putLfoot(this.leftfoot);
            s.putRfoot(this.rightfoot);
        }
        s.setCenter(this.center);
        s.setRight(this.right);
        s.setNoLevels(this.nolevels);
        s.setNoHeaders(this.noheaders);
        s.setOdd(this.forceodd);
        s.setEven(this.forceeven);
        s.setNeed(this.needlines);
        s.setIndent(this.indent);
        s.setRindent(this.rindent);
    }

    public void setStatementOptions(Options op) {
        op.setPLefthead(this.lefthead);
        op.setPRighthead(this.righthead);
        op.setPLeftfoot(this.leftfoot);
        op.setPRightfoot(this.rightfoot);
        op.setNeed(this.needlines);
        op.setIndent(this.indent);
        op.setRIndent(this.rindent);
        op.setV2FMT(op.getV2FMT() & 0xFFFFFF7F);
        if (this.center) {
            op.setV2FMT(op.getV2FMT() | 0x80);
        }
        op.setV2FMT(op.getV2FMT() & 0xFFFFFFBF);
        if (this.right) {
            op.setV2FMT(op.getV2FMT() | 0x40);
        }
        op.setV2FMT(op.getV2FMT() & 0xFFFFFFEF);
        if (this.noheaders) {
            op.setV2FMT(op.getV2FMT() | 0x10);
        }
        op.setV2FMT(op.getV2FMT() & 0xFFFFFFDF);
        if (this.nolevels) {
            op.setV2FMT(op.getV2FMT() | 0x20);
        }
        op.setV2FMT(op.getV2FMT() & 0xFFFFFFFB);
        if (this.forceeven) {
            op.setV2FMT(op.getV2FMT() | 4);
        }
        op.setV2FMT(op.getV2FMT() & 0xFFFFFFF7);
        if (this.forceodd) {
            op.setV2FMT(op.getV2FMT() | 8);
        }
    }

    public boolean isCenter() {
        return this.center;
    }

    public void setCenter(boolean c) {
        this.center = c;
    }

    public boolean isRight() {
        return this.right;
    }

    public void setRight(boolean r) {
        this.right = r;
    }

    public boolean isOdd() {
        return this.forceodd;
    }

    public void setOdd(boolean o) {
        this.forceodd = o;
    }

    public boolean isEven() {
        return this.forceeven;
    }

    public void setEven(boolean e) {
        this.forceeven = e;
    }

    public boolean isNoLevels() {
        return this.nolevels;
    }

    public void setNoLevels(boolean l) {
        this.nolevels = l;
    }

    public boolean isNoHeaders() {
        return this.noheaders;
    }

    public void setNoHeaders(boolean h) {
        this.noheaders = h;
    }

    public int getNeed() {
        return this.needlines;
    }

    public void setNeed(int n) {
        this.needlines = n;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int i) {
        this.indent = i;
    }

    public int getRindent() {
        return this.rindent;
    }

    public void setRindent(int r) {
        this.rindent = r;
    }

    public String getLHead() {
        return this.lefthead;
    }

    public void setLHead(String s) {
        this.lefthead = s;
    }

    public String getLFoot() {
        return this.leftfoot;
    }

    public void setLFoot(String s) {
        this.leftfoot = s;
    }

    public String getRHead() {
        return this.righthead;
    }

    public void setRHead(String s) {
        this.righthead = s;
    }

    public String getRFoot() {
        return this.rightfoot;
    }

    public void setRFoot(String s) {
        this.rightfoot = s;
    }

    public void setChanged(boolean c) {
        this.changed = c;
    }

    public boolean isChanged() {
        return this.changed;
    }
}

