/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Vector;

class ThBuildIndex
implements ThCommand {
    ThWindow frame;
    DocView docview;

    ThBuildIndex(ThWindow f) {
        this.frame = f;
        this.docview = this.frame.getDocView();
        this.docview.flush();
    }

    public boolean cmdStart(int code) {
        this.frame.disableControls();
        return true;
    }

    public boolean cmdContinue(MouseEvent e) {
        int y;
        int x = e.getX();
        Statement s = this.docview.findstatement(x, y = e.getY());
        if (s == null) {
            return true;
        }
        StatementBlock sb = s.getStatementBlock();
        Cursor saveCursor = this.docview.getCursor();
        this.docview.setCursor(Cursor.getPredefinedCursor(3));
        this.addIndexStatements(sb);
        this.frame.enableControls();
        this.docview.setCursor(saveCursor);
        this.docview.repaint();
        return false;
    }

    public void cmdEnd() {
    }

    public void cmdCancel() {
        this.frame.enableControls();
    }

    private void addIndexStatements(StatementBlock insertSB) {
        Doc doc = insertSB.getDoc();
        Labels l = doc.getLabels();
        Vector labels = l.getLabels();
        Sort.qsort(labels);
        StatementBlock sb = this.insertStatement(insertSB, 0, "(Index)Index");
        int level = 1;
        String lastlabel = "";
        int lastblock = 0;
        String blocklist = new String("");
        for (int i = 0; i < labels.size(); ++i) {
            IndexItem ii = (IndexItem)labels.elementAt(i);
            if (ii.getLabel().equalsIgnoreCase(lastlabel)) {
                blocklist = new String(blocklist + "," + ii.getBlockNumber());
                continue;
            }
            if (lastblock != 0) {
                StatementBlock sb1 = this.outputIndex(sb, doc, lastblock, lastlabel, blocklist, level);
                if (sb1 == null) {
                    lastblock = 0;
                    lastlabel = "";
                    continue;
                }
                if (sb1 != sb) {
                    level = 0;
                }
                sb = sb1;
            }
            lastlabel = ii.getLabel();
            lastblock = ii.getBlockNumber();
            blocklist = new String("" + lastblock);
        }
        this.outputIndex(sb, doc, lastblock, lastlabel, blocklist, level);
    }

    private StatementBlock outputIndex(StatementBlock sb, Doc doc, int lastblock, String lastlabel, String blocklist, int level) {
        Statement s = doc.getStatement(lastblock, this.frame.getOptions());
        if (s == null) {
            return null;
        }
        Vector slabels = ((TextStatement)s).getLabels();
        if (slabels == null) {
            return null;
        }
        String s1 = lastlabel;
        for (int j = 0; j < slabels.size(); ++j) {
            String s3;
            String s2 = (String)slabels.elementAt(j);
            if (s2.length() < s1.length() || !(s3 = s2.substring(0, s1.length())).equalsIgnoreCase(s1)) continue;
            String indexstring = new String("<" + s2 + ">  " + blocklist);
            sb = this.insertStatement(sb, level, indexstring);
            break;
        }
        return sb;
    }

    private StatementBlock insertStatement(StatementBlock here, int level, String content) {
        Doc doc = here.getDoc();
        StatementBlock sb = doc.getStatementBlock();
        here.insertBranch(sb, level, here.getBlockNumber());
        Statement s = doc.getStatement(sb.getBlockNumber(), this.frame.getOptions());
        byte[] stext = s.getBytes();
        byte[] itext = content.getBytes();
        for (int i = 0; i < content.length(); ++i) {
            stext[i] = itext[i];
        }
        s.setLength(content.length());
        s.setDirty();
        s.putStatement(this.docview.getDisplayCharFormat());
        return sb;
    }
}

