/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseEvent;

class ThCopy
implements ThCommand {
    ThWindow frame;
    DocView docview;
    static final int COPYBRANCH = 1;
    static final int COPYGROUP = 2;
    static final int COPYPLEX = 3;
    static final int COPYCHOICE = 4;
    int copytype = 0;
    StatementBlock beginsb = null;
    StatementBlock endsb = null;
    StatementBlock targetsb = null;
    boolean more;

    ThCopy(ThWindow f) {
        this.frame = f;
        this.docview = this.frame.getDocView();
        this.docview.flush();
    }

    public boolean cmdStart(int code) {
        if (code == 1) {
            return this.docopyBranch();
        }
        if (code == 2) {
            return this.docopyGroup();
        }
        if (code == 3) {
            return this.docopyPlex();
        }
        return false;
    }

    public boolean cmdContinue(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.frame.updateMouse(x, y);
        this.frame.enableControls();
        this.more = false;
        Statement s = this.docview.findstatement(x, y);
        if (s == null) {
            return true;
        }
        int block = s.getBlockNumber();
        this.frame.getWindowManager().addMarkStatementAllWindows(block, s.getDoc());
        this.frame.getWindowManager().repaintAllWindows(s.getDoc());
        if (this.beginsb == null) {
            this.beginsb = s.getStatementBlock();
        } else if (this.copytype == 2 && this.endsb == null) {
            this.endsb = s.getStatementBlock();
        } else if (this.targetsb == null) {
            this.targetsb = s.getStatementBlock();
        }
        if (this.copytype == 1) {
            this.more = this.docopyBranch();
        } else if (this.copytype == 2) {
            this.more = this.docopyGroup();
        } else if (this.copytype == 3) {
            this.more = this.docopyPlex();
        }
        if (!this.more) {
            this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
        }
        return this.more;
    }

    public void cmdEnd() {
    }

    public void cmdCancel() {
        this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
        this.frame.enableControls();
    }

    public void copyChoice(int x, int y) {
        DocView docview = this.frame.getDocView();
        this.frame.updateMouse(x, y + 18);
        SimpleResponse r = new SimpleResponse();
        JTypeChoice d = new JTypeChoice(this.frame, r, x, y, "Copy");
        d.setVisible(true);
        int res = r.getResponse();
        if (res == 1) {
            docview.startMarking(this, 1);
        }
        this.frame.updateMouse(x, y + 34);
        if (res == 2) {
            docview.startMarking(this, 2);
        }
        this.frame.updateMouse(x, y + 50);
        if (res == 3) {
            docview.startMarking(this, 3);
        }
    }

    private boolean docopyBranch() {
        this.copytype = 1;
        if (this.beginsb == null) {
            SimpleResponse r = this.getAddress("Branch Address");
            if (r.getResponse() == 1) {
                return false;
            }
            if (r.getResponse() == 3) {
                this.beginsb = r.getStatementBlock();
            }
            if (r.getResponse() == 2) {
                this.frame.disableControls();
                return true;
            }
        }
        return this.doCopy();
    }

    private boolean docopyGroup() {
        this.copytype = 2;
        if (this.beginsb == null) {
            SimpleResponse r = this.getAddress("Begin Address");
            if (r.getResponse() == 1) {
                return false;
            }
            if (r.getResponse() == 3) {
                this.beginsb = r.getStatementBlock();
                Point p = this.frame.getMouse();
                this.frame.updateMouse(p.x, p.y - 18);
            }
            if (r.getResponse() == 2) {
                this.frame.disableControls();
                return true;
            }
        }
        Point p = this.frame.getMouse();
        this.frame.updateMouse(p.x, p.y + 18);
        if (this.endsb == null) {
            SimpleResponse r = this.getAddress("End Address");
            if (r.getResponse() == 1) {
                this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
                return false;
            }
            if (r.getResponse() == 3) {
                this.endsb = r.getStatementBlock();
            }
            if (r.getResponse() == 2) {
                this.frame.disableControls();
                return true;
            }
        }
        return this.doCopy();
    }

    private boolean docopyPlex() {
        this.copytype = 3;
        if (this.beginsb == null) {
            SimpleResponse r = this.getAddress("Plex Address");
            if (r.getResponse() == 1) {
                return false;
            }
            if (r.getResponse() == 3) {
                this.beginsb = r.getStatementBlock();
            }
            if (r.getResponse() == 2) {
                this.frame.disableControls();
                return true;
            }
        }
        return this.doCopy();
    }

    private boolean doCopy() {
        int level = 0;
        Point p = this.frame.getMouse();
        if (this.copytype != 2) {
            this.frame.updateMouse(p.x, p.y + 18);
        }
        if (this.targetsb == null) {
            SimpleResponse r = this.getAddress("Target Address");
            if (r.getResponse() == 1) {
                this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
                return false;
            }
            if (r.getResponse() == 3) {
                this.targetsb = r.getStatementBlock();
            }
            if (r.getResponse() == 2) {
                this.frame.disableControls();
                return true;
            }
        }
        if (this.copytype == 1 && this.targetsb != this.beginsb && !this.validateTarget(this.targetsb, this.beginsb)) {
            this.frame.errormsg("Target Not Valid");
            return false;
        }
        if (this.copytype == 2) {
            if (this.beginsb.getUp() != this.endsb.getUp()) {
                this.frame.errormsg("Invalid Group Specification");
                return false;
            }
            StatementBlock testsb = this.beginsb;
            if (this.targetsb != this.endsb) {
                while (testsb != null && testsb != this.endsb) {
                    this.frame.getWindowManager().addMarkStatementAllWindows(testsb.getBlockNumber(), testsb.getDoc());
                    if (!this.validateTarget(this.targetsb, testsb)) {
                        this.frame.errormsg("Target Not Valid");
                        return false;
                    }
                    int blk = testsb.getNext();
                    if (blk == 0) break;
                    testsb = testsb.getDoc().getStatementBlock(blk);
                }
            }
            this.frame.getWindowManager().repaintAllWindows(testsb.getDoc());
        }
        if (this.copytype == 3) {
            int blk = this.beginsb.getUp();
            if (blk == 0) {
                this.frame.errormsg("Can't copy main plex");
                return false;
            }
            this.beginsb = this.beginsb.getDoc().getStatementBlock(blk);
            blk = this.beginsb.getDown();
            StatementBlock testsb = this.beginsb = this.beginsb.getDoc().getStatementBlock(blk);
            while (testsb != null) {
                this.frame.getWindowManager().addMarkStatementAllWindows(testsb.getBlockNumber(), testsb.getDoc());
                if (!(testsb.getNext() == 0 && this.targetsb == testsb || this.validateTarget(this.targetsb, testsb))) {
                    this.frame.errormsg("Target Not Valid");
                    return false;
                }
                blk = testsb.getNext();
                if (blk == 0) break;
                testsb = testsb.getDoc().getStatementBlock(blk);
            }
        }
        SimpleResponse r = new SimpleResponse();
        JMoveCopyConfirm d = new JMoveCopyConfirm(this.frame, r, p.x, p.y - 18);
        d.setVisible(true);
        int res = r.getResponse();
        this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
        if (res == 2) {
            level = -1;
        }
        if (res == 3) {
            level = 0;
        }
        if (res == 4) {
            level = 1;
        }
        if (res == 1) {
            return false;
        }
        if (this.copytype == 1) {
            this.copyBranch(this.beginsb, this.targetsb, level);
        } else if (this.copytype == 2) {
            this.copyGroup(this.beginsb, this.endsb, this.targetsb, level);
        } else if (this.copytype == 3) {
            this.copyPlex(this.beginsb, this.targetsb, level);
        }
        return false;
    }

    public void copyGroup(StatementBlock beginsb, StatementBlock endsb, StatementBlock to, int level) {
        int next;
        Doc doc = beginsb.getDoc();
        if (endsb != null && doc != endsb.getDoc()) {
            return;
        }
        if (doc != to.getDoc()) {
            return;
        }
        this.frame.getWindowManager().flushAllWindows(doc);
        StatementBlock me = beginsb;
        do {
            next = me.getNext();
            StatementBlock copyme = this.copyStatement(me);
            to.insertBranch(copyme, level, this.docview.getAnchorBlock());
            if (me == endsb || next == 0) break;
            level = 0;
            to = copyme;
        } while ((me = doc.getStatementBlock(next)) != null);
        this.frame.getWindowManager().repaintAllWindows(doc);
    }

    public void copyPlex(StatementBlock me, StatementBlock to, int level) {
        int next;
        Doc doc = me.getDoc();
        if (doc != to.getDoc()) {
            return;
        }
        this.frame.getWindowManager().flushAllWindows(doc);
        do {
            next = me.getNext();
            StatementBlock copyme = this.copyStatement(me);
            to.insertBranch(copyme, level, this.docview.getAnchorBlock());
            level = 0;
            to = copyme;
        } while (next != 0 && (me = doc.getStatementBlock(next)) != null);
        this.frame.getWindowManager().repaintAllWindows(doc);
    }

    public void copyBranch(StatementBlock me, StatementBlock to, int level) {
        this.frame.getWindowManager().flushAllWindows(me.getDoc());
        if (me.getDoc() != to.getDoc()) {
            return;
        }
        this.frame.getWindowManager().flushAllWindows(to.getDoc());
        me = this.copyStatement(me);
        to.insertBranch(me, level, this.docview.getAnchorBlock());
        this.frame.getWindowManager().repaintAllWindows(me.getDoc());
        if (me.getDoc() != to.getDoc()) {
            this.frame.getWindowManager().repaintAllWindows(to.getDoc());
        }
    }

    private SimpleResponse getAddress(String title) {
        SimpleResponse r = new SimpleResponse();
        JAddress jad = new JAddress(title, this.frame, r);
        jad.setVisible(true);
        return r;
    }

    private boolean validateTarget(StatementBlock targetsb, StatementBlock markedsb) {
        StatementBlock testsb = targetsb;
        while (testsb != null) {
            if (testsb == markedsb) {
                return false;
            }
            int blk = testsb.getUp();
            if (blk == 0) {
                return true;
            }
            testsb = testsb.getDoc().getStatementBlock(blk);
        }
        return true;
    }

    private StatementBlock copyStatement(StatementBlock sb) {
        StatementBlock downsb;
        Statement st = sb.getDoc().getStatement(sb.getBlockNumber(), this.frame.getOptions());
        StatementBlock newsb = st.copyStatement();
        int downblk = st.getDown();
        StatementBlock me = newsb;
        int level = 1;
        while (downblk != 0 && (downsb = sb.getDoc().getStatementBlock(downblk)) != null) {
            StatementBlock newdownsb = this.copyStatement(downsb);
            me.insertBranch(newdownsb, level, 0);
            me = newdownsb;
            level = 0;
            downblk = downsb.getNext();
        }
        return newsb;
    }
}

