/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseEvent;

class ThDelete
implements ThCommand {
    ThWindow frame;
    DocView docview;
    static final int DELETEBRANCH = 1;
    static final int DELETEGROUP = 2;
    static final int DELETEPLEX = 3;
    static final int DELETECHOICE = 4;
    int deletetype = 0;
    StatementBlock beginsb = null;
    StatementBlock endsb = null;
    boolean more;

    ThDelete(ThWindow f) {
        this.frame = f;
        this.docview = this.frame.getDocView();
        this.docview.flush();
    }

    public boolean cmdStart(int code) {
        Point p = this.frame.getMouse();
        if (code == 1) {
            return this.deleteBranch();
        }
        if (code == 2) {
            return this.deleteGroup();
        }
        if (code == 3) {
            return this.deletePlex();
        }
        return false;
    }

    public boolean cmdContinue(MouseEvent e) {
        int y;
        int x = e.getX();
        Statement s = this.docview.findstatement(x, y = e.getY());
        if (s == null) {
            return true;
        }
        this.frame.updateMouse(x, y);
        this.frame.enableControls();
        this.more = false;
        int block = s.getBlockNumber();
        this.frame.getWindowManager().addMarkStatementAllWindows(block, s.getDoc());
        this.docview.repaint();
        if (this.beginsb == null) {
            this.beginsb = s.getStatementBlock();
        } else {
            this.endsb = s.getStatementBlock();
        }
        this.more = this.doDelete(this.deletetype, x, y);
        if (!this.more) {
            this.frame.getWindowManager().repaintAllWindows(this.frame.getDoc());
        }
        return this.more;
    }

    public void cmdEnd() {
    }

    public void cmdCancel() {
        this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
        this.frame.enableControls();
    }

    public void deleteChoice(int x, int y) {
        DocView docview = this.frame.getDocView();
        this.frame.updateMouse(x, y + 18);
        SimpleResponse r = new SimpleResponse();
        JTypeChoice d = new JTypeChoice(this.frame, r, x, y, "Delete");
        d.setVisible(true);
        int res = r.getResponse();
        if (res == 1) {
            docview.startMarking(this, 1);
        }
        this.frame.updateMouse(x, y + 34);
        if (res == 2) {
            docview.startMarking(this, 2);
        }
        this.frame.updateMouse(x, y + 50);
        if (res == 3) {
            docview.startMarking(this, 3);
        }
    }

    public boolean deleteBranch() {
        SimpleResponse r = this.getAddress("Branch Address");
        if (r.getResponse() == 1) {
            return false;
        }
        if (r.getResponse() == 3) {
            this.beginsb = r.getStatementBlock();
            Point p = this.frame.getMouse();
            this.doDelete(1, p.x, p.y - 18);
            return false;
        }
        this.deletetype = 1;
        this.frame.disableControls();
        return true;
    }

    public boolean deleteGroup() {
        SimpleResponse r = this.getAddress("Begin Address");
        if (r.getResponse() == 1) {
            return false;
        }
        if (r.getResponse() == 3) {
            this.beginsb = r.getStatementBlock();
            r = this.getAddress("End Address");
            if (r.getResponse() == 1) {
                this.frame.getWindowManager().clearAllMarkedAllWindows(this.beginsb.getDoc());
                return false;
            }
            if (r.getResponse() == 3) {
                this.endsb = r.getStatementBlock();
                Point p = this.frame.getMouse();
                this.doDelete(2, p.x, p.y - 18);
                return false;
            }
        }
        this.deletetype = 2;
        this.frame.disableControls();
        return true;
    }

    public boolean deletePlex() {
        SimpleResponse r = this.getAddress("Plex Address");
        if (r.getResponse() == 1) {
            return false;
        }
        if (r.getResponse() == 3) {
            this.beginsb = r.getStatementBlock();
            Point p = this.frame.getMouse();
            this.doDelete(3, p.x, p.y - 18);
            return false;
        }
        this.deletetype = 3;
        this.frame.disableControls();
        return true;
    }

    private boolean doDelete(int dt, int x, int y) {
        if (dt == 1) {
            this.endsb = this.beginsb;
            this.delgrp(x, y);
            return false;
        }
        if (dt == 2) {
            if (this.endsb == null) {
                Point p = this.frame.getMouse();
                this.frame.updateMouse(p.x, p.y + 18);
                SimpleResponse r = this.getAddress("End Address");
                if (r.getResponse() == 1) {
                    this.frame.getWindowManager().clearAllMarkedAllWindows(this.beginsb.getDoc());
                    return false;
                }
                if (r.getResponse() == 3) {
                    this.endsb = r.getStatementBlock();
                } else {
                    this.frame.disableControls();
                    return true;
                }
            }
            StatementBlock sb = this.beginsb;
            Doc doc = sb.getDoc();
            int block = sb.getBlockNumber();
            int eblock = this.endsb.getBlockNumber();
            if (doc != this.endsb.getDoc()) {
                this.frame.errormsg("Group not in same file");
                return false;
            }
            while (block != 0) {
                this.frame.getWindowManager().addMarkStatementAllWindows(block, doc);
                if (block == eblock) break;
                sb = doc.getStatementBlock(block);
                block = sb.getNext();
            }
            if (block == 0) {
                this.frame.getWindowManager().clearAllMarkedAllWindows(doc);
                this.frame.errormsg("Group Not Valid");
                return false;
            }
            this.delgrp(x, y);
            return false;
        }
        if (dt == 3) {
            Doc doc = this.beginsb.getDoc();
            int block = this.beginsb.getUp();
            if (block == 0) {
                this.frame.errormsg("Can't delete main plex");
                this.frame.getWindowManager().clearAllMarkedAllWindows(doc);
                return false;
            }
            StatementBlock sb = doc.getStatementBlock(block);
            block = sb.getDown();
            sb = this.beginsb = doc.getStatementBlock(block);
            block = sb.getBlockNumber();
            while (block != 0) {
                this.frame.getWindowManager().addMarkStatementAllWindows(block, doc);
                this.endsb = doc.getStatementBlock(block);
                block = this.endsb.getNext();
            }
            this.docview.repaint();
            this.delgrp(x, y);
        }
        return false;
    }

    private void delgrp(int x, int y) {
        StatementBlock sb = this.beginsb;
        int block = sb.getBlockNumber();
        int eblock = this.endsb.getBlockNumber();
        Doc doc = sb.getDoc();
        SimpleResponse r = new SimpleResponse();
        JDeleteConfirm d = new JDeleteConfirm(this.frame, r, x, y);
        d.setVisible(true);
        int res = r.getResponse();
        this.frame.getWindowManager().clearAllMarkedAllWindows(doc);
        if (res != 1) {
            return;
        }
        WindowManager wm = this.frame.getWindowManager();
        wm.flushAllWindows(doc);
        while (block != 0) {
            sb = doc.getStatementBlock(block);
            wm.replaceAnchor(doc, sb);
            int tblock = sb.getNext();
            this.deletebr(sb);
            if (block == eblock) break;
            block = tblock;
        }
        wm.flushAllWindows(doc);
    }

    private void deletebr(StatementBlock sb) {
        Doc doc = sb.getDoc();
        int down = sb.getDown();
        while (down != 0) {
            this.deletebr(doc.getStatementBlock(down));
            down = sb.getDown();
        }
        sb.removeBranch();
        Statement st = doc.getStatement(sb.getBlockNumber(), null);
        st.freeStatement();
    }

    private SimpleResponse getAddress(String title) {
        SimpleResponse r = new SimpleResponse();
        JAddress jad = new JAddress(title, this.frame, r);
        jad.setVisible(true);
        return r;
    }
}

