/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFileChooser;

class ThImport
implements ThCommand {
    ThWindow frame;
    Doc doc;
    ExportProgress imp;
    int level;
    int numeol;
    boolean secondst = true;

    public ThImport(ThWindow fr, Doc d) {
        this.frame = fr;
        this.doc = d;
    }

    public boolean cmdStart(int code) {
        SimpleResponse r = new SimpleResponse();
        ImportChoice d = new ImportChoice(this.frame, r);
        d.setVisible(true);
        if (r.getResponse() == 3) {
            return false;
        }
        if ((r.getResponse() & 1) == 1) {
            this.level = 0;
        }
        if ((r.getResponse() & 2) == 2) {
            this.level = 1;
        }
        if ((r.getResponse() & 0x20) == 32) {
            this.numeol = 1;
        }
        if ((r.getResponse() & 0x40) == 64) {
            this.numeol = 2;
        }
        return true;
    }

    public boolean cmdContinue(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Statement s = this.frame.getDocView().findstatement(x, y);
        if (s == null) {
            return true;
        }
        this.frame.disableControls();
        this.doTheImport(s);
        this.frame.enableControls();
        return false;
    }

    public void cmdCancel() {
        this.frame.enableControls();
    }

    public void cmdEnd() {
    }

    private void doTheImport(Statement s) {
        FileInputStream fis;
        JFileChooser file_dialog = new JFileChooser(this.frame.getHome());
        file_dialog.setDialogType(0);
        file_dialog.setDialogTitle("Choose ASCII file for Import");
        int retval = file_dialog.showOpenDialog(this.frame);
        if (retval != 0) {
            this.frame.errormsg("Import file not selected");
            return;
        }
        File file = file_dialog.getSelectedFile();
        try {
            fis = new FileInputStream(file);
        }
        catch (IOException ioe) {
            fis = null;
        }
        if (fis == null) {
            return;
        }
        this.imp = new ExportProgress(this.frame, "Importing..");
        boolean worked = this.doimport(this.frame, s, this.level, this.numeol, fis, this.imp);
        this.imp.setVisible(false);
        this.imp.dispose();
        try {
            fis.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (!worked) {
            this.frame.errormsg("Import Failed");
        }
    }

    private boolean doimport(ThWindow fr, Statement s, int level, int numeol, FileInputStream fis, ExportProgress imp) {
        int[] blocks = new int[64];
        int[] levels = new int[64];
        CharFormat cf = new CharFormat();
        int blk = s.getBlockNumber();
        Doc doc = s.getDoc();
        getst textst = new getst(fis);
        byte[] stbytes = textst.getStatement(numeol);
        if (textst.isEOF()) {
            return false;
        }
        if (stbytes == null) {
            return false;
        }
        fr.getWindowManager().flushAllWindows(doc);
        int indent = textst.getIndent();
        int extraindent = textst.getExtraIndent();
        int len = textst.getLength();
        if (len > 0) {
            int mylen = len;
            if (mylen > 20) {
                mylen = 20;
            }
            String str = new String(stbytes, 0, 20);
            imp.updmessage(str);
        }
        blocks[0] = blk;
        levels[0] = indent;
        blocks[1] = 0;
        levels[1] = 99999;
        int ntab = 2;
        while (!textst.isEOF() || len > 0) {
            int i;
            TextStatement newst = (TextStatement)StatementFactory.make(doc, this.frame.getOptions(), false);
            int nblk = newst.getBlockNumber();
            StatementBlock newblk = newst.getStatementBlock();
            int oldblk = 0;
            int lvl = 0;
            for (i = 0; i < ntab; ++i) {
                if (levels[i] <= indent) continue;
                int index = i - 1;
                if (index < 0) {
                    index = 0;
                }
                oldblk = blocks[index];
                if (indent > levels[index] || level == 1) {
                    levels[index + 1] = indent;
                    blocks[index + 1] = nblk;
                    lvl = 1;
                    level = 0;
                    levels[index + 2] = 99999;
                    blocks[index + 2] = 0;
                    ntab = index + 3;
                    break;
                }
                blocks[index] = nblk;
                lvl = 0;
                level = 0;
                levels[index + 1] = 99999;
                blocks[index + 1] = 0;
                ntab = index + 2;
                break;
            }
            StatementBlock oldsb = doc.getStatementBlock(oldblk);
            oldsb.insertBranch(newblk, lvl, 0);
            if (lvl == 0) {
                newblk.putV2Fmt(s.getV2Fmt());
                newblk.putV2Need(s.getNeed());
                newblk.putV2Indent(s.getIndent());
                newblk.putV2Rindent(s.getRindent());
            } else {
                newblk.putV2Fmt(fr.getOptions().getV2FMT());
                newblk.putV2Need(fr.getOptions().getNeed());
                newblk.putV2Indent(fr.getOptions().getIndent());
                newblk.putV2Rindent(fr.getOptions().getRIndent());
            }
            newst.setCaretOffset(0);
            for (i = 0; i < len; ++i) {
                newst.insertChar(stbytes[i], cf);
            }
            newst.putStatement(cf);
            newst = null;
            textst = new getst(fis, extraindent);
            stbytes = textst.getStatement(numeol);
            if (stbytes == null) break;
            indent = textst.getIndent();
            extraindent = textst.getExtraIndent();
            len = textst.getLength();
            if (len > 0) {
                int mylen = len;
                if (mylen > 20) {
                    mylen = 20;
                }
                String str = new String(stbytes, 0, 20);
                imp.updmessage(str);
            }
            if (!this.secondst) continue;
            if (indent < levels[0]) {
                levels[0] = indent;
            }
            if (ntab == 3) {
                levels[1] = indent;
            }
            this.secondst = false;
        }
        fr.getWindowManager().repaintAllWindows(doc);
        return true;
    }
}

