/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

class ThPrint
implements ThCommand {
    ThWindow frame;
    Doc doc;
    Component printComponent;
    PrinterJob printerJob;
    int topmargin;
    int bottommargin;
    int leftmargin;
    int rightmargin;
    int Ltopmargin;
    int Lleftmargin;
    boolean header;
    boolean footer;
    boolean headerlines;
    String leftheadstr;
    String rightheadstr;
    String leftfootstr;
    String rightfootstr;
    Vector<Object> imagestatements;
    Hashtable places;
    boolean firstpass;
    ExportProgress exp;
    int startblock;
    int nextblock;
    int startoffset;
    int nextoffset;
    int startpage;
    int lastblock;
    public static final int BRANCH = 1;
    public static final int FILE = 0;

    public ThPrint(ThWindow fr, Doc d, Component pp) {
        this.frame = fr;
        this.doc = d;
        this.printComponent = pp;
        this.imagestatements = new Vector();
    }

    public boolean cmdStart(int code) {
        boolean type = false;
        Options options = this.frame.getOptions();
        this.startblock = 0;
        this.startoffset = 0;
        this.nextblock = 0;
        this.nextoffset = 0;
        this.startpage = 0;
        this.firstpass = true;
        this.places = new Hashtable();
        options.cancelPrint(false);
        PageSetup ps = new PageSetup(this.frame, this.frame.getOptions());
        ps.setVisible(true);
        if (options.isCancelPrint()) {
            return false;
        }
        this.topmargin = options.getPTM() * 72 / 100;
        this.bottommargin = options.getPBM() * 72 / 100;
        this.leftmargin = options.getPLM() * 72 / 100;
        this.rightmargin = options.getPRM() * 72 / 100;
        this.header = options.getPDoHeaders();
        this.footer = options.getPDoFooters();
        this.headerlines = options.getPDoLines();
        this.leftheadstr = options.getPLefthead();
        this.rightheadstr = this.doc.getFilename();
        if (options.getPRighthead() != null && options.getPRighthead().compareTo("") != 0) {
            this.rightheadstr = options.getPRighthead();
        }
        this.leftfootstr = options.getPLeftfoot();
        this.rightfootstr = options.getPRightfoot();
        type = true;
        if (options.getPDoFile()) {
            type = false;
        }
        if (type) {
            this.frame.disableControls();
            return true;
        }
        this.frame.disableControls();
        this.doThePrint(null);
        this.frame.enableControls();
        return false;
    }

    public boolean cmdContinue(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Statement s = null;
        s = this.frame.getDocView().findstatement(x, y);
        if (s == null) {
            return true;
        }
        this.frame.disableControls();
        this.doThePrint(s);
        this.frame.enableControls();
        return false;
    }

    public void cmdCancel() {
        this.frame.enableControls();
    }

    public void cmdEnd() {
    }

    private void doThePrint(Statement s) {
        this.exp = new ExportProgress(this.frame, "Printing..");
        this.printerJob = PrinterJob.getPrinterJob();
        this.printerJob.setPrintable((Printable)((Object)this.printComponent));
        ((DocView)this.printComponent).setPrintObject(this);
        PageFormat dpf = new PageFormat();
        PageFormat pf = this.printerJob.pageDialog(dpf);
        if (pf == dpf) {
            this.printerJob.cancel();
            this.exp.setVisible(false);
            this.exp.dispose();
            return;
        }
        this.printerJob.validatePage(pf);
        if (!this.printerJob.printDialog()) {
            this.printerJob.cancel();
            this.exp.setVisible(false);
            this.exp.dispose();
            return;
        }
        this.frame.getWindowManager().flushAllWindows(this.frame.getDoc());
        if (s != null) {
            this.startblock = s.getBlockNumber();
            this.lastblock = s.getNext();
        } else {
            this.startblock = this.doc.getFirstBlock();
            this.lastblock = 0;
        }
        this.startoffset = 0;
        try {
            this.printerJob.print();
        }
        catch (Exception pe) {
            String errormsg = pe.getMessage();
            this.frame.errormsg(new String("Print: " + errormsg));
            this.printerJob.cancel();
        }
        this.imagestatements.clear();
        this.exp.setVisible(false);
        this.exp.dispose();
        this.frame.getWindowManager().repaintAllWindows(this.frame.getDoc());
    }

    public int print(Graphics g, PageFormat pf, int index) {
        int width = (int)pf.getWidth() - this.leftmargin - this.rightmargin;
        int height = (int)pf.getHeight() - this.topmargin - this.bottommargin;
        Rectangle clip = g.getClipBounds();
        CharFormat defaultcf = this.frame.getDocView().getDisplayCharFormat();
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        this.Ltopmargin = this.topmargin - clip.y;
        this.Lleftmargin = this.leftmargin - clip.x;
        int headlineY = this.Ltopmargin - 5;
        int footlineY = height + this.Ltopmargin + 5;
        int headlineL = this.Lleftmargin;
        int headlineR = width + this.Lleftmargin;
        int place = this.Ltopmargin;
        int blk = this.startblock;
        int offset = this.startoffset;
        Dimension area = new Dimension(width + this.Lleftmargin, height + this.Ltopmargin);
        g2d.setFont(defaultcf.getFont());
        if (this.startpage == 0 && index != this.startpage && this.nextblock == 0) {
            Dimension temparea = new Dimension(width + this.Lleftmargin, height + this.Ltopmargin + 1000);
            while (this.startpage < index) {
                if ((blk = this.printpage(blk, place + 1000, temparea, g2d, offset, defaultcf, index)) == 0) {
                    return 1;
                }
                ++this.startpage;
            }
            this.startblock = blk;
            this.startoffset = this.nextoffset;
            this.nextblock = blk;
            offset = this.startoffset;
        }
        g2d.setFont(defaultcf.getFont());
        if (index != this.startpage) {
            this.startblock = this.nextblock;
            this.startoffset = this.nextoffset;
            this.startpage = index;
            blk = this.startblock;
            offset = this.startoffset;
        }
        if (this.startblock == this.lastblock) {
            return 1;
        }
        this.nextblock = blk = this.printpage(blk, place, area, g2d, offset, defaultcf, index);
        if (this.header) {
            if (this.headerlines) {
                g2d.drawLine(headlineL, headlineY, headlineR, headlineY);
            }
            FontMetrics fm = g2d.getFontMetrics();
            int rheaderlen = 0;
            if (this.rightheadstr != null) {
                if (this.rightheadstr.compareToIgnoreCase("date:") == 0) {
                    this.rightheadstr = DateFormat.getDateInstance(1).format(new Date());
                }
                rheaderlen = fm.stringWidth(this.rightheadstr);
                if (this.rightheadstr.length() != 0) {
                    g2d.drawString(this.rightheadstr, headlineR - rheaderlen, headlineY - 4);
                }
            }
            if (this.leftheadstr != null) {
                if (this.leftheadstr.compareToIgnoreCase("date:") == 0) {
                    this.leftheadstr = DateFormat.getDateInstance(1).format(new Date());
                }
                if (this.leftheadstr.length() != 0) {
                    g2d.drawString(this.leftheadstr, headlineL, headlineY - 4);
                }
            }
        }
        if (this.footer) {
            if (this.headerlines) {
                g2d.drawLine(headlineL, footlineY, headlineR, footlineY);
            }
            String pagenumber = new String("-" + (index + 1) + "-");
            FontMetrics fm = g2d.getFontMetrics();
            int pagenumlen = fm.stringWidth(pagenumber);
            g2d.drawString(pagenumber, (width - pagenumlen) / 2 + this.Lleftmargin, footlineY + fm.getHeight() + 2);
            if (this.rightfootstr != null) {
                if (this.rightfootstr.compareToIgnoreCase("date:") == 0) {
                    this.rightfootstr = DateFormat.getDateInstance(1).format(new Date());
                }
                int rfooterlen = fm.stringWidth(this.rightfootstr);
                if (this.rightfootstr.length() != 0) {
                    g2d.drawString(this.rightfootstr, headlineR - rfooterlen, footlineY + fm.getHeight() + 2);
                }
            }
            if (this.leftfootstr != null) {
                if (this.leftfootstr.compareToIgnoreCase("date:") == 0) {
                    this.leftfootstr = DateFormat.getDateInstance(1).format(new Date());
                }
                if (this.leftfootstr.length() != 0) {
                    g2d.drawString(this.leftfootstr, headlineL, footlineY + fm.getHeight() + 2);
                }
            }
        }
        return 0;
    }

    int printpage(int blk, int place, Dimension area, Graphics g, int offset, CharFormat defaultcf, int pnum) {
        Statement s;
        int topplace = place;
        int clipping = this.frame.getDocView().getClipping();
        int images = 0;
        boolean afterimages = false;
        while ((s = this.doc.getStatement(blk, this.frame.getOptions())) != null) {
            String hfstr;
            if (place != topplace) {
                g.setFont(defaultcf.getFont());
                FontMetrics fm = g.getFontMetrics();
                int stheight = fm.getHeight();
                if (s.isOdd() && pnum % 1 == 0 || s.isEven() && pnum % 1 == 1 || stheight * s.getNeed() + place > area.height) break;
            }
            int newplace = place;
            if (s.isImage()) {
                ImageIcon iiI = ((ImageStatement)s).getImageIcon();
                this.imagestatements.add(iiI);
            }
            Rectangle margins = new Rectangle(this.Lleftmargin, 0, area.width, area.height);
            byte[] stbytes = s.getBytes();
            int len = Cbytes.strlen(stbytes, 0);
            if (len > 40) {
                len = 40;
            }
            String ststr = new String(stbytes, 0, len);
            this.exp.updmessage(ststr);
            place = newplace = s.draw(g, margins, place, offset, null, true, defaultcf, this.printComponent);
            offset = 0;
            if (s.isText() && ((TextStatement)s).getNextOffset() != 0 || !s.isDrawn()) break;
            if (s.isImage()) {
                ++images;
            }
            if ((hfstr = s.getRhead()) != null && hfstr.length() != 0) {
                this.rightheadstr = new String(hfstr);
            }
            if ((hfstr = s.getLhead()) != null && hfstr.length() != 0) {
                this.leftheadstr = new String(hfstr);
            }
            if ((hfstr = s.getRfoot()) != null && hfstr.length() != 0) {
                this.rightfootstr = new String(hfstr);
            }
            if ((hfstr = s.getLfoot()) != null && hfstr.length() != 0) {
                this.leftfootstr = new String(hfstr);
            }
            int clip = clipping;
            int tclip = s.getLevel() + 1;
            if (tclip > clip) {
                clip = tclip;
            }
            if ((blk = s.getSuccessor(clip)) != this.lastblock) continue;
            break;
        }
        this.nextoffset = 0;
        if (s.isText()) {
            this.nextoffset = ((TextStatement)s).getNextOffset();
        }
        return blk;
    }
}

