/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class ValidateWindow
extends JFrame
implements WindowListener {
    JTextArea textarea = new JTextArea(40, 80);
    Hashtable<Integer, Integer> inuse = new Hashtable();

    public ValidateWindow() {
        this.getContentPane().add((Component)new JScrollPane(this.textarea), "Center");
        this.setBounds(50, 50, 400, 200);
        this.setTitle("Document Validation");
        this.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void doValidate(Doc doc) {
        this.textarea.append("Begin Validation of ");
        this.textarea.append(doc.getFilename());
        this.textarea.append("\n");
        int cur = doc.getFirstBlock();
        this.checkplex(cur, doc);
        this.textarea.append("Checking Freelist\n");
        cur = doc.getFreeHead();
        while (cur != 0) {
            StatementBlock curblock = doc.getStatementBlock(cur);
            int blocknumber = curblock.getBlockNumber();
            Integer bn = new Integer(blocknumber);
            String bnstring = bn.toString();
            String debugstring = "Block " + bnstring + "\n";
            this.textarea.append(debugstring);
            if (this.isinuse(cur)) {
                this.textarea.append("Free Block in use\n");
                return;
            }
            if (!curblock.isUnused()) {
                this.textarea.append("Free Block not marked Unused\n");
                return;
            }
            cur = curblock.getChain();
        }
        this.textarea.append("Checking Labels\n");
        Labels labels = new Labels(doc);
        labels.validateLabels(this.textarea, this.inuse);
        doc.purgeCaches();
        this.textarea.append("End Validation\n");
    }

    private void checkplex(int cur, Doc doc) {
        while (cur != 0) {
            StatementBlock nextblock;
            int next;
            int up;
            StatementBlock prevblock;
            if (this.isinuse(cur)) {
                this.textarea.append("Block used twice\n");
                return;
            }
            StatementBlock curblock = doc.getStatementBlock(cur);
            if (curblock.isUnused()) {
                this.textarea.append("Unused flag set\n");
                return;
            }
            int blocknumber = curblock.getBlockNumber();
            Integer bn = new Integer(blocknumber);
            String bnstring = bn.toString();
            String debugstring = "Block " + bnstring + "\n";
            this.textarea.append(debugstring);
            int prev = curblock.getPrev();
            if (prev != 0 && (prevblock = doc.getStatementBlock(prev)).getNext() != cur) {
                this.textarea.append("Prev pointer bad\n");
            }
            if ((up = curblock.getUp()) != 0) {
                if (prev == 0) {
                    StatementBlock upblock = doc.getStatementBlock(up);
                    if (upblock.getDown() != cur) {
                        this.textarea.append("Up pointer bad\n");
                    }
                } else {
                    prevblock = doc.getStatementBlock(prev);
                    if (up != prevblock.getUp() && prevblock.getNext() == cur) {
                        this.textarea.append("Up pointer bad\n");
                    }
                }
            }
            if ((next = curblock.getNext()) != 0 && (nextblock = doc.getStatementBlock(next)).getPrev() != cur) {
                this.textarea.append("Next pointer bad\n");
            }
            int chain = curblock.getChain();
            while (chain != 0) {
                if (this.isinuse(chain)) {
                    this.textarea.append("Chain block used twice\n");
                }
                ChainBlock chainblock = doc.getChainBlock(chain);
                chain = chainblock.getChain();
            }
            int down = curblock.getDown();
            if (down != 0) {
                StatementBlock downblock = doc.getStatementBlock(down);
                if (downblock.getUp() != cur) {
                    this.textarea.append("Down pointer bad\n");
                }
                if (downblock.getPrev() != 0) {
                    this.textarea.append("Plex head with Prev\n");
                }
                this.checkplex(down, doc);
            }
            cur = next;
        }
    }

    private boolean isinuse(int b) {
        if (this.inuse.containsKey(new Integer(b))) {
            return true;
        }
        this.inuse.put(new Integer(b), new Integer(b));
        return false;
    }
}

