/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;

class ASCIIExp {
    Doc doc;
    OutputStream ostream;
    ThWindow frame;
    String eol;
    ExportProgress exp;

    public ASCIIExp(Doc d, OutputStream os, ThWindow fr, String endofline, ExportProgress myexp) {
        this.doc = d;
        this.ostream = os;
        this.frame = fr;
        this.eol = endofline;
        this.exp = myexp;
    }

    public void exportASCII(Statement st, boolean branch, boolean format, int linemax) {
        int block;
        int branchlevel = st.getLevel();
        if (!branch) {
            branchlevel = -1;
        }
        do {
            this.putStatement(st, this.ostream, format, linemax);
            if (this.exp.isCancelled()) break;
            this.putBlankLine(this.ostream, this.eol);
            block = st.getSuccessor(this.frame.getDocView().getClipping());
        } while (block != 0 && (st = st.getDoc().getStatement(block, this.frame.getOptions())) != null && st.getLevel() > branchlevel);
        try {
            this.ostream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private void putStatement(Statement st, OutputStream os, boolean format, int linemax) {
        byte[] buf = st.getBytes();
        int stlen = Cbytes.strlen(buf, 0);
        byte[] eolbuf = this.eol.getBytes();
        int eollen = this.eol.length();
        String image = "[IMAGE]";
        image = image + this.eol;
        int spaces = st.getLevel() * 3;
        int cspaces = 0;
        if (st.isImage()) {
            this.putSpaces(this.ostream, spaces);
            buf = image.getBytes();
            try {
                this.ostream.write(buf, 0, buf.length);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        int mlen = stlen;
        if (mlen > 20) {
            mlen = 20;
        }
        if (--mlen < 0) {
            mlen = 0;
        }
        String msgstr = new String(buf, 0, mlen);
        this.exp.updmessage(msgstr);
        if (!format) {
            try {
                this.ostream.write(buf, 0, stlen);
                eolbuf = this.eol.getBytes();
                this.ostream.write(eolbuf, 0, eollen);
            }
            catch (IOException ioe) {}
        } else {
            int length;
            for (int index = 0; index < stlen; index += length) {
                index = this.skipBlanks(buf, index, stlen);
                if (st.isCenter()) {
                    length = this.wrapLine(buf, index, linemax, stlen);
                    cspaces = (linemax - length) / 2;
                    this.putSpaces(this.ostream, cspaces);
                } else if (st.isRight()) {
                    length = this.wrapLine(buf, index, linemax, stlen);
                    cspaces = linemax - length;
                    this.putSpaces(this.ostream, cspaces);
                } else {
                    length = this.wrapLine(buf, index, linemax - spaces, stlen);
                    this.putSpaces(this.ostream, spaces);
                }
                try {
                    this.ostream.write(buf, index, length);
                    this.ostream.write(eolbuf, 0, eollen);
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    private int skipBlanks(byte[] buf, int index, int length) {
        int i;
        for (i = index; i < length && (buf[i] == 13 || buf[i] == 10 || buf[i] == 32); ++i) {
        }
        if (i == length) {
            --i;
        }
        return i;
    }

    private int wrapLine(byte[] buf, int index, int linemax, int length) {
        int i;
        int blanki = 0;
        for (i = index; i < length; ++i) {
            if (i - index >= linemax) {
                if (blanki == 0) break;
                i = blanki;
                break;
            }
            if (buf[i] == 32) {
                blanki = i;
            }
            if (buf[i] != 10 && buf[i] != 13) continue;
            buf[i] = 32;
            ++i;
            break;
        }
        return i - index;
    }

    private void putBlankLine(OutputStream os, String eol) {
        byte[] buf = eol.getBytes();
        try {
            os.write(buf, 0, eol.length());
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private void putSpaces(OutputStream os, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            try {
                this.ostream.write(32);
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

