/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

class ActionPanel
extends JPanel
implements ActionListener {
    ThWindow frame;
    JButton cancel;
    JButton jump;
    JButton insert;
    JButton delete;
    JButton copy;
    JButton move;
    JButton plus;
    JButton minus;
    JButton ret;
    JComboBox cclip;
    MyMessage emsg;
    Toolkit toolkit;

    public ActionPanel(ThWindow f) {
        this.frame = f;
        this.setSize(80, ThWindow.ACTIONVERT);
        this.setLayout(new BoxLayout(this, 0));
        this.setVisible(true);
        this.cancel = new JButton("Can");
        this.addbutton(this, this.cancel, 35, ThWindow.BUTTONVERT);
        this.cancel.addActionListener(this);
        this.jump = new JButton("Jmp");
        this.addbutton(this, this.jump, 35, ThWindow.BUTTONVERT);
        this.jump.addActionListener(this);
        this.insert = new JButton("Ins");
        this.addbutton(this, this.insert, 35, ThWindow.BUTTONVERT);
        this.insert.addActionListener(this);
        this.delete = new JButton("Del");
        this.addbutton(this, this.delete, 35, ThWindow.BUTTONVERT);
        this.delete.addActionListener(this);
        this.copy = new JButton("Cpy");
        this.addbutton(this, this.copy, 35, ThWindow.BUTTONVERT);
        this.copy.addActionListener(this);
        this.move = new JButton("Mov");
        this.addbutton(this, this.move, 35, ThWindow.BUTTONVERT);
        this.move.addActionListener(this);
        this.cclip = new JComboBox();
        this.add(this.cclip);
        Dimension d = new Dimension(94, ThWindow.BUTTONVERT);
        this.cclip.setMaximumSize(d);
        this.cclip.setMinimumSize(d);
        this.cclip.setPreferredSize(d);
        this.cclip.addItem("Clip 1");
        this.cclip.addItem("Clip 2");
        this.cclip.addItem("Clip 3");
        this.cclip.addItem("Clip 4");
        this.cclip.addItem("Clip 5");
        this.cclip.addItem("Clip 6");
        this.cclip.addItem("Clip 7");
        this.cclip.addItem("Clip 8");
        this.cclip.addItem("Clip 9");
        this.cclip.addItem("Clip 10");
        this.cclip.addItem("Clip 20");
        this.cclip.addItem("Clip 99");
        this.cclip.setSelectedIndex(4);
        this.cclip.addActionListener(this);
        this.cclip.setActionCommand("Clipping");
        this.plus = new JButton("+");
        this.addbutton(this, this.plus, 15, ThWindow.BUTTONVERT);
        this.plus.addActionListener(this);
        this.minus = new JButton("-");
        this.addbutton(this, this.minus, 15, ThWindow.BUTTONVERT);
        this.minus.addActionListener(this);
        this.emsg = new MyMessage(this.frame);
        this.addbutton(this, this.emsg, 20, ThWindow.BUTTONVERT);
        this.ret = new JButton("R");
        this.addbutton(this, this.ret, 14, ThWindow.BUTTONVERT);
        this.ret.addActionListener(this);
        this.toolkit = Toolkit.getDefaultToolkit();
    }

    public void enableControls() {
        this.cancel.setEnabled(false);
        this.jump.setEnabled(true);
        this.insert.setEnabled(true);
        this.delete.setEnabled(true);
        this.copy.setEnabled(true);
        this.move.setEnabled(true);
    }

    public void disableControls() {
        this.cancel.setEnabled(true);
        this.jump.setEnabled(false);
        this.insert.setEnabled(false);
        this.delete.setEnabled(false);
        this.copy.setEnabled(false);
        this.move.setEnabled(false);
    }

    public void emsgRepaint() {
        this.emsg.repaint();
    }

    public void setMessage(String s) {
        this.emsg.setMessage(s);
    }

    private void addbutton(Container container, JComponent component, int width, int height) {
        BevelBorder b = new BevelBorder(0);
        Dimension d = new Dimension(width, height);
        component.setBorder(b);
        container.add(component);
        component.setPreferredSize(d);
    }

    public void setClipping(int clip) {
        int i = 0;
        if (clip < 11) {
            i = clip - 1;
        } else if (clip == 20) {
            i = 10;
        } else if (clip > 20) {
            i = 11;
        }
        this.cclip.setSelectedIndex(i);
    }

    public void actionPerformed(ActionEvent e) {
        DocView docview = this.frame.getDocView();
        String s = e.getActionCommand();
        if (s == "Clipping") {
            JComboBox cb = (JComboBox)e.getSource();
            int i = cb.getSelectedIndex();
            if (i < 0) {
                return;
            }
            i = i < 10 ? ++i : (i == 10 ? 20 : 99);
            docview.setClipping(i);
            this.frame.getOptions().setClipping(i);
            docview.repaint();
            return;
        }
        if (s == "+" || s == "-") {
            int i = this.cclip.getSelectedIndex();
            int max = this.cclip.getItemCount();
            if (s == "+") {
                if (i < max - 1) {
                    ++i;
                }
            } else if (i > 0) {
                --i;
            }
            if (i < 0) {
                i = 0;
            }
            this.cclip.setSelectedIndex(i);
            i = i < 10 ? ++i : (i == 10 ? 20 : 99);
            docview.setClipping(i);
            this.frame.getOptions().setClipping(i);
            this.frame.updateOptionsMenu();
            docview.repaint();
            return;
        }
        JButton bu = (JButton)e.getSource();
        int x = bu.getX();
        int y = bu.getY();
        Rectangle bounds = bu.getBounds();
        this.frame.updateMouse(x += bounds.width / 2, y -= bounds.height / 2);
        if (docview.isMarking()) {
            if (e.getActionCommand() == "Can") {
                docview.cancelMarking();
                docview.clearAllMarked();
                docview.repaint();
                this.frame.errormsg("");
            } else {
                this.toolkit.beep();
            }
            return;
        }
        if (e.getActionCommand() == "Ins") {
            docview.startMarking(new ThInsert(this.frame), 1);
            return;
        }
        if (e.getActionCommand() == "Del") {
            new ThDelete(this.frame).deleteChoice(x, y);
            return;
        }
        if (e.getActionCommand() == "Mov") {
            new ThMove(this.frame).moveChoice(x, y);
            return;
        }
        if (e.getActionCommand() == "Cpy") {
            new ThCopy(this.frame).copyChoice(x, y);
            return;
        }
        if (e.getActionCommand() == "Jmp") {
            int modifiers = e.getModifiers();
            if ((modifiers & 4) == 4) {
                docview.startMarking(new ThJump(this.frame), 5);
                return;
            }
            docview.startMarking(new ThJump(this.frame), 3);
        }
        if (e.getActionCommand() == "R") {
            ThJump thjump = new ThJump(this.frame);
            thjump.jumpRet(x, y, true);
            thjump = null;
        }
    }
}

