/*
 * Decompiled with CFR 0.152.
 */
class ChainBlock {
    public static final int CHAINMAX = 124;
    private static final int nextOffset = 0;
    private static final int dataOffset = 4;
    Doc doc;
    int chain;
    byte[] data;
    int block;

    public ChainBlock(Doc d, int blocknumber) {
        this.doc = d;
        this.block = blocknumber;
        byte[] buf = new byte[128];
        d.getBlock(buf, 0, blocknumber);
        this.chain = Cbytes.byteToInt(buf, 0);
        this.data = new byte[124];
        for (int i = 0; i < 124; ++i) {
            this.data[i] = buf[4 + i];
        }
    }

    public ChainBlock(Doc d) {
        this.doc = d;
        this.block = this.doc.allocateBlock();
        this.data = new byte[124];
        this.chain = 0;
    }

    public int getBlockNumber() {
        return this.block;
    }

    public int getLength() {
        return 124;
    }

    public int getChain() {
        return this.chain;
    }

    public void setChain(int newchain) {
        this.chain = newchain;
    }

    public void getData(byte[] b, int offset, int length) {
        if (length > 124) {
            length = 124;
        }
        for (int i = 0; i < length; ++i) {
            b[offset + i] = this.data[i];
        }
    }

    public int setData(byte[] b, int offset, int length) {
        int len = length;
        if (len > 124) {
            len = 124;
        }
        for (int i = 0; i < len; ++i) {
            this.data[i] = b[offset + i];
        }
        return len;
    }

    public void putBlock() {
        byte[] buf = new byte[128];
        Cbytes.intToByte(this.chain, buf, 0);
        for (int i = 0; i < 124; ++i) {
            buf[4 + i] = this.data[i];
        }
        this.doc.putBlock(buf, 0, this.block, false);
    }
}

