/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;

class CharFormat {
    int charfont;
    short charsize;
    byte charstyle;
    FontTable fonttable;
    public static final byte STYLE_NORMAL = 0;
    public static final byte STYLE_UNDERLINE = 1;
    public static final byte STYLE_BOLD = 2;
    public static final byte STYLE_ITALIC = 4;
    public static final byte EXPOSABLE = 8;

    public CharFormat() {
        this.charfont = 0;
        this.charsize = 0;
        this.charstyle = 0;
    }

    public CharFormat(CharFormat cf) {
        this.charfont = cf.getFace();
        this.charsize = cf.getSize();
        this.charstyle = cf.getStyle();
        this.fonttable = cf.getFontTable();
    }

    public CharFormat(int font, short size, byte style, FontTable ft) {
        this.charfont = font;
        this.charsize = size;
        this.charstyle = style;
        this.fonttable = ft;
    }

    public CharFormat(String fontname, short size, byte style, FontTable ft) {
        this.charsize = size;
        this.charstyle = style;
        this.fonttable = ft;
        this.charfont = this.fonttable.whatNum(fontname);
    }

    public boolean equals(CharFormat cf) {
        if (cf.getFace() != this.charfont) {
            return false;
        }
        if (cf.getSize() != this.charsize) {
            return false;
        }
        return cf.getStyle() == this.charstyle;
    }

    public int getFace() {
        return this.charfont;
    }

    public short getSize() {
        return this.charsize;
    }

    public byte getStyle() {
        return this.charstyle;
    }

    public FontTable getFontTable() {
        return this.fonttable;
    }

    public String getFontName() {
        String face = this.fonttable.whatFace(this.charfont);
        return face;
    }

    public boolean isEqual(CharFormat in) {
        if (in.getStyle() != this.charstyle) {
            return false;
        }
        if (in.getFace() != this.charfont) {
            return false;
        }
        return in.getSize() == this.charsize;
    }

    public boolean isUnderline() {
        return (this.charstyle & 1) == 1;
    }

    public Font getFont() {
        int style = 0;
        if (this.charstyle == 0) {
            style = 0;
        }
        if ((this.charstyle & 2) == 2) {
            style = 1;
        }
        if ((this.charstyle & 4) == 4) {
            style |= 2;
        }
        return new Font(this.getFontName(), style, this.getSize());
    }
}

