/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;

abstract class Gif {
    private static final int MAXCOLORMAPSIZE = 256;
    private static final int CM_RED = 0;
    private static final int CM_GREEN = 1;
    private static final int CM_BLUE = 2;
    private static final int MAX_LWZ_BITS = 12;
    private static final int INTERLACE = 64;
    private static final int LOCALCOLORMAP = 128;
    private static short Gif89transparent = (short)-1;
    private static short Gif89delayTime = (short)-1;
    private static short Gif89inputFlag = (short)-1;
    private static short Gif89disposal = 0;
    private static boolean ZeroDataBlock = false;
    private static short[][] table = new short[2][8192];
    private static short[] stack = new short[16384];
    private static short sp = 0;
    static boolean fresh = false;
    static short code_size = 0;
    static short set_code_size = 0;
    static short max_code = 0;
    static short max_code_size = 0;
    static short firstcode = 0;
    static short oldcode = 0;
    static short clear_code = 0;
    static short end_code = 0;
    static byte[] buf = new byte[280];
    static short curbit = 0;
    static short lastbit = 0;
    static short last_byte = 0;
    static boolean done = false;

    Gif() {
    }

    public static Image arraytoGif(byte[] array, int length) {
        byte[][] GifScreenColorMap = new byte[3][256];
        ByteArrayInputStream fh = new ByteArrayInputStream(array, 0, length);
        byte[] buf = new byte[16];
        byte[][] localColorMap = new byte[3][256];
        short useGlobalColormap = 1;
        short bitPixel = 0;
        int imageCount = 0;
        short localWidth = 0;
        short localHeight = 0;
        short localDepth = 0;
        if (0 == Gif.ReadOK(fh, buf, 6)) {
            return null;
        }
        if (buf[0] != 71 && buf[1] != 73 && buf[2] != 70 && buf[3] != 56) {
            return null;
        }
        if (0 == Gif.ReadOK(fh, buf, 7)) {
            return null;
        }
        short GifScreenWidth = Gif.LM_to_uint(buf[0], buf[1]);
        short GifScreenHeight = Gif.LM_to_uint(buf[2], buf[3]);
        short GifScreenBitPixel = (short)(2 << (Cbytes.charToShort(buf[4]) & 7));
        short GifScreenDepth = (short)((Cbytes.charToShort(buf[4]) & 7) + 1);
        short GifScreenColorResolution = (short)(((Cbytes.charToShort(buf[4]) & 0x70) >> 3) + 1);
        short GifScreenBackground = Cbytes.charToShort(buf[5]);
        short GifScreenAspectRatio = Cbytes.charToShort(buf[6]);
        byte[] pixels = new byte[GifScreenWidth * (GifScreenHeight + 1)];
        short GifScreenGrayScale = 0;
        if (Gif.BitSet(buf[4], (byte)-128) && (GifScreenGrayScale = Gif.ReadColorMap(fh, GifScreenBitPixel, GifScreenColorMap)) == -1) {
            return null;
        }
        while (true) {
            if (0 == Gif.ReadOK(fh, buf, 1)) {
                return null;
            }
            if (buf[0] == 59) {
                Image image = Gif.doendgif(GifScreenBitPixel, useGlobalColormap, GifScreenColorMap, GifScreenWidth, GifScreenHeight, GifScreenDepth, localColorMap, localWidth, localHeight, localDepth, pixels, bitPixel);
                return image;
            }
            if (buf[0] == 33) {
                Image image = Gif.doendgif(GifScreenBitPixel, useGlobalColormap, GifScreenColorMap, GifScreenWidth, GifScreenHeight, GifScreenDepth, localColorMap, localWidth, localHeight, localDepth, pixels, bitPixel);
                return image;
            }
            if (buf[0] != 44) continue;
            imageCount = (short)(imageCount + 1);
            if (0 == Gif.ReadOK(fh, buf, 9)) {
                return null;
            }
            useGlobalColormap = 1;
            if (Gif.BitSet(buf[8], (byte)-128)) {
                useGlobalColormap = 0;
            }
            bitPixel = (short)(1 << (buf[8] & 7) + 1);
            localDepth = (short)((buf[8] & 7) + 1);
            short interlace = 0;
            if (Gif.BitSet(buf[8], (byte)64)) {
                interlace = 1;
            }
            localWidth = Gif.LM_to_uint(buf[4], buf[5]);
            localHeight = Gif.LM_to_uint(buf[6], buf[7]);
            if (useGlobalColormap == 0) {
                short grayScale = Gif.ReadColorMap(fh, bitPixel, localColorMap);
                if (grayScale == -1) {
                    return null;
                }
                if (0 != Gif.ReadImage(fh, localWidth, localHeight, localColorMap, grayScale, interlace, pixels)) continue;
                return null;
            }
            if (0 == Gif.ReadImage(fh, localWidth, localHeight, GifScreenColorMap, GifScreenGrayScale, interlace, pixels)) break;
        }
        return null;
    }

    private static Image doendgif(short GifScreenBitPixel, short useGlobalColormap, byte[][] GifScreenColorMap, short GifScreenWidth, short GifScreenHeight, short GifScreenDepth, byte[][] localColorMap, short localWidth, short localHeight, short localDepth, byte[] pixels, short bitPixel) {
        byte[] r = new byte[GifScreenBitPixel];
        byte[] g = new byte[GifScreenBitPixel];
        byte[] b = new byte[GifScreenBitPixel];
        if (useGlobalColormap == 1) {
            for (int i = 0; i < GifScreenBitPixel; ++i) {
                r[i] = GifScreenColorMap[0][i];
                g[i] = GifScreenColorMap[1][i];
                b[i] = GifScreenColorMap[2][i];
            }
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource((int)GifScreenWidth, (int)GifScreenHeight, (ColorModel)new IndexColorModel((int)GifScreenDepth, GifScreenBitPixel, r, g, b), pixels, 0, (int)GifScreenWidth));
            return image;
        }
        for (int i = 0; i < bitPixel; ++i) {
            r[i] = localColorMap[0][i];
            g[i] = localColorMap[1][i];
            b[i] = localColorMap[2][i];
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource((int)localWidth, (int)localHeight, (ColorModel)new IndexColorModel((int)localDepth, bitPixel, r, g, b), pixels, 0, (int)localWidth));
        return image;
    }

    private static short ReadImage(ByteArrayInputStream fh, short cols, short rows, byte[][] cmap, short gray, short interlace, byte[] pixels) {
        short v;
        byte[] c = new byte[1];
        int pass = 0;
        if (0 == Gif.ReadOK(fh, c, 1)) {
            return 0;
        }
        if (Gif.LWZReadByte(fh, true, Cbytes.charToShort(c[0])) < 0) {
            return 0;
        }
        int ypos = 0;
        int xpos = 0;
        while ((v = Gif.LWZReadByte(fh, false, Cbytes.charToShort(c[0]))) >= 0) {
            block15: {
                block16: {
                    pixels[ypos * cols + xpos] = (byte)v;
                    if ((xpos = (short)(xpos + 1)) != cols) break block15;
                    xpos = 0;
                    if (interlace == 0) break block16;
                    switch (pass) {
                        case 0: 
                        case 1: {
                            ypos = (short)(ypos + 8);
                            break;
                        }
                        case 2: {
                            ypos = (short)(ypos + 4);
                            break;
                        }
                        case 3: {
                            ypos = (short)(ypos + 2);
                        }
                    }
                    if (ypos < rows) break block15;
                    pass = (short)(pass + 1);
                    switch (pass) {
                        case 1: {
                            ypos = 4;
                            break block15;
                        }
                        case 2: {
                            ypos = 2;
                            break block15;
                        }
                        case 3: {
                            ypos = 1;
                            break block15;
                        }
                        default: {
                            if (Gif.LWZReadByte(fh, false, Cbytes.charToShort(c[0])) > 0) {
                                // empty if block
                            }
                            return 1;
                        }
                    }
                }
                ypos = (short)(ypos + 1);
            }
            if (ypos < rows) continue;
        }
        if (Gif.LWZReadByte(fh, false, Cbytes.charToShort(c[0])) >= 0) {
            // empty if block
        }
        return 1;
    }

    private static short LWZReadByte(ByteArrayInputStream fh, boolean flag, short input_code_size) {
        short code;
        if (flag) {
            short i;
            set_code_size = input_code_size;
            code_size = (short)(set_code_size + 1);
            clear_code = (short)(1 << set_code_size);
            end_code = (short)(clear_code + 1);
            max_code_size = (short)(2 * clear_code);
            max_code = (short)(clear_code + 2);
            Gif.GetCode(fh, (short)0, true);
            fresh = true;
            for (i = 0; i < clear_code; i = (short)(i + 1)) {
                Gif.table[0][i] = 0;
                Gif.table[1][i] = i;
            }
            while (i < 4096) {
                Gif.table[1][i] = 0;
                Gif.table[0][i] = 0;
                i = (short)(i + 1);
            }
            sp = 0;
            return 0;
        }
        if (fresh) {
            fresh = false;
            while ((firstcode = (oldcode = Gif.GetCode(fh, code_size, false))) == clear_code) {
            }
            return firstcode;
        }
        if (sp > 0) {
            sp = (short)(sp - 1);
            return stack[sp];
        }
        while ((code = Gif.GetCode(fh, code_size, false)) >= 0) {
            if (code == clear_code) {
                short i;
                for (i = 0; i < clear_code; i = (short)(i + 1)) {
                    Gif.table[0][i] = 0;
                    Gif.table[1][i] = i;
                }
                while (i < 4096) {
                    Gif.table[1][i] = 0;
                    Gif.table[0][i] = 0;
                    i = (short)(i + 1);
                }
                code_size = (short)(set_code_size + 1);
                max_code_size = (short)(2 * clear_code);
                max_code = (short)(clear_code + 2);
                sp = 0;
                firstcode = oldcode = Gif.GetCode(fh, code_size, false);
                return firstcode;
            }
            if (code == end_code) {
                short count;
                byte[] buf = new byte[260];
                if (ZeroDataBlock) {
                    return -2;
                }
                while ((count = Gif.GetDataBlock(fh, buf)) > 0) {
                }
                return -2;
            }
            short incode = code;
            if (code >= max_code) {
                short s = sp;
                sp = (short)(s + 1);
                Gif.stack[s] = firstcode;
                code = oldcode;
            }
            while (code >= clear_code) {
                short s = sp;
                sp = (short)(s + 1);
                Gif.stack[s] = table[1][code];
                code = table[0][code];
            }
            short s = sp;
            sp = (short)(s + 1);
            Gif.stack[s] = firstcode = table[1][code];
            code = max_code;
            if (code < 4096) {
                Gif.table[0][code] = oldcode;
                Gif.table[1][code] = firstcode;
                if ((max_code = (short)(max_code + 1)) >= max_code_size && max_code_size < 4096) {
                    max_code_size = (short)(max_code_size * 2);
                    code_size = (short)(code_size + 1);
                }
            }
            oldcode = incode;
            if (sp <= 0) continue;
            sp = (short)(sp - 1);
            return stack[sp];
        }
        return 0;
    }

    private static short GetCode(ByteArrayInputStream fh, short code_size, boolean flag) {
        short i;
        byte[] buf1 = new byte[280];
        if (flag) {
            curbit = 0;
            lastbit = 0;
            done = false;
            last_byte = (short)2;
            return 0;
        }
        if (curbit + code_size >= lastbit) {
            if (done) {
                return -1;
            }
            Gif.buf[0] = buf[last_byte - 2];
            Gif.buf[1] = buf[last_byte - 1];
            short count = Gif.GetDataBlock(fh, buf1);
            if (count == 0) {
                done = true;
            }
            for (i = 0; i < count; i = (short)(i + 1)) {
                Gif.buf[i + 2] = buf1[i];
            }
            last_byte = (short)(2 + count);
            curbit = (short)(curbit - lastbit + 16);
            lastbit = (short)((2 + count) * 8);
        }
        short ret = 0;
        i = curbit;
        for (short j = 0; j < code_size; j = (short)(j + 1)) {
            if (Gif.BitSet(buf[i / 8], (byte)(1 << i % 8))) {
                ret = (short)(ret | 1 << j);
            }
            i = (short)(i + 1);
        }
        curbit = (short)(curbit + code_size);
        return ret;
    }

    private static short GetDataBlock(ByteArrayInputStream fh, byte[] buf) {
        byte[] count = new byte[1];
        if (0 == Gif.ReadOK(fh, count, 1)) {
            return -1;
        }
        ZeroDataBlock = false;
        if (Cbytes.charToShort(count[0]) == 0) {
            ZeroDataBlock = true;
        }
        if (Cbytes.charToShort(count[0]) != 0 && 0 == Gif.ReadOK(fh, buf, Cbytes.charToShort(count[0]))) {
            return -1;
        }
        return Cbytes.charToShort(count[0]);
    }

    private static void DoExtension(ByteArrayInputStream fh, byte c) {
        byte[] buf = new byte[256];
        switch (c) {
            case 1: {
                while (1 == Gif.GetDataBlock(fh, buf)) {
                }
                return;
            }
            case 255: {
                return;
            }
            case 254: {
                while (1 == Gif.GetDataBlock(fh, buf)) {
                }
                return;
            }
            case 249: {
                if (0 == Gif.GetDataBlock(fh, buf)) {
                    return;
                }
                Gif89disposal = (short)(buf[0] >> 2 & 7);
                Gif89inputFlag = (short)(buf[0] >> 1 & 1);
                Gif89delayTime = Gif.LM_to_uint(buf[1], buf[2]);
                if ((buf[0] & 1) != 0) {
                    Gif89transparent = buf[3];
                }
                while (1 == Gif.GetDataBlock(fh, buf)) {
                }
                return;
            }
        }
    }

    private static short ReadColorMap(ByteArrayInputStream fh, short number, byte[][] colormap) {
        byte[] rgb = new byte[3];
        boolean flag = true;
        for (int i = 0; i < number; ++i) {
            if (0 == Gif.ReadOK(fh, rgb, 3)) {
                return -1;
            }
            colormap[0][i] = rgb[0];
            colormap[1][i] = rgb[1];
            colormap[2][i] = rgb[2];
            flag &= rgb[0] == rgb[1] && rgb[1] == rgb[2];
        }
        if (flag && number == 2) {
            return 1;
        }
        return 0;
    }

    private static short ReadOK(ByteArrayInputStream fh, byte[] buffer, int len) {
        int nbytes = fh.read(buffer, 0, len);
        if (nbytes == len) {
            return 1;
        }
        return 0;
    }

    private static boolean BitSet(byte b, byte bit) {
        return (b & bit) == bit;
    }

    private static short LM_to_uint(byte a, byte b) {
        return (short)(Cbytes.charToShort(b) << 8 | Cbytes.charToShort(a));
    }
}

