/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import javax.swing.JTextArea;

class MyClipTextArea
extends JTextArea {
    public MyClipTextArea(int rows, int cols) {
        super(rows, cols);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (cb == null) {
            this.append("No Clipboard\n");
            return;
        }
        Transferable tf = cb.getContents(this);
        if (tf == null) {
            this.append("No Content\n");
            return;
        }
        DataFlavor[] df = tf.getTransferDataFlavors();
        if (df == null) {
            this.append("No DataFlavors\n");
            return;
        }
        if (df.length == 0) {
            this.append("No DataFlavors\n");
            return;
        }
        for (int i = 0; i < df.length; ++i) {
            Class<?> c;
            Object o;
            String st = df[i].getHumanPresentableName();
            this.append(st);
            this.append("\n");
            if (st.compareTo("Plain Text") == 0) {
                try {
                    o = tf.getTransferData(df[i]);
                    c = o.getClass();
                    st = c.getName();
                    this.append(st);
                    this.append("\n");
                    char[] bytes = new char[256];
                    StringReader sr = (StringReader)o;
                    sr.read(bytes, 0, 256);
                    String str = new String(bytes);
                    this.append(str);
                    this.append("\n");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (st.compareTo("'TEXT'") != 0) continue;
            try {
                o = tf.getTransferData(df[i]);
                c = o.getClass();
                st = c.getName();
                this.append(st);
                this.append("\n");
                ByteArrayInputStream is = (ByteArrayInputStream)o;
                int len = is.available();
                byte[] bytes = new byte[len];
                is.read(bytes, 0, len);
                String str = new String(bytes);
                this.append(str);
                this.append("\n");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

