/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

class Options {
    Doc doc;
    public static final boolean DoJava2 = true;
    private static final int SPACING = 8;
    private static final int CLIP = 10;
    private static final int NLINES = 12;
    private static final int NJC = 14;
    private static final int AUTO = 16;
    private static final int FLAGF = 18;
    private static final int HIDEL = 20;
    private static final int CTHRU = 22;
    private static final int LCOPY = 24;
    private static final int SCJ = 26;
    private static final int ALLOWP = 28;
    private static final int DISABLET = 30;
    private static final int V2RINDENT = 32;
    private static final int PARAINDENT = 33;
    private static final int GASGIF = 33;
    private static final int OLDSCROLL = 34;
    private static final int SHOWL = 34;
    private static final int PAGEMODE = 35;
    private static final int REPLACE = 35;
    private static final int COVERLINKS = 36;
    private static final int STYLEDELIMIT = 37;
    private static final int FONT = 38;
    private static final int FSIZE = 40;
    private static final int HIDEINVIS = 42;
    private static final int CREQINS = 43;
    private static final int FASTSCROLL = 44;
    private static final int SHOWDATE = 45;
    private static final int HIDECR = 46;
    private static final int CLOSE = 47;
    private static final int SHOWFMT = 48;
    private static final int SHIFTCLICK = 49;
    private static final int FLAGNEW = 50;
    private static final int HIDEMARKUP = 51;
    private static final int CHGBAR = 52;
    private static final int V2FMT = 56;
    private static final int V2NEED = 57;
    private static final int V2INDENT = 58;
    private static final int V2UNUSED = 59;
    private static final int X7 = 60;
    private static final int OPTIONSSIZE = 62;
    private static final int TOP = 8;
    private static final int LEFT = 10;
    private static final int BOTTOM = 12;
    private static final int RIGHT = 14;
    private static final int FILENAME = 47;
    private static final int LABEL = 302;
    private static final int WINDOWDESSIZE = 334;
    private static final int PDOFILE = 8;
    private static final int PDOLEVELS = 9;
    private static final int PDOHEADERS = 10;
    private static final int PDOFOOTERS = 11;
    private static final int PDOLINES = 12;
    private static final int PDOJUST = 14;
    private static final int PLEADING = 15;
    private static final int PWIDTH = 16;
    private static final int PHEIGHT = 18;
    private static final int PLM = 20;
    private static final int PRM = 22;
    private static final int PTM = 24;
    private static final int PBM = 26;
    private static final int PDOTWOSIDE = 28;
    private static final int PDOTWOCOL = 29;
    private static final int PPAGEN = 30;
    private static final int PMAXPAGE = 32;
    private static final int PLH = 36;
    private static final int PRH = 100;
    private static final int PLF = 164;
    private static final int PRF = 228;
    private static final int POPTIONSIZE = 292;
    private short spacing;
    private short clip;
    private short nlines;
    private boolean nojumpconfirm;
    private boolean autoinsert;
    private boolean flagforced;
    private boolean hidelabels;
    private boolean enablecthru;
    private boolean localcopy;
    private boolean singleclickjump;
    private boolean allowp;
    private boolean disabletype;
    private boolean paraindent;
    private boolean graphicsasgif;
    private boolean oldscroll;
    private boolean showlevels;
    private boolean pagemode;
    private boolean replaceastyped;
    private boolean coverlinks;
    private boolean styledelimit;
    private int rightindent;
    private String font;
    private short fontsize;
    private short fontnumber;
    private boolean hideinvisible;
    private boolean crequalsins;
    private boolean fastscroll;
    private boolean showdate;
    private boolean hidecr;
    private boolean closeunneeded;
    private boolean showformat;
    private boolean shiftclick;
    private boolean flagnew;
    private boolean hidemarkup;
    private int chgbar;
    private int v2need;
    private int v2indent;
    private int v2fmt;
    private boolean pdofile;
    private boolean pdolevels;
    private boolean pdoheaders;
    private boolean pdofooters;
    private boolean pdojust;
    private boolean pdotwoside;
    private boolean pdotwocol;
    private boolean pdolines;
    private short pleading;
    private short pwidth;
    private short pheight;
    private short plm;
    private short prm;
    private short ptm;
    private short pbm;
    private short ppagen;
    private short pmaxpage;
    private String plefthead;
    private String prighthead;
    private String pleftfoot;
    private String prightfoot;
    private int top;
    private int left;
    private int bottom;
    private int right;
    private String filename;
    private String label;
    private boolean cancelprint;
    ThWindow frame;

    public Options() {
        this.frame = null;
        this.setDefaults();
        this.filename = "";
        this.label = null;
        this.cancelprint = false;
    }

    public Options(Doc d, ThWindow f) {
        this.doc = d;
        this.frame = f;
        this.filename = this.doc.getFullname();
        this.label = "";
        int resblock = this.doc.getResourcesBlock();
        if (resblock != 0) {
            this.buildOptions(resblock);
        } else {
            this.buildOptions();
        }
    }

    public void cancelPrint(boolean tf) {
        this.cancelprint = tf;
    }

    public boolean isCancelPrint() {
        return this.cancelprint;
    }

    public ThWindow getFrame() {
        return this.frame;
    }

    public Rectangle getWindowRect() {
        return new Rectangle(this.left, this.top, this.right - this.left, this.bottom - this.top);
    }

    public String getLabel() {
        return this.label;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setWindowRect(Rectangle bounds) {
        this.top = bounds.y;
        this.left = bounds.x;
        this.bottom = this.top + bounds.height;
        this.right = this.left + bounds.width;
    }

    public void setLabel(String la) {
        this.label = la;
    }

    public void setFilename(String fi) {
        this.filename = fi;
    }

    public boolean getSCJ() {
        return this.singleclickjump;
    }

    public void setSCJ(boolean b) {
        this.singleclickjump = b;
    }

    public short getClipping() {
        return this.clip;
    }

    public void setClipping(int c) {
        this.clip = (short)c;
    }

    public short getNlines() {
        return this.nlines;
    }

    public void setNlines(int n) {
        this.nlines = (short)n;
    }

    public short getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int s) {
        this.spacing = (short)s;
    }

    public short getFontSize() {
        return this.fontsize;
    }

    public void setFontSize(int fs) {
        this.fontsize = (short)fs;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String fn) {
        this.fontnumber = (short)new FontTable().whatNum(fn);
    }

    public boolean getSeeThrough() {
        return this.enablecthru;
    }

    public void setSeeThrough(boolean ct) {
        this.enablecthru = ct;
    }

    public boolean getShowDate() {
        return this.showdate;
    }

    public void setShowDate(boolean sd) {
        this.showdate = sd;
    }

    public boolean getShowLevel() {
        return this.showlevels;
    }

    public void setShowLevel(boolean sl) {
        this.showlevels = sl;
    }

    public boolean getNoJumpConfirm() {
        return this.nojumpconfirm;
    }

    public void setNoJumpConfirm(boolean njc) {
        this.nojumpconfirm = njc;
    }

    public boolean getPageMode() {
        return this.pagemode;
    }

    public void setPageMode(boolean pm) {
        this.pagemode = pm;
    }

    public boolean getHideLabels() {
        return this.hidelabels;
    }

    public void setHideLabels(boolean hl) {
        this.hidelabels = hl;
    }

    public int getRIndent() {
        return this.rightindent;
    }

    public void setRIndent(int ri) {
        this.rightindent = ri;
    }

    public int getIndent() {
        return this.v2indent;
    }

    public void setIndent(int ii) {
        this.v2indent = ii;
    }

    public int getNeed() {
        return this.v2need;
    }

    public void setNeed(int ne) {
        this.v2need = ne;
    }

    public int getV2FMT() {
        return this.v2fmt;
    }

    public void setV2FMT(int fmt) {
        this.v2fmt = fmt;
    }

    public boolean getSDL() {
        return this.styledelimit;
    }

    public void setSDL(boolean b) {
        this.styledelimit = b;
    }

    public boolean getPDoFile() {
        return this.pdofile;
    }

    public void setPDoFile(boolean b) {
        this.pdofile = b;
    }

    public boolean getPDoLevels() {
        return this.pdolevels;
    }

    public void setPDoLevels(boolean b) {
        this.pdolevels = b;
    }

    public boolean getPDoHeaders() {
        return this.pdoheaders;
    }

    public void setPDoHeaders(boolean b) {
        this.pdoheaders = b;
    }

    public boolean getPDoLines() {
        return this.pdolines;
    }

    public void setPDoLines(boolean b) {
        this.pdolines = b;
    }

    public boolean getPDoFooters() {
        return this.pdofooters;
    }

    public void setPDoFooters(boolean b) {
        this.pdofooters = b;
    }

    public boolean getPDoJust() {
        return this.pdojust;
    }

    public void setPDoJust(boolean b) {
        this.pdojust = b;
    }

    public boolean getPDoTwoside() {
        return this.pdotwoside;
    }

    public void setPDoTwoside(boolean b) {
        this.pdotwoside = b;
    }

    public boolean getPDoTwocol() {
        return this.pdotwocol;
    }

    public void setPDoTwocol(boolean b) {
        this.pdotwocol = b;
    }

    public short getPLeading() {
        return this.pleading;
    }

    public void setPLeading(short s) {
        this.pleading = s;
    }

    public short getPWidth() {
        return this.pwidth;
    }

    public void setPWidth(short s) {
        this.pwidth = s;
    }

    public short getPHeight() {
        return this.pheight;
    }

    public void setPHeight(short s) {
        this.pheight = s;
    }

    public short getPTM() {
        return this.ptm;
    }

    public void setPTM(short s) {
        this.ptm = s;
    }

    public short getPBM() {
        return this.pbm;
    }

    public void setPBM(short s) {
        this.pbm = s;
    }

    public short getPLM() {
        return this.plm;
    }

    public void setPLM(short s) {
        this.plm = s;
    }

    public short getPRM() {
        return this.prm;
    }

    public void setPRM(short s) {
        this.prm = s;
    }

    public String getPLefthead() {
        return this.plefthead;
    }

    public void setPLefthead(String s) {
        this.plefthead = s;
    }

    public String getPRighthead() {
        return this.prighthead;
    }

    public void setPRighthead(String s) {
        this.prighthead = s;
    }

    public String getPLeftfoot() {
        return this.pleftfoot;
    }

    public void setPLeftfoot(String s) {
        this.pleftfoot = s;
    }

    public String getPRightfoot() {
        return this.prightfoot;
    }

    public void setPRightfoot(String s) {
        this.prightfoot = s;
    }

    public void setShowFormat(boolean b) {
        this.showformat = b;
    }

    public boolean getShowFormat() {
        return this.showformat;
    }

    public void saveOptions() {
        int i;
        byte[] text;
        TextStatement st;
        if (this.doc == null) {
            return;
        }
        int resblock = this.doc.getResourcesBlock();
        while (resblock != 0) {
            st = this.doc.getStatement(resblock);
            text = st.getBytes();
            String s = new String(text, 0, 4);
            resblock = st.getNext();
            st.freeStatement();
        }
        this.doc.setResourcesBlock(0);
        st = this.doc.getStatement();
        text = st.getBytes();
        st.setLength(62);
        st.setDirty();
        this.doc.setResourcesBlock(st.getBlockNumber());
        byte[] t = new String("TH1O").getBytes();
        for (i = 0; i < 4; ++i) {
            text[i] = t[i];
        }
        Cbytes.intToByte(128, text, 4);
        Cbytes.shortToByte(this.spacing, text, 8);
        Cbytes.shortToByte(this.clip, text, 10);
        Cbytes.shortToByte(this.nlines, text, 12);
        if (this.nojumpconfirm) {
            Cbytes.shortToByte((short)1, text, 14);
        }
        if (this.autoinsert) {
            Cbytes.shortToByte((short)1, text, 16);
        }
        if (this.flagforced) {
            Cbytes.shortToByte((short)1, text, 18);
        }
        if (this.hidelabels) {
            Cbytes.shortToByte((short)1, text, 20);
        }
        if (this.enablecthru) {
            Cbytes.shortToByte((short)1, text, 22);
        }
        if (this.localcopy) {
            Cbytes.shortToByte((short)1, text, 24);
        }
        if (this.singleclickjump) {
            Cbytes.shortToByte((short)1, text, 26);
        }
        if (this.allowp) {
            Cbytes.shortToByte((short)1, text, 28);
        }
        if (this.disabletype) {
            Cbytes.shortToByte((short)1, text, 30);
        }
        text[32] = (byte)this.rightindent;
        if (this.paraindent) {
            text[33] = (byte)(text[33] | 0xF0);
        }
        if (this.graphicsasgif) {
            text[33] = (byte)(text[33] | 0xF);
        }
        if (this.oldscroll) {
            text[34] = (byte)(text[34] | 0xF0);
        }
        if (this.showlevels) {
            text[34] = (byte)(text[34] | 0xF);
        }
        if (this.pagemode) {
            text[35] = (byte)(text[35] | 0xF0);
        }
        if (this.replaceastyped) {
            text[35] = (byte)(text[35] | 0xF);
        }
        if (this.coverlinks) {
            text[36] = 1;
        }
        if (this.styledelimit) {
            text[37] = 1;
        }
        Cbytes.shortToByte(this.fontnumber, text, 38);
        Cbytes.shortToByte(this.fontsize, text, 40);
        if (this.hideinvisible) {
            text[42] = 1;
        }
        if (this.crequalsins) {
            text[43] = 1;
        }
        if (this.fastscroll) {
            text[44] = 1;
        }
        if (this.showdate) {
            text[45] = 1;
        }
        if (this.hidecr) {
            text[46] = 1;
        }
        if (this.closeunneeded) {
            text[47] = 1;
        }
        if (this.showformat) {
            text[48] = 1;
        }
        if (this.shiftclick) {
            text[49] = 1;
        }
        if (this.flagnew) {
            text[50] = 1;
        }
        if (this.hidemarkup) {
            text[51] = 1;
        }
        Cbytes.intToByte(this.chgbar, text, 52);
        text[56] = (byte)this.v2fmt;
        text[57] = (byte)this.v2need;
        text[58] = (byte)this.v2indent;
        st.putStatement(null);
        StatementBlock sb = st.getStatementBlock();
        st = this.doc.getStatement();
        text = st.getBytes();
        st.setLength(334);
        st.setDirty();
        int block = st.getBlockNumber();
        sb.putNext(block);
        sb.putBlock();
        t = new String("TH1O").getBytes();
        for (i = 0; i < 4; ++i) {
            text[i] = t[i];
        }
        Cbytes.intToByte(130, text, 4);
        Cbytes.shortToByte((short)this.top, text, 8);
        Cbytes.shortToByte((short)this.left, text, 10);
        Cbytes.shortToByte((short)this.bottom, text, 12);
        Cbytes.shortToByte((short)this.right, text, 14);
        this.filename = this.doc.getFullname();
        int len = this.filename.length();
        if (len > 254) {
            len = 254;
        }
        t = this.filename.getBytes();
        for (i = 0; i < len; ++i) {
            text[47 + i] = t[i];
        }
        len = this.label.length();
        t = this.label.getBytes();
        for (i = 0; i < len; ++i) {
            text[302 + i] = t[i];
        }
        st.putStatement(null);
        sb = st.getStatementBlock();
        st = this.doc.getStatement();
        text = st.getBytes();
        st.setLength(292);
        st.setDirty();
        block = st.getBlockNumber();
        sb.putNext(block);
        sb.putBlock();
        t = new String("TH1P").getBytes();
        for (i = 0; i < 4; ++i) {
            text[i] = t[i];
        }
        Cbytes.intToByte(128, text, 4);
        if (this.pdofile) {
            text[8] = 1;
        }
        if (this.pdolevels) {
            text[9] = 1;
        }
        if (this.pdoheaders) {
            text[10] = 1;
        }
        if (this.pdofooters) {
            text[11] = 1;
        }
        if (this.pdojust) {
            text[14] = 1;
        }
        if (this.pdotwoside) {
            text[28] = 1;
        }
        if (this.pdotwocol) {
            text[29] = 1;
        }
        if (this.pdolines) {
            text[12] = 1;
        }
        text[15] = (byte)this.pleading;
        Cbytes.shortToByte(this.pwidth, text, 16);
        Cbytes.shortToByte(this.pheight, text, 18);
        Cbytes.shortToByte(this.plm, text, 20);
        Cbytes.shortToByte(this.prm, text, 22);
        Cbytes.shortToByte(this.ptm, text, 24);
        Cbytes.shortToByte(this.pbm, text, 26);
        Cbytes.shortToByte(this.ppagen, text, 30);
        Cbytes.shortToByte(this.pmaxpage, text, 32);
        if (this.plefthead != null) {
            len = this.plefthead.length();
            if (len > 63) {
                len = 63;
            }
            t = this.plefthead.getBytes();
            for (i = 0; i < len; ++i) {
                text[36 + i + 1] = t[i];
            }
            text[36] = (byte)len;
        }
        if (this.prighthead != null) {
            len = this.prighthead.length();
            if (len > 63) {
                len = 63;
            }
            t = this.prighthead.getBytes();
            for (i = 0; i < len; ++i) {
                text[100 + i + 1] = t[i];
            }
            text[100] = (byte)len;
        }
        if (this.pleftfoot != null) {
            len = this.pleftfoot.length();
            if (len > 63) {
                len = 63;
            }
            t = this.pleftfoot.getBytes();
            for (i = 0; i < len; ++i) {
                text[164 + i + 1] = t[i];
            }
            text[164] = (byte)len;
        }
        if (this.prightfoot != null) {
            len = this.prightfoot.length();
            if (len > 63) {
                len = 63;
            }
            t = this.prightfoot.getBytes();
            for (i = 0; i < len; ++i) {
                text[228 + i + 1] = t[i];
            }
            text[228] = (byte)len;
        }
        st.putStatement(null);
    }

    private void setDefaults() {
        this.spacing = (short)3;
        this.clip = (short)5;
        this.nlines = (short)99;
        this.autoinsert = true;
        this.graphicsasgif = true;
        this.font = new String("Times");
        this.fontsize = (short)12;
        this.fontnumber = (short)new FontTable().whatNum(this.font);
        this.crequalsins = true;
        this.showformat = false;
        this.styledelimit = false;
        this.top = 80;
        this.left = 80;
        this.right = 600;
        this.bottom = 400;
        this.pdofile = true;
        this.pdolevels = false;
        this.pdoheaders = false;
        this.pdofooters = false;
        this.pdojust = false;
        this.pdotwoside = false;
        this.pdotwocol = false;
        this.pdolines = false;
        this.pleading = 0;
        this.ppagen = 0;
        this.pmaxpage = 0;
        this.plefthead = new String("Thinker");
        this.prighthead = null;
        if (this.doc != null) {
            this.prighthead = this.doc.getFilename();
        }
        this.pleftfoot = null;
        this.prightfoot = new String("date:");
        this.pwidth = (short)850;
        this.pheight = (short)1100;
        this.plm = (short)100;
        this.prm = (short)100;
        this.ptm = (short)100;
        this.pbm = (short)100;
    }

    private void buildOptions(int block) {
        this.setDefaults();
        while (block != 0) {
            TextStatement st = this.doc.getStatement(block);
            byte[] text = st.getBytes();
            String s = new String(text, 0, 4);
            int resnumber = Cbytes.byteToInt(text, 4);
            if (s.compareTo("TH1P") == 0) {
                this.buildPrintOpts(st);
            }
            if (s.compareTo("TH1O") == 0 && resnumber == 128) {
                this.buildOpts(st);
            }
            if (s.compareTo("TH1O") == 0 && resnumber > 128) {
                this.buildWindowDes(st, resnumber);
            }
            block = st.getNext();
        }
    }

    private void buildOptions() {
        this.setDefaults();
    }

    private void buildPrintOpts(TextStatement st) {
        byte[] text = st.getBytes();
        this.pdofile = text[8] != 0;
        this.pdolevels = text[9] != 0;
        this.pdoheaders = text[10] != 0;
        this.pdofooters = text[11] != 0;
        this.pdolines = text[12] != 0;
        this.pdojust = text[14] != 0;
        this.pleading = text[15];
        this.pwidth = (short)Cbytes.byteToShort(text, 16);
        this.pheight = (short)Cbytes.byteToShort(text, 18);
        this.plm = (short)Cbytes.byteToShort(text, 20);
        this.prm = (short)Cbytes.byteToShort(text, 22);
        this.ptm = (short)Cbytes.byteToShort(text, 24);
        this.pbm = (short)Cbytes.byteToShort(text, 26);
        this.pdotwoside = text[28] != 0;
        this.pdotwocol = text[29] != 0;
        this.ppagen = (short)Cbytes.byteToShort(text, 30);
        this.pmaxpage = (short)Cbytes.byteToShort(text, 32);
        int len = Cbytes.strlen(text, 36);
        byte tlen = text[36];
        this.plefthead = len == tlen + 1 ? new String(text, 37, (int)tlen) : new String(text, 36, len);
        len = Cbytes.strlen(text, 100);
        tlen = text[100];
        this.prighthead = len == tlen + 1 ? new String(text, 101, (int)tlen) : new String(text, 100, len);
        len = Cbytes.strlen(text, 164);
        tlen = text[164];
        this.pleftfoot = len == tlen + 1 ? new String(text, 165, (int)tlen) : new String(text, 164, len);
        len = Cbytes.strlen(text, 228);
        tlen = text[228];
        this.prightfoot = len == tlen + 1 ? new String(text, 229, (int)tlen) : new String(text, 228, len);
    }

    private void buildOpts(TextStatement st) {
        byte[] text = st.getBytes();
        this.spacing = (short)Cbytes.byteToShort(text, 8);
        this.clip = (short)Cbytes.byteToShort(text, 10);
        this.nlines = (short)Cbytes.byteToShort(text, 12);
        if (Cbytes.byteToShort(text, 14) != 0) {
            this.nojumpconfirm = true;
        }
        if (Cbytes.byteToShort(text, 16) != 0) {
            this.autoinsert = true;
        }
        if (Cbytes.byteToShort(text, 18) != 0) {
            this.flagforced = true;
        }
        if (Cbytes.byteToShort(text, 20) != 0) {
            this.hidelabels = true;
        }
        if (Cbytes.byteToShort(text, 22) != 0) {
            this.enablecthru = true;
        }
        if (Cbytes.byteToShort(text, 24) != 0) {
            this.localcopy = true;
        }
        if (Cbytes.byteToShort(text, 26) != 0) {
            this.singleclickjump = true;
        }
        if (Cbytes.byteToShort(text, 28) != 0) {
            this.allowp = true;
        }
        if (Cbytes.byteToShort(text, 30) != 0) {
            this.disabletype = true;
        }
        this.rightindent = text[32];
        if ((text[33] & 0xF0) != 0) {
            this.paraindent = true;
        }
        if ((text[33] & 0xF) != 0) {
            this.graphicsasgif = true;
        }
        if ((text[34] & 0xF0) != 0) {
            this.oldscroll = true;
        }
        if ((text[34] & 0xF) != 0) {
            this.showlevels = true;
        }
        if ((text[35] & 0xF0) != 0) {
            this.pagemode = true;
        }
        if ((text[35] & 0xF) != 0) {
            this.replaceastyped = true;
        }
        if (text[36] != 0) {
            this.coverlinks = true;
        }
        if (text[37] != 0) {
            this.styledelimit = true;
        }
        this.fontnumber = (short)Cbytes.byteToShort(text, 38);
        this.font = new FontTable().whatFace(this.fontnumber);
        this.fontsize = (short)Cbytes.byteToShort(text, 40);
        if (text[42] != 0) {
            this.hideinvisible = true;
        }
        if (text[43] != 0) {
            this.crequalsins = true;
        }
        if (text[44] != 0) {
            this.fastscroll = true;
        }
        if (text[45] != 0) {
            this.showdate = true;
        }
        if (text[46] != 0) {
            this.hidecr = true;
        }
        if (text[47] != 0) {
            this.closeunneeded = true;
        }
        if (text[48] != 0) {
            this.showformat = true;
        }
        if (text[49] != 0) {
            this.shiftclick = true;
        }
        if (text[50] != 0) {
            this.flagnew = true;
        }
        if (text[51] != 0) {
            this.hidemarkup = true;
        }
        this.chgbar = Cbytes.byteToInt(text, 52);
        this.v2fmt = text[56];
        this.v2need = text[57];
        this.v2indent = text[58];
    }

    private void buildWindowDes(TextStatement st, int resnumber) {
        byte[] text = st.getBytes();
        if (resnumber != 130) {
            return;
        }
        this.top = Cbytes.byteToShort(text, 8);
        this.left = Cbytes.byteToShort(text, 10);
        this.bottom = Cbytes.byteToShort(text, 12);
        this.right = Cbytes.byteToShort(text, 14);
        int len = Cbytes.strlen(text, 47);
        this.filename = new String(text, 47, len);
        len = Cbytes.strlen(text, 302);
        this.label = new String(text, 302, len);
        this.filename = this.filename.replace(':', '/');
        if (this.filename.charAt(0) != '/') {
            this.filename = new String("/" + this.filename);
        }
    }
}

