/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class OtherMenu
extends JMenu
implements ActionListener {
    ThWindow frame;
    JMenuItem mtreewindow;
    JMenuItem mfontwindow;
    JMenuItem maddlabel;
    JMenuItem mclipwindow;
    JMenuItem mclearforced;
    JMenuItem mvalidate;

    public OtherMenu(ThWindow f) {
        super("Other");
        this.frame = f;
        this.mtreewindow = new JMenuItem("View Tree");
        this.maddlabel = new JMenuItem("Add Label");
        this.mfontwindow = new JMenuItem("View FontList");
        this.mclipwindow = new JMenuItem("View ClipList");
        this.mclearforced = new JMenuItem("Clear Forced");
        this.mvalidate = new JMenuItem("Validate Document");
        this.add(this.mtreewindow);
        this.mtreewindow.addActionListener(this);
        this.add(this.mfontwindow);
        this.mfontwindow.addActionListener(this);
        this.add(this.mclipwindow);
        this.mclipwindow.addActionListener(this);
        this.add(this.maddlabel);
        this.maddlabel.addActionListener(this);
        this.maddlabel.setEnabled(false);
        this.maddlabel.setAccelerator(KeyStroke.getKeyStroke(91, 4));
        this.add(this.mclearforced);
        this.mclearforced.addActionListener(this);
        this.add(this.mvalidate);
        this.mvalidate.addActionListener(this);
    }

    public JMenuItem getMtree() {
        return this.mtreewindow;
    }

    public void actionPerformed(ActionEvent e) {
        Statement st;
        JMenuItem mi = (JMenuItem)e.getSource();
        DocView docview = this.frame.getDocView();
        Doc doc = docview.getDoc();
        if (mi == this.mtreewindow) {
            TreeWindow tw = new TreeWindow(this.frame.getDoc(), docview.getAnchorBlock());
            return;
        }
        if (mi == this.mfontwindow) {
            FontWindow fw = new FontWindow();
            return;
        }
        if (mi == this.mclipwindow) {
            ClipWindow cw = new ClipWindow();
            return;
        }
        if (mi == this.maddlabel && (st = docview.findfocus()).isText()) {
            CharFormat dcf = docview.getDisplayCharFormat();
            ((TextStatement)st).addSelectedLabel(dcf);
            docview.repaint();
        }
        if (mi == this.mclearforced) {
            docview.clearAllForced(doc);
            docview.repaint();
        }
        if (mi == this.mvalidate) {
            ValidateWindow vw = new ValidateWindow();
            docview.flushrelease();
            doc.purgeCaches();
            vw.doValidate(doc);
            doc.purgeCaches();
            docview.repaint();
            return;
        }
    }

    public void updateAddLabel(boolean al) {
        this.maddlabel.setEnabled(al);
    }
}

