/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class PageSetup
extends JDialog
implements ActionListener {
    Options options;
    ThWindow frame;
    JRadioButton bfile;
    JRadioButton bbranch;
    JCheckBox blevels;
    JCheckBox bheaders;
    JCheckBox bfooters;
    JCheckBox bjust;
    JCheckBox blines;
    JButton bOk;
    JButton bCancel;
    JTextField leading;
    JTextField height;
    JTextField width;
    JTextField tm;
    JTextField bm;
    JTextField lm;
    JTextField rm;
    JTextField lefthead;
    JTextField righthead;
    JTextField leftfoot;
    JTextField rightfoot;

    public PageSetup(ThWindow fr, Options o) {
        super(fr, "Page Setup", true);
        this.options = o;
        this.frame = fr;
        JLabel mytitle = new JLabel("Page Setup");
        Container contentPane = this.getContentPane();
        Dimension d = new Dimension(74, 16);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, Color.lightGray));
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new GridLayout(0, 2, 2, 0));
        bigPanel.setBackground(Color.lightGray);
        bigPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, Color.lightGray));
        contentPanel.setBackground(Color.lightGray);
        mytitle.setHorizontalAlignment(0);
        contentPanel.add((Component)mytitle, "North");
        contentPanel.add((Component)bigPanel, "Center");
        contentPane.add(contentPanel);
        this.bfile = new JRadioButton("File");
        this.bfile.setBackground(Color.lightGray);
        this.bbranch = new JRadioButton("Branch");
        this.bbranch.setBackground(Color.lightGray);
        ButtonGroup b1 = new ButtonGroup();
        b1.add(this.bfile);
        b1.add(this.bbranch);
        this.blevels = new JCheckBox("Show Levels");
        this.blevels.setBackground(Color.lightGray);
        this.bheaders = new JCheckBox("Show Headers");
        this.bheaders.setBackground(Color.lightGray);
        this.bfooters = new JCheckBox("Show Footers");
        this.bfooters.setBackground(Color.lightGray);
        this.bjust = new JCheckBox("Justify Text");
        this.bjust.setBackground(Color.lightGray);
        this.blines = new JCheckBox("Head/Foot Lines");
        this.blines.setBackground(Color.lightGray);
        this.bOk = new JButton("Ok");
        this.bOk.addActionListener(this);
        this.bOk.setPreferredSize(d);
        this.bCancel = new JButton("Cancel");
        this.bCancel.setPreferredSize(d);
        this.bCancel.addActionListener(this);
        this.leading = new JTextField(5);
        this.leading.setBorder(new BevelBorder(1));
        this.leading.setBackground(Color.lightGray);
        this.height = new JTextField(5);
        this.height.setBorder(new BevelBorder(1));
        this.height.setBackground(Color.lightGray);
        this.width = new JTextField(5);
        this.width.setBorder(new BevelBorder(1));
        this.width.setBackground(Color.lightGray);
        this.tm = new JTextField(5);
        this.tm.setBorder(new BevelBorder(1));
        this.tm.setBackground(Color.lightGray);
        this.bm = new JTextField(5);
        this.bm.setBorder(new BevelBorder(1));
        this.bm.setBackground(Color.lightGray);
        this.lm = new JTextField(5);
        this.lm.setBorder(new BevelBorder(1));
        this.lm.setBackground(Color.lightGray);
        this.rm = new JTextField(5);
        this.rm.setBorder(new BevelBorder(1));
        this.rm.setBackground(Color.lightGray);
        JLabel lleading = new JLabel("Leading (pts)", 4);
        JLabel lwidth = new JLabel("Width (.01\")", 4);
        JLabel lheight = new JLabel("Height (.01\")", 4);
        JLabel llm = new JLabel("Left Margin (.01\")", 4);
        JLabel lrm = new JLabel("Right Margin (.01\")", 4);
        JLabel ltm = new JLabel("Top Margin (.01\")", 4);
        JLabel lbm = new JLabel("Bottom Margin (.01\")", 4);
        this.lefthead = new JTextField(10);
        this.lefthead.setBorder(new BevelBorder(1));
        this.lefthead.setBackground(Color.lightGray);
        this.righthead = new JTextField(10);
        this.righthead.setBorder(new BevelBorder(1));
        this.righthead.setBackground(Color.lightGray);
        this.leftfoot = new JTextField(10);
        this.leftfoot.setBorder(new BevelBorder(1));
        this.leftfoot.setBackground(Color.lightGray);
        this.rightfoot = new JTextField(10);
        this.rightfoot.setBorder(new BevelBorder(1));
        this.rightfoot.setBackground(Color.lightGray);
        JLabel llefthead = new JLabel("Left Header");
        JLabel lrighthead = new JLabel("Right Header");
        JLabel lleftfoot = new JLabel("Left Footer");
        JLabel lrightfoot = new JLabel("Right Footer");
        JLabel ldummy1 = new JLabel(" ");
        JLabel ldummy2 = new JLabel(" ");
        bigPanel.add(this.bfile);
        bigPanel.add(this.blevels);
        bigPanel.add(this.bbranch);
        bigPanel.add(this.bheaders);
        bigPanel.add(ldummy1);
        bigPanel.add(this.bfooters);
        bigPanel.add(this.blines);
        bigPanel.add(this.bjust);
        bigPanel.add(lheight);
        bigPanel.add(this.height);
        bigPanel.add(lwidth);
        bigPanel.add(this.width);
        bigPanel.add(ltm);
        bigPanel.add(this.tm);
        bigPanel.add(lbm);
        bigPanel.add(this.bm);
        bigPanel.add(llm);
        bigPanel.add(this.lm);
        bigPanel.add(lrm);
        bigPanel.add(this.rm);
        bigPanel.add(lleading);
        bigPanel.add(this.leading);
        bigPanel.add(llefthead);
        bigPanel.add(lrighthead);
        bigPanel.add(this.lefthead);
        bigPanel.add(this.righthead);
        bigPanel.add(lleftfoot);
        bigPanel.add(lrightfoot);
        bigPanel.add(this.leftfoot);
        bigPanel.add(this.rightfoot);
        bigPanel.add(this.bOk);
        bigPanel.add(this.bCancel);
        this.bfile.setSelected(this.options.getPDoFile());
        this.bbranch.setSelected(!this.options.getPDoFile());
        this.bheaders.setSelected(this.options.getPDoHeaders());
        this.bfooters.setSelected(this.options.getPDoFooters());
        this.bjust.setSelected(this.options.getPDoJust());
        this.blines.setSelected(this.options.getPDoLines());
        this.blevels.setSelected(this.options.getPDoLevels());
        this.blevels.setEnabled(false);
        Integer ti = new Integer(this.options.getPLeading());
        this.leading.setText(ti.toString());
        ti = new Integer(this.options.getPHeight());
        this.height.setText(ti.toString());
        ti = new Integer(this.options.getPWidth());
        this.width.setText(ti.toString());
        ti = new Integer(this.options.getPTM());
        this.tm.setText(ti.toString());
        ti = new Integer(this.options.getPBM());
        this.bm.setText(ti.toString());
        ti = new Integer(this.options.getPLM());
        this.lm.setText(ti.toString());
        ti = new Integer(this.options.getPRM());
        this.rm.setText(ti.toString());
        if (this.options.getPLefthead() != null) {
            this.lefthead.setText(this.options.getPLefthead());
        }
        if (this.options.getPLeftfoot() != null) {
            this.leftfoot.setText(this.options.getPLeftfoot());
        }
        if (this.options.getPRighthead() != null) {
            this.righthead.setText(this.options.getPRighthead());
        }
        if (this.options.getPRightfoot() != null) {
            this.rightfoot.setText(this.options.getPRightfoot());
        }
        JRootPane rp = this.getRootPane();
        rp.setDefaultButton(this.bOk);
        this.setResizable(false);
        this.setUndecorated(true);
        this.pack();
        Rectangle frameBounds = this.frame.getBounds();
        Rectangle myBounds = this.getBounds();
        int newx = frameBounds.width > myBounds.width ? frameBounds.x + (frameBounds.width - myBounds.width) / 2 : frameBounds.x + 20;
        int newy = frameBounds.height > myBounds.height ? frameBounds.y + (frameBounds.height - myBounds.height) / 2 : frameBounds.y + 20;
        this.setLocation(newx, newy);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.bOk) {
            Integer ti;
            String ts = this.leading.getText();
            if (ts != null) {
                ti = new Integer(ts);
                this.options.setPLeading(ti.shortValue());
            }
            if ((ts = this.height.getText()) != null) {
                ti = new Integer(ts);
                this.options.setPHeight(ti.shortValue());
            }
            if ((ts = this.width.getText()) != null) {
                ti = new Integer(ts);
                this.options.setPWidth(ti.shortValue());
            }
            if ((ts = this.tm.getText()) != null) {
                ti = new Integer(ts);
                this.options.setPTM(ti.shortValue());
            }
            if ((ts = this.bm.getText()) != null) {
                ti = new Integer(ts);
                this.options.setPBM(ti.shortValue());
            }
            if ((ts = this.lm.getText()) != null) {
                ti = new Integer(ts);
                this.options.setPLM(ti.shortValue());
            }
            if ((ts = this.rm.getText()) != null) {
                ti = new Integer(ts);
                this.options.setPRM(ti.shortValue());
            }
            this.options.setPDoFile(this.bfile.isSelected());
            this.options.setPDoHeaders(this.bheaders.isSelected());
            this.options.setPDoFooters(this.bfooters.isSelected());
            this.options.setPDoLines(this.blines.isSelected());
            this.options.setPDoLevels(this.blevels.isSelected());
            this.options.setPDoJust(this.bjust.isSelected());
            if (this.lefthead.getText() != null) {
                this.options.setPLefthead(this.lefthead.getText());
            }
            if (this.leftfoot.getText() != null) {
                this.options.setPLeftfoot(this.leftfoot.getText());
            }
            if (this.righthead.getText() != null) {
                this.options.setPRighthead(this.righthead.getText());
            }
            if (this.rightfoot.getText() != null) {
                this.options.setPRightfoot(this.rightfoot.getText());
            }
            this.setVisible(false);
            this.dispose();
        }
        if (o == this.bCancel) {
            this.options.cancelPrint(true);
            this.setVisible(false);
            this.dispose();
        }
    }
}

