/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class St2HTML {
    Doc doc;
    OutputStream ostream;
    ThWindow frame;
    int type;
    int level;
    boolean first;
    String Hext;
    File basefile;
    ExportProgress exp;
    private static final int NOTYPE = 0;
    protected static final int PARA = 1;
    private static final int BLOCKQ = 2;
    private static final int UL = 3;
    private static final int OL = 4;
    private static final int H1 = 5;
    private static final int H2 = 6;
    private static final int H3 = 7;
    private static final int H4 = 8;
    private static final int H5 = 9;
    private static final int H6 = 10;
    protected static final int TITLE = 11;
    protected static final int PLEX = 12;
    protected static final int RAWTAG = 13;

    public St2HTML(Doc d, OutputStream os, ThWindow fr, String ext, File file, ExportProgress myexp) {
        this.doc = d;
        this.ostream = os;
        this.type = 0;
        this.frame = fr;
        this.first = false;
        this.Hext = ext;
        this.basefile = file;
        this.exp = myexp;
    }

    public St2HTML(Doc d, OutputStream os, int t, ThWindow fr, String ext, File file, ExportProgress myexp) {
        this.doc = d;
        this.ostream = os;
        this.type = t;
        this.frame = fr;
        this.Hext = ext;
        this.basefile = file;
        this.exp = myexp;
    }

    public St2HTML(Doc d, OutputStream os, ThWindow fr, boolean f, String ext, File file, ExportProgress myexp) {
        this.doc = d;
        this.ostream = os;
        this.frame = fr;
        this.first = f;
        this.Hext = ext;
        this.basefile = file;
        this.exp = myexp;
    }

    public Statement putStatement(Statement st, String endofline, boolean doindent) {
        this.level = st.getLevel();
        if (this.type == 0) {
            this.type = this.classify(st, this.level, 1, doindent);
        }
        while (st != null) {
            String untag = new String("");
            String tag = new String("");
            while (this.frame.getOptions().getPageMode() && st.isPage() && !this.first) {
                if ((st = this.putPage(st, endofline, doindent)) == null) {
                    return st;
                }
                if (st.getLevel() >= this.level) continue;
                return st;
            }
            this.first = false;
            int htype = this.classify(st, this.level, 1, doindent);
            if (htype == 1 && this.type == 2) {
                htype = 2;
            }
            if (htype == 1 && this.type == 12) {
                htype = 12;
            }
            this.putText(st, htype, endofline);
            int clip = this.frame.getDocView().getClipping();
            int block = st.getSuccessor(clip);
            if (block == 0) {
                return null;
            }
            st = this.doc.getStatement(block, this.frame.getOptions());
            if (st == null) {
                return st;
            }
            int lasttype = htype;
            if ((htype = this.classify(st, this.level, htype, doindent)) == 1 && this.type == 2) {
                htype = 2;
            }
            if (st.getLevel() > this.level) {
                tag = new String("");
                if (htype == 2) {
                    tag = new String("<blockquote>" + endofline);
                }
                if (htype == 3) {
                    tag = new String("<UL>" + endofline);
                }
                if (htype == 4) {
                    tag = new String("<OL>" + endofline);
                }
                this.dowrite(tag);
                st = new St2HTML(this.doc, this.ostream, htype, this.frame, this.Hext, this.basefile, this.exp).putStatement(st, endofline, doindent);
                if (st == null) {
                    return st;
                }
                if (st.getLevel() < this.level) {
                    untag = new String("");
                    if (this.type == 2) {
                        untag = new String("</blockquote>" + endofline);
                    }
                    if (this.type == 3) {
                        untag = new String("</UL>" + endofline);
                    }
                    if (this.type == 4) {
                        untag = new String("</OL>" + endofline);
                    }
                    this.dowrite(untag);
                    return st;
                }
            } else if (st.getLevel() < this.level) {
                untag = new String("");
                if (this.type == 2) {
                    untag = new String("</blockquote>" + endofline);
                }
                if (this.type == 3) {
                    untag = new String("</UL>" + endofline);
                }
                if (this.type == 4) {
                    untag = new String("</OL>" + endofline);
                }
                this.dowrite(untag);
                return st;
            }
            if (this.type == 1 || this.type >= 5 && this.type <= 10) {
                return st;
            }
            if (st != null) continue;
            return st;
        }
        return st;
    }

    protected Statement putPage(Statement st, String endofline, boolean doindent) {
        FileOutputStream fos;
        String parent = this.basefile.getParent();
        String head = "<HTML>" + endofline + "<HEAD>" + endofline + "<TITLE>";
        String tail = "</TITLE></HEAD><BODY>";
        String filename = parent + "/" + st.getDoc().getFilename() + "_" + st.getDoc().whatsMyLevel(st.getStatementBlock(), "_") + this.Hext;
        try {
            fos = new FileOutputStream(filename);
        }
        catch (IOException ioe) {
            return st;
        }
        St2HTML st2HTML = new St2HTML(this.doc, (OutputStream)fos, this.frame, true, this.Hext, this.basefile, this.exp);
        byte[] buf = st.getBytes();
        String title = new String(buf, ((TextStatement)st).getFirstChar(), st.getLength() - ((TextStatement)st).getFirstChar());
        st2HTML.dowrite(head + title + tail + endofline);
        st = st2HTML.putStatement(st, endofline, doindent);
        st2HTML.dowrite("</BODY></HTML>" + endofline);
        try {
            fos.flush();
            ((OutputStream)fos).close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        fos = null;
        st2HTML = null;
        return st;
    }

    protected void dowrite(String str) {
        try {
            this.ostream.write(str.getBytes(), 0, str.length());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.exp.updmessage(str);
    }

    protected int classify(Statement st, int level, int type, boolean doindent) {
        byte[] buf;
        int i;
        int len = st.getLength();
        boolean allbold = true;
        String strbullet = "\u2022";
        byte[] bytebullet = strbullet.getBytes();
        if (st.isImage()) {
            if (st.getLevel() > level) {
                if (type >= 5 && type <= 10) {
                    return 12;
                }
                return 2;
            }
            return 1;
        }
        for (i = 0; i < len; ++i) {
            CharFormat cf = st.getCharFormat(i);
            if ((cf.getStyle() & 2) == 2) continue;
            allbold = false;
            break;
        }
        if (allbold && !doindent) {
            if (st.isCenter()) {
                return 11;
            }
            if (st.getLevel() == 0) {
                return 5;
            }
            if (st.getLevel() == 1) {
                return 6;
            }
            if (st.getLevel() == 2) {
                return 7;
            }
            if (st.getLevel() == 3) {
                return 8;
            }
            if (st.getLevel() == 4) {
                return 9;
            }
            if (st.getLevel() == 5) {
                return 10;
            }
        }
        if ((buf = st.getBytes())[0] == bytebullet[0] && buf[1] == 32) {
            return 3;
        }
        if (buf[0] == 42 && buf[1] == 32) {
            return 3;
        }
        if (buf[0] == 91 && buf[1] == 60) {
            return 13;
        }
        if (Cbytes.isNumber(buf[0])) {
            for (i = 1; i < buf.length; ++i) {
                if (Cbytes.isNumber(buf[i]) || (i >= buf.length || buf[i] != 41) && (i >= buf.length || buf[i] != 46) || i + 1 >= buf.length || buf[i + 1] != 32) continue;
                return 4;
            }
        }
        if (st.getLevel() > level) {
            if (type >= 5 && type <= 10) {
                return 12;
            }
            return 2;
        }
        return 1;
    }

    private void putText(Statement st, int type, String endofline) {
        int length;
        byte[] buf;
        String tag = new String("");
        String untag = new String("");
        if (type == 1 || type == 2 || type == 12) {
            tag = new String("<p>");
            untag = new String("</p>" + endofline);
        } else if (type == 3 || type == 4) {
            tag = new String("<LI>");
            untag = new String(endofline);
        } else if (type == 5) {
            tag = new String("<H1>");
            untag = new String("</H1>" + endofline);
        } else if (type == 6) {
            tag = new String("<H2>");
            untag = new String("</H2>" + endofline);
        } else if (type == 7) {
            tag = new String("<H3>");
            untag = new String("</H3>" + endofline);
        } else if (type == 8) {
            tag = new String("<H4>");
            untag = new String("</H4>" + endofline);
        } else if (type == 9) {
            tag = new String("<H5>");
            untag = new String("</H5>" + endofline);
        } else if (type == 10) {
            tag = new String("<H6>");
            untag = new String("</H6>" + endofline);
        }
        if (st.isText()) {
            buf = st.getBytes();
            length = Cbytes.strlen(buf, 0);
            String text = new String(buf, 0, length);
            text = this.translate(st, type);
            this.exp.updmessage(text);
            buf = text.getBytes();
            length = buf.length;
        } else {
            tag = "";
            untag = " ";
            buf = this.translateImage(st).getBytes();
            length = buf.length;
        }
        try {
            this.ostream.write(tag.getBytes(), 0, tag.length());
            this.ostream.write(buf, 0, length);
            this.ostream.write(untag.getBytes(), 0, untag.length());
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private String translateImage(Statement st) {
        Doc d = st.getDoc();
        String filename = d.getFilename();
        int block = st.getBlockNumber();
        String imagename = new String(filename + "-" + block + ".img");
        if (((ImageStatement)st).isGIF()) {
            imagename = new String(filename + "-" + block + ".gif");
        } else if (((ImageStatement)st).isJPG()) {
            imagename = new String(filename + "-" + block + ".jpg");
        } else {
            return "";
        }
        String home = d.getHome();
        String homegraphics = new String(home + "/graphics");
        File graphicsfile = new File(homegraphics);
        if (!graphicsfile.exists()) {
            graphicsfile.mkdir();
        }
        imagename = new String(homegraphics + "/" + imagename);
        byte[] buf = st.getBytes();
        try {
            FileOutputStream fos = new FileOutputStream(imagename);
            fos.write(buf, 0, st.getLength());
            fos.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return new String("<img src=\"" + imagename + "\">");
    }

    private String translate(Statement st, int type) {
        String out;
        int i;
        byte[] buf = st.getBytes();
        int length = Cbytes.strlen(buf, 0);
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        String text = new String(buf, 0, length);
        StringBuffer outb = new StringBuffer(8192);
        String sprefix = new String("");
        String ssuffix = new String("");
        boolean firstul = false;
        boolean lastul = false;
        int index = 0;
        buf = text.getBytes();
        if (((TextStatement)st).isLabels()) {
            String labels = ((TextStatement)st).getLabelString();
            index = ((TextStatement)st).getFirstChar();
            i = labels.indexOf(44);
            if (i >= 0) {
                labels = labels.substring(0, i);
            }
            if (labels.length() > 0) {
                sprefix = new String("<a name=\"" + labels + "\">");
                ssuffix = new String("</a>");
            }
        }
        for (i = index; i < buf.length; ++i) {
            CharFormat cf = st.getCharFormat(i);
            byte style = cf.getStyle();
            if (style != 0 || bold || italic || underline) {
                if ((style & 2) == 2) {
                    if (!(bold || type >= 5 && type <= 10)) {
                        bold = true;
                        outb.append("<B>");
                    }
                } else if (bold) {
                    bold = false;
                    outb.append("</B>");
                }
                if ((style & 4) == 4) {
                    if (!italic) {
                        italic = true;
                        outb.append("<I>");
                    }
                } else if (italic) {
                    italic = false;
                    outb.append("</I");
                }
                if ((style & 1) == 1) {
                    if (!underline) {
                        underline = true;
                        outb.append("<U>");
                    }
                } else if (underline) {
                    underline = false;
                    outb.append("</U>");
                }
            }
            if (buf[i] == 60) {
                int j;
                for (j = i + 1; j < buf.length && buf[j] != 62; ++j) {
                }
                if (j < buf.length) {
                    LabelString ls = new LabelString(new String(buf, i, j - i + 1), this.frame.getOptions(), st.getVDoc());
                    out = outb.toString();
                    if (out.endsWith("</U>") || out.endsWith("</U> ")) {
                        int lasti = out.lastIndexOf("<U>");
                        out = out.substring(0, lasti);
                        outb = new StringBuffer(8192);
                        outb.append(out);
                    }
                    outb.append(this.linkFromLs(ls, st, i));
                    i = j;
                    continue;
                }
                outb.append(new String(buf, i, 1));
                continue;
            }
            if (buf[i] == 91 && buf[i + 1] == 60) {
                outb.append(new String(buf, ++i, 1));
                continue;
            }
            if (buf[i] == 93 && i > 0 && buf[i - 1] == 62) continue;
            if (buf[i] == 10 || buf[i] == 13) {
                outb.append("<BR>\n");
                continue;
            }
            outb.append((char)buf[i]);
        }
        if (bold) {
            outb.append("</B>");
        }
        if (italic) {
            outb.append("</I>");
        }
        if (underline) {
            outb.append("</U>");
        }
        if (type == 3 || type == 4) {
            out = outb.toString();
            i = out.indexOf(32);
            out = out.substring(i + 1);
            outb = new StringBuffer(8192);
            outb.append(out);
        }
        out = ((TextStatement)st).isCenter() ? sprefix + "<CENTER>" + outb.toString() + "</CENTER>" + ssuffix : sprefix + outb.toString() + ssuffix;
        return out;
    }

    private String linkFromLs(LabelString ls, Statement st, int i) {
        CharFormat cf;
        byte[] buf;
        String file = ls.getFilename();
        String label = ls.getLabel();
        String extension = ls.getExtension();
        boolean undervisual = false;
        String link = new String("");
        String visual = new String("");
        if (file == null && label == null) {
            return "<>";
        }
        if (i > 0 && (buf = st.getBytes())[i - 1] == 32) {
            --i;
        }
        if (i > 0 && ((cf = st.getCharFormat(i - 1)).getStyle() & 1) == 1) {
            int j;
            for (j = i - 1; j >= 0 && ((cf = st.getCharFormat(j)).getStyle() & 1) == 1; --j) {
            }
            buf = st.getBytes();
            visual = new String(buf, ++j, i - j);
            undervisual = true;
        }
        if (file == null) {
            DocLink dl;
            Doc doc;
            String pagefile = "";
            if (this.frame.getOptions().getPageMode() && (doc = (dl = new DocLink(this.frame, ls, 0, 0)).getDocument()) != null) {
                StatementBlock lsb = doc.getStatementBlock(dl.getBlock());
                StatementBlock psb = doc.whatsMyPage(lsb);
                if (doc.whatsMyPage(st.getStatementBlock()) != psb && psb != null) {
                    pagefile = new String(doc.getFilename() + "_" + doc.whatsMyLevel(psb, "_") + this.Hext);
                }
            }
            if (!undervisual) {
                visual = new String(label);
            }
            link = label.indexOf("http:") == 0 || label.indexOf("ftp:") == 0 || label.indexOf("https:") == 0 || label.indexOf("mailto:") == 0 ? new String("<a HREF=\"" + label + "\">" + visual + "</a>") : new String("<a HREF=\"" + pagefile + "#" + label + "\">" + visual + "</a>");
        } else if (label == null) {
            if (!undervisual) {
                visual = new String(file);
            }
            if (file.indexOf("http:") == 0 || file.indexOf("ftp:") == 0 || file.indexOf("https:") == 0 || file.indexOf("mailto:") == 0) {
                link = new String("<a HREF=\"" + file + "\">" + visual + "</a>");
            } else {
                extension = extension == null ? this.Hext : (extension.compareToIgnoreCase("tkr") == 0 ? this.Hext : "." + extension);
                link = new String("<a HREF=\"" + file + extension + "\">" + visual + "</a>");
            }
        } else {
            if (!undervisual) {
                visual = new String(file + "," + label);
            }
            link = new String("<a HREF=\"" + file + this.Hext + "#" + label + "\">" + visual + "</a>");
        }
        return link;
    }
}

