/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;

class StatementBlock {
    private static final int PAGEHEAD = 2;
    private static final int V2 = 4;
    private static final int IFV2ISTABLE = 8;
    private static final int ENCRYPTED = 16;
    private static final int STFONT = 32;
    public static final int IMAGE = 64;
    public static final int UNUSED = 128;
    public static final int FMTHEADFOOT = 2;
    public static final int FMTEVEN = 4;
    public static final int FMTODD = 8;
    public static final int FMTNOHEADERS = 16;
    public static final int FMTNOLEVELS = 32;
    public static final int FMTRIGHT = 64;
    public static final int FMTCENTER = 128;
    public static final int STMTMAX = 96;
    public static final int V2STMAX = 80;
    private static final int nextOffset = 0;
    private static final int prevOffset = 4;
    private static final int upOffset = 8;
    private static final int downOffset = 12;
    public static final int chainOffset = 16;
    private static final int lengthOffset = 20;
    private static final int levelOffset = 22;
    public static final int flagsOffset = 23;
    private static final int timeOffset = 24;
    private static final int styleOffset = 28;
    private static final int dataOffset = 32;
    private static final int v2eyeOffset = 32;
    private static final int v2fmtOffset = 36;
    private static final int v2needOffset = 37;
    private static final int v2indentOffset = 38;
    private static final int v2idOffset = 39;
    private static final int v2rindentOffset = 43;
    private static final int v2elenOffset = 44;
    private static final int v2nstatementsOffset = 46;
    private static final int v2dataOffset = 48;
    Doc doc;
    int block;
    int next;
    int prev;
    int up;
    int down;
    int chain;
    int length;
    int level;
    int time;
    int headfoot;
    int flags;
    int v2fmt;
    int v2need;
    int v2indent;
    String v2id;
    int v2rindent;
    int v2elen;
    int v2nstatements;
    boolean dirty;
    byte[] data;
    byte[] v2data;

    public StatementBlock(Doc d, int blocknumber) {
        this.doc = d;
        this.block = blocknumber;
        byte[] buf = new byte[128];
        d.getBlock(buf, 0, blocknumber);
        this.next = Cbytes.byteToInt(buf, 0);
        this.prev = Cbytes.byteToInt(buf, 4);
        this.up = Cbytes.byteToInt(buf, 8);
        this.down = Cbytes.byteToInt(buf, 12);
        this.chain = Cbytes.byteToInt(buf, 16);
        this.length = Cbytes.byteToShort(buf, 20);
        this.level = buf[22];
        this.flags = buf[23];
        this.time = Cbytes.byteToInt(buf, 24);
        this.headfoot = Cbytes.byteToInt(buf, 28);
        if ((this.flags & 4) == 0) {
            this.data = new byte[96];
            for (int i = 0; i < 96; ++i) {
                this.data[i] = buf[32 + i];
            }
        } else {
            this.v2fmt = Cbytes.charToShort(buf[36]);
            this.v2need = Cbytes.charToShort(buf[37]);
            this.v2indent = Cbytes.charToShort(buf[38]);
            this.v2id = new String(buf, 39, 4);
            this.v2rindent = Cbytes.charToShort(buf[43]);
            this.v2elen = Cbytes.byteToShort(buf, 44);
            this.v2nstatements = Cbytes.byteToShort(buf, 46);
            this.v2data = new byte[80];
            for (int i = 0; i < 80; ++i) {
                this.v2data[i] = buf[48 + i];
            }
        }
        this.dirty = false;
    }

    public StatementBlock(int blk) {
        this.block = blk;
        this.flags = 4;
        this.v2data = new byte[80];
        this.next = 0;
        this.prev = 0;
        this.up = 0;
        this.down = 0;
        this.chain = 0;
        this.length = 0;
        this.level = 0;
        this.time = 0;
        this.headfoot = 0;
        this.v2fmt = 0;
        this.v2need = 0;
        this.v2indent = 0;
        this.v2id = new String("UNK ");
        this.v2nstatements = 0;
        this.dirty = false;
        String copyright = "Thinker 2.2, Copyright \u00a9 1992, Poor Person Software";
        this.length = copyright.length();
        byte[] buf = copyright.getBytes();
        for (int i = 0; i < this.length; ++i) {
            this.v2data[i] = buf[i];
        }
    }

    public StatementBlock(Doc d) {
        this.doc = d;
        this.block = this.doc.allocateBlock();
        this.flags = 4;
        this.v2data = new byte[80];
        this.next = 0;
        this.prev = 0;
        this.up = 0;
        this.down = 0;
        this.chain = 0;
        this.length = 0;
        this.level = 0;
        this.time = 0;
        this.headfoot = 0;
        this.v2fmt = 0;
        this.v2need = 0;
        this.v2indent = 0;
        this.v2id = new String("UNK ");
        this.v2nstatements = 0;
        this.dirty = false;
        this.putBlock();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int getBlockNumber() {
        return this.block;
    }

    public int getNext() {
        return this.next;
    }

    public void putNext(int newnext) {
        this.next = newnext;
        this.dirty = true;
    }

    public int getDown() {
        return this.down;
    }

    public void putDown(int newdown) {
        this.down = newdown;
        this.dirty = true;
    }

    public int getUp() {
        return this.up;
    }

    public void putUp(int newup) {
        this.up = newup;
        this.dirty = true;
    }

    public int getPrev() {
        return this.prev;
    }

    public void putPrev(int newprev) {
        this.prev = newprev;
        this.dirty = true;
    }

    public int getChain() {
        return this.chain;
    }

    public void putChain(int newchain) {
        this.chain = newchain;
        this.dirty = true;
    }

    public int getLength() {
        return this.length;
    }

    public void putLength(int newlength) {
        this.length = newlength;
        this.dirty = true;
    }

    public int getLevel() {
        return this.level;
    }

    public void putLevel(int newlevel) {
        this.level = newlevel;
        this.dirty = true;
    }

    public int getHeadFoot() {
        return this.headfoot;
    }

    public void putHeadFoot(int newheadfoot) {
        this.headfoot = newheadfoot;
        this.dirty = true;
    }

    public int getV2Nstatements() {
        return this.v2nstatements;
    }

    public void putV2Nstatements(int newns) {
        this.v2nstatements = newns;
        this.dirty = true;
    }

    public long getTime() {
        long t = this.time;
        if (t < 0L) {
            t += 0x100000000L;
        }
        if (t != 0L) {
            t = t - 2208988800L + 25200L;
            t *= 1000L;
        }
        return t;
    }

    public void setTime() {
        Date date = new Date();
        long t = date.getTime();
        t /= 1000L;
        t = t + 2208988800L - 25200L;
        this.time = (int)t;
        t = 0L;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public int getV2Fmt() {
        return this.v2fmt;
    }

    public void putV2Fmt(int newv2fmt) {
        this.v2fmt = newv2fmt;
        this.dirty = true;
    }

    public int getV2Need() {
        return this.v2need;
    }

    public void putV2Need(int newv2need) {
        this.v2need = newv2need;
        this.dirty = true;
    }

    public int getV2Indent() {
        return this.v2indent;
    }

    public void putV2Indent(int newv2indent) {
        this.v2indent = newv2indent;
        this.dirty = true;
    }

    public int getV2Rindent() {
        return this.v2rindent;
    }

    public void putV2Rindent(int newv2rindent) {
        this.v2rindent = newv2rindent;
        this.dirty = true;
    }

    public String getV2Id() {
        return this.v2id;
    }

    public void putV2Id(String vi) {
        this.v2id = vi;
        this.dirty = true;
    }

    public boolean isNoLevels() {
        return (this.v2fmt & 0x20) == 32;
    }

    public boolean isNoHeaders() {
        return (this.v2fmt & 0x10) == 16;
    }

    public boolean isCenter() {
        return (this.v2fmt & 0x80) == 128;
    }

    public boolean isRight() {
        return (this.v2fmt & 0x40) == 64;
    }

    public boolean isEven() {
        return (this.v2fmt & 4) == 4;
    }

    public boolean isOdd() {
        return (this.v2fmt & 8) == 8;
    }

    public void setNoLevels(boolean b) {
        this.v2fmt &= 0xFFFFFFDF;
        if (b) {
            this.v2fmt |= 0x20;
        }
    }

    public void setNoHeaders(boolean b) {
        this.v2fmt &= 0xFFFFFFEF;
        if (b) {
            this.v2fmt |= 0x10;
        }
    }

    public void setCenter(boolean b) {
        this.v2fmt &= 0xFFFFFF7F;
        if (b) {
            this.v2fmt |= 0x80;
        }
    }

    public void setRight(boolean b) {
        this.v2fmt &= 0xFFFFFFBF;
        if (b) {
            this.v2fmt |= 0x40;
        }
    }

    public void setEven(boolean b) {
        this.v2fmt &= 0xFFFFFFFB;
        if (b) {
            this.v2fmt |= 4;
        }
    }

    public void setOdd(boolean b) {
        this.v2fmt &= 0xFFFFFFF7;
        if (b) {
            this.v2fmt |= 8;
        }
    }

    public void getV2Data(byte[] b, int offset, int length) {
        if (length > 80) {
            length = 80;
        }
        for (int i = 0; i < length; ++i) {
            b[offset + i] = this.v2data[i];
        }
    }

    public int putV2Data(byte[] b, int offset, int length) {
        int len = length;
        if (len > 80) {
            len = 80;
        }
        for (int i = 0; i < len; ++i) {
            this.v2data[i] = b[offset + i];
        }
        this.dirty = true;
        return len;
    }

    public boolean isText() {
        return (this.flags & 0x40) == 0;
    }

    public boolean isImage() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isUnused() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isPage() {
        return (this.flags & 2) != 0;
    }

    public void setPage(boolean sp) {
        this.flags = sp ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        this.dirty = true;
    }

    public void setImage(boolean isimage) {
        this.flags = isimage ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
        this.dirty = true;
    }

    public void putBlock() {
        int i;
        byte[] buf = new byte[128];
        short t = (short)this.length;
        byte[] v2eye = new String("!V2").getBytes();
        this.flags |= 4;
        Cbytes.intToByte(this.next, buf, 0);
        Cbytes.intToByte(this.prev, buf, 4);
        Cbytes.intToByte(this.up, buf, 8);
        Cbytes.intToByte(this.down, buf, 12);
        Cbytes.intToByte(this.chain, buf, 16);
        Cbytes.shortToByte(t, buf, 20);
        buf[22] = (byte)this.level;
        buf[23] = (byte)this.flags;
        Cbytes.intToByte(this.time, buf, 24);
        Cbytes.intToByte(this.headfoot, buf, 28);
        for (i = 0; i < 3; ++i) {
            buf[32 + i] = v2eye[i];
        }
        buf[35] = 0;
        buf[36] = (byte)this.v2fmt;
        buf[37] = (byte)this.v2need;
        buf[38] = (byte)this.v2indent;
        byte[] tb = this.v2id.getBytes();
        for (i = 0; i < 3; ++i) {
            buf[39 + i] = tb[i];
        }
        buf[42] = 0;
        buf[this.v2rindent] = (byte)this.v2rindent;
        t = (short)this.v2nstatements;
        Cbytes.shortToByte(t, buf, 46);
        for (i = 0; i < 80; ++i) {
            buf[48 + i] = this.v2data[i];
        }
        this.doc.putBlock(buf, 0, this.block, false);
        this.dirty = false;
    }

    public void putBlock(RandomAccessFile raf) throws IOException {
        int i;
        byte[] buf = new byte[128];
        short t = (short)this.length;
        byte[] v2eye = new String("!V2").getBytes();
        this.flags |= 4;
        Cbytes.intToByte(this.next, buf, 0);
        Cbytes.intToByte(this.prev, buf, 4);
        Cbytes.intToByte(this.up, buf, 8);
        Cbytes.intToByte(this.down, buf, 12);
        Cbytes.intToByte(this.chain, buf, 16);
        Cbytes.shortToByte(t, buf, 20);
        buf[22] = (byte)this.level;
        buf[23] = (byte)this.flags;
        Cbytes.intToByte(this.time, buf, 24);
        Cbytes.intToByte(this.headfoot, buf, 28);
        for (i = 0; i < 3; ++i) {
            buf[32 + i] = v2eye[i];
        }
        buf[35] = 0;
        buf[36] = (byte)this.v2fmt;
        buf[37] = (byte)this.v2need;
        buf[38] = (byte)this.v2indent;
        byte[] tb = this.v2id.getBytes();
        for (i = 0; i < 3; ++i) {
            buf[39 + i] = tb[i];
        }
        buf[42] = 0;
        buf[this.v2rindent] = (byte)this.v2rindent;
        t = (short)this.v2nstatements;
        Cbytes.shortToByte(t, buf, 46);
        for (i = 0; i < 80; ++i) {
            buf[48 + i] = this.v2data[i];
        }
        raf.seek(this.block * 128);
        raf.write(buf, 0, 128);
    }

    public int removeBranch() {
        StatementBlock tempblock;
        if (this.prev == 0 && this.up == 0) {
            if (this.next == 0) {
                return 0;
            }
            this.doc.setFirstBlock(this.next);
        }
        if (this.next != 0) {
            tempblock = this.doc.getStatementBlock(this.next);
            tempblock.putPrev(this.prev);
            tempblock.putBlock();
        }
        if (this.prev != 0) {
            tempblock = this.doc.getStatementBlock(this.prev);
            tempblock.putNext(this.next);
            tempblock.putBlock();
        }
        if (this.prev == 0 && this.up != 0) {
            tempblock = this.doc.getStatementBlock(this.up);
            tempblock.putDown(this.next);
            tempblock.putBlock();
        }
        this.next = 0;
        int upblk = this.up;
        this.up = 0;
        this.prev = 0;
        this.putBlock();
        if (this.doc.getNStatements() != 0) {
            int nstatements = this.getV2Nstatements();
            while (upblk != 0) {
                tempblock = this.doc.getStatementBlock(upblk);
                tempblock.putV2Nstatements(tempblock.getV2Nstatements() - 1 - nstatements);
                tempblock.putBlock();
                upblk = tempblock.getUp();
            }
            this.doc.setNStatements(this.doc.getNStatements() - 1 - nstatements);
        }
        return this.block;
    }

    public int insertBranch(StatementBlock newblock, int level, int revertblk) {
        StatementBlock tempblock;
        int tblk;
        int blk = newblock.getBlockNumber();
        StatementBlock oldblock = this;
        if (this.doc != newblock.getDoc()) {
            return 0;
        }
        int here = oldblock.getBlockNumber();
        int newlevel = newblock.getLevel();
        int oldlevel = newblock.getLevel();
        if (this.doc.getRevertBlk() == 0 && revertblk != 0) {
            this.doc.setRevertBlk(revertblk);
        }
        if (blk == here) {
            here = 0;
        }
        if (here == 0) {
            this.newOrigin(newblock.getBlockNumber(), revertblk);
            return newblock.getBlockNumber();
        }
        if (level < 0) {
            here = oldblock.getUp();
            if (here == 0) {
                this.newOrigin(blk, revertblk);
                return blk;
            }
            level = 0;
            oldblock = this.doc.getStatementBlock(here);
        }
        if (level != 0) {
            newblock.putUp(here);
            newblock.putLevel(oldblock.getLevel() + 1);
            newlevel = oldblock.getLevel() + 1;
            newblock.putNext(oldblock.getDown());
            oldblock.putDown(blk);
            oldblock.putBlock();
            tblk = newblock.getNext();
            newblock.putBlock();
            if (tblk != 0) {
                tempblock = this.doc.getStatementBlock(tblk);
                tempblock.putPrev(blk);
                tempblock.putBlock();
            }
        } else {
            newblock.putPrev(here);
            newblock.putNext(oldblock.getNext());
            newblock.putUp(oldblock.getUp());
            newblock.putLevel(oldblock.getLevel());
            newlevel = newblock.getLevel();
            oldblock.putNext(blk);
            oldblock.putBlock();
            newblock.putBlock();
            tblk = newblock.getNext();
            if (tblk != 0) {
                tempblock = this.doc.getStatementBlock(tblk);
                tempblock.putPrev(blk);
                tempblock.putBlock();
            }
        }
        if (newlevel != oldlevel) {
            this.setlevel(blk, newlevel);
        }
        oldblock.putBlock();
        if (this.doc.getNStatements() != 0) {
            int nstatements = newblock.getV2Nstatements();
            tblk = newblock.getUp();
            while (tblk != 0) {
                tempblock = this.doc.getStatementBlock(tblk);
                tempblock.putV2Nstatements(tempblock.getV2Nstatements() + 1 + nstatements);
                tempblock.putBlock();
                tblk = tempblock.getUp();
            }
            this.doc.setNStatements(this.doc.getNStatements() + 1 + nstatements);
        }
        return newblock.getBlockNumber();
    }

    private void newOrigin(int blk, int revertblk) {
        int oldblock = this.doc.getFirstBlock();
        if (this.doc.getRevertBlk() == 0) {
            this.doc.setRevertBlk(revertblk);
        }
        StatementBlock newblock = this.doc.getStatementBlock(blk);
        StatementBlock origin = this.doc.getStatementBlock(oldblock);
        int newlevel = newblock.getLevel();
        newblock.putLevel(0);
        newblock.putNext(origin.getBlockNumber());
        newblock.putPrev(0);
        newblock.putUp(0);
        origin.putPrev(blk);
        this.doc.setFirstBlock(blk);
        if (this.doc.getNStatements() != 0) {
            this.doc.setNStatements(this.doc.getNStatements() + 1 + newblock.getV2Nstatements());
        }
        origin.putBlock();
        newblock.putBlock();
        if (newlevel != 0) {
            this.setlevel(blk, 0);
        }
    }

    private void setlevel(int branch, int level) {
        StatementBlock sb = this.doc.getStatementBlock(branch);
        sb.putLevel(level);
        sb.putBlock();
        int tblk = sb.getDown();
        while (tblk != 0) {
            this.setlevel(tblk, level + 1);
            sb = this.doc.getStatementBlock(tblk);
            tblk = sb.getNext();
        }
    }
}

