/*
 * Decompiled with CFR 0.152.
 */
final class StatementFactory {
    StatementFactory() {
    }

    public static Statement make(Doc d, int anchor, Options opts) {
        StatementBlock sb = d.getStatementBlock(anchor);
        if (sb.isText()) {
            return new TextStatement(d, anchor, opts);
        }
        if (sb.isImage()) {
            return new ImageStatement(d, anchor, opts);
        }
        return null;
    }

    public static Statement make(Doc d, Options opts, boolean isimage) {
        StatementBlock sb = d.getStatementBlock();
        int block = sb.getBlockNumber();
        if (isimage) {
            return new ImageStatement(d, block, opts);
        }
        return new TextStatement(d, block, opts);
    }

    public static Statement make(Doc d, int anchor) {
        return new TextStatement(d, anchor);
    }

    public static Statement make(Doc d) {
        return new TextStatement(d, d.getStatementBlock().getBlockNumber());
    }
}

