/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class StatementStyles
extends JDialog
implements ActionListener {
    StatementOptions statementOptions;
    ThWindow frame;
    JRadioButton bCenter;
    JRadioButton bRight;
    JRadioButton bLeft;
    JRadioButton bOdd;
    JRadioButton bEven;
    JRadioButton bNone;
    JCheckBox bNoLevels;
    JCheckBox bNoHeaders;
    JButton bOk;
    JButton bCancel;
    JTextField needlines;
    JTextField indent;
    JTextField rindent;
    JTextField lefthead;
    JTextField leftfoot;
    JTextField righthead;
    JTextField rightfoot;

    public StatementStyles(ThWindow fr, StatementOptions so, String title) {
        super(fr, "Statement Styles", true);
        this.statementOptions = so;
        this.frame = fr;
        Dimension d = new Dimension(74, 16);
        Container contentPane = this.getContentPane();
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, Color.lightGray));
        outerPanel.setLayout(new BorderLayout());
        outerPanel.setBackground(Color.lightGray);
        JLabel mytitle = new JLabel(title, 0);
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new GridLayout(0, 2, 2, 0));
        bigPanel.setBackground(Color.lightGray);
        bigPanel.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, Color.lightGray));
        contentPane.add(outerPanel);
        outerPanel.add((Component)mytitle, "North");
        outerPanel.add((Component)bigPanel, "Center");
        this.bCenter = new JRadioButton("Center");
        this.bCenter.setBackground(Color.lightGray);
        this.bRight = new JRadioButton("Right");
        this.bRight.setBackground(Color.lightGray);
        this.bLeft = new JRadioButton("Left");
        this.bLeft.setBackground(Color.lightGray);
        this.bOdd = new JRadioButton("Force Odd");
        this.bOdd.setBackground(Color.lightGray);
        this.bEven = new JRadioButton("Force Even");
        this.bEven.setBackground(Color.lightGray);
        this.bNone = new JRadioButton("None");
        this.bNone.setBackground(Color.lightGray);
        this.bNoLevels = new JCheckBox("No Levels");
        this.bNoLevels.setBackground(Color.lightGray);
        this.bNoHeaders = new JCheckBox("No Headers");
        this.bNoHeaders.setBackground(Color.lightGray);
        ButtonGroup b1 = new ButtonGroup();
        ButtonGroup b2 = new ButtonGroup();
        JLabel lindent = new JLabel("Indent (.1\")", 4);
        JLabel lrindent = new JLabel("Right Indent (.1\")", 4);
        JLabel lneedlines = new JLabel("Need Lines", 4);
        JLabel llefthead = new JLabel("Left Header");
        JLabel lrighthead = new JLabel("Right Header");
        JLabel lleftfoot = new JLabel("Left Footer");
        JLabel lrightfoot = new JLabel("Right Footer");
        this.bOk = new JButton("Ok");
        this.bOk.setPreferredSize(d);
        this.bOk.addActionListener(this);
        this.bOk.setBackground(Color.lightGray);
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        this.bCancel.setPreferredSize(d);
        this.bCancel.setBackground(Color.lightGray);
        this.needlines = new JTextField(5);
        this.needlines.setBorder(new BevelBorder(1));
        this.needlines.setBackground(Color.lightGray);
        this.indent = new JTextField(5);
        this.indent.setBorder(new BevelBorder(1));
        this.indent.setBackground(Color.lightGray);
        this.rindent = new JTextField(5);
        this.rindent.setBorder(new BevelBorder(1));
        this.rindent.setBackground(Color.lightGray);
        this.lefthead = new JTextField(10);
        this.lefthead.setBorder(new BevelBorder(1));
        this.lefthead.setBackground(Color.lightGray);
        this.lefthead.setPreferredSize(d);
        this.righthead = new JTextField(10);
        this.righthead.setBorder(new BevelBorder(1));
        this.righthead.setBackground(Color.lightGray);
        this.righthead.setPreferredSize(d);
        this.leftfoot = new JTextField(10);
        this.leftfoot.setBorder(new BevelBorder(1));
        this.leftfoot.setBackground(Color.lightGray);
        this.leftfoot.setPreferredSize(d);
        this.rightfoot = new JTextField(10);
        this.rightfoot.setBorder(new BevelBorder(1));
        this.rightfoot.setBackground(Color.lightGray);
        this.rightfoot.setPreferredSize(d);
        bigPanel.add(this.bCenter);
        bigPanel.add(this.bOdd);
        bigPanel.add(this.bRight);
        bigPanel.add(this.bEven);
        bigPanel.add(this.bLeft);
        bigPanel.add(this.bNone);
        bigPanel.add(this.bNoHeaders);
        bigPanel.add(this.bNoLevels);
        bigPanel.add(lindent);
        bigPanel.add(this.indent);
        bigPanel.add(lrindent);
        bigPanel.add(this.rindent);
        bigPanel.add(lneedlines);
        bigPanel.add(this.needlines);
        bigPanel.add(llefthead);
        bigPanel.add(lrighthead);
        bigPanel.add(this.lefthead);
        bigPanel.add(this.righthead);
        bigPanel.add(lleftfoot);
        bigPanel.add(lrightfoot);
        bigPanel.add(this.leftfoot);
        bigPanel.add(this.rightfoot);
        bigPanel.add(this.bOk);
        bigPanel.add(this.bCancel);
        this.bCenter.setSelected(this.statementOptions.isCenter());
        this.bRight.setSelected(this.statementOptions.isRight());
        this.bLeft.setSelected(!this.statementOptions.isRight() && !this.statementOptions.isCenter());
        this.bOdd.setSelected(this.statementOptions.isOdd());
        this.bEven.setSelected(this.statementOptions.isEven());
        this.bNone.setSelected(!this.statementOptions.isOdd() && !this.statementOptions.isEven());
        b1.add(this.bCenter);
        b1.add(this.bRight);
        b1.add(this.bLeft);
        b2.add(this.bOdd);
        b2.add(this.bEven);
        b2.add(this.bNone);
        this.bNoLevels.setSelected(this.statementOptions.isNoLevels());
        this.bNoHeaders.setSelected(this.statementOptions.isNoHeaders());
        Integer i = new Integer(this.statementOptions.getNeed());
        if (i != 0) {
            this.needlines.setText(i.toString());
        }
        if ((i = new Integer(this.statementOptions.getIndent())) != 0) {
            this.indent.setText(i.toString());
        }
        if ((i = new Integer(this.statementOptions.getRindent())) != 0) {
            this.rindent.setText(i.toString());
        }
        this.lefthead.setText(this.statementOptions.getLHead());
        this.leftfoot.setText(this.statementOptions.getLFoot());
        this.righthead.setText(this.statementOptions.getRHead());
        this.rightfoot.setText(this.statementOptions.getRFoot());
        JRootPane rp = this.getRootPane();
        rp.setDefaultButton(this.bOk);
        this.setUndecorated(true);
        this.setResizable(false);
        this.pack();
        Rectangle frameBounds = this.frame.getBounds();
        Rectangle myBounds = this.getBounds();
        int newx = frameBounds.width > myBounds.width ? frameBounds.x + (frameBounds.width - myBounds.width) / 2 : frameBounds.x + 20;
        int newy = frameBounds.height > myBounds.height ? frameBounds.y + (frameBounds.height - myBounds.height) / 2 : frameBounds.y + 20;
        this.setLocation(newx, newy);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.bOk) {
            Integer i;
            this.statementOptions.setCenter(this.bCenter.isSelected());
            this.statementOptions.setRight(this.bRight.isSelected());
            this.statementOptions.setOdd(this.bOdd.isSelected());
            this.statementOptions.setEven(this.bEven.isSelected());
            this.statementOptions.setNoLevels(this.bNoLevels.isSelected());
            this.statementOptions.setNoHeaders(this.bNoHeaders.isSelected());
            try {
                i = new Integer(this.needlines.getText());
            }
            catch (Exception ie) {
                i = new Integer(0);
            }
            this.statementOptions.setNeed(i);
            try {
                i = new Integer(this.indent.getText());
            }
            catch (Exception ie) {
                i = new Integer(0);
            }
            this.statementOptions.setIndent(i);
            try {
                i = new Integer(this.rindent.getText());
            }
            catch (Exception ie) {
                i = new Integer(0);
            }
            this.statementOptions.setRindent(i);
            this.statementOptions.setLHead(this.lefthead.getText());
            this.statementOptions.setRHead(this.righthead.getText());
            this.statementOptions.setLFoot(this.leftfoot.getText());
            this.statementOptions.setRFoot(this.rightfoot.getText());
            this.statementOptions.setChanged(true);
            this.setVisible(false);
            this.dispose();
        }
        if (o == this.bCancel) {
            this.setVisible(false);
            this.dispose();
            this.statementOptions.setChanged(false);
        }
        this.repaint();
    }
}

