/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

class StylesMenu
extends JMenu
implements ActionListener {
    ThWindow frame;
    FontTable fonttable;
    JRadioButtonMenuItem mplain;
    JRadioButtonMenuItem mbold;
    JRadioButtonMenuItem mitalic;
    JRadioButtonMenuItem munder;
    JMenuItem mstyles;
    String[] faces;
    JMenu styles;
    int offset;

    public StylesMenu(ThWindow f) {
        super("Styles");
        this.frame = f;
        DocView docview = this.frame.getDocView();
        this.fonttable = new FontTable();
        this.faces = this.fonttable.fontNames();
        CharFormat cf = docview.getDisplayCharFormat();
        this.mplain = new JRadioButtonMenuItem("Plain");
        this.mplain.addActionListener(this);
        if ((cf.getStyle() & 0) == 0) {
            this.mplain.setSelected(true);
        }
        this.mbold = new JRadioButtonMenuItem("Bold");
        this.mbold.addActionListener(this);
        this.mbold.setAccelerator(KeyStroke.getKeyStroke(66, 4));
        if ((cf.getStyle() & 2) == 2) {
            this.mbold.setSelected(true);
        }
        this.mitalic = new JRadioButtonMenuItem("Italic");
        this.mitalic.addActionListener(this);
        if ((cf.getStyle() & 4) == 4) {
            this.mitalic.setSelected(true);
        }
        this.munder = new JRadioButtonMenuItem("UnderLine");
        this.munder.addActionListener(this);
        if ((cf.getStyle() & 1) == 1) {
            this.munder.setSelected(true);
        }
        this.mstyles = new JMenuItem("Statement Format");
        this.mstyles.addActionListener(this);
        this.add(this.mplain);
        this.add(this.mbold);
        this.add(this.mitalic);
        this.add(this.munder);
        this.addSeparator();
        this.add(this.mstyles);
        this.addSeparator();
        this.offset = 7;
        this.styles = this;
        String cfface = cf.getFontName();
        String ts = "";
        FontTable ft = new FontTable();
        for (int i = 0; i < this.faces.length; ++i) {
            if (ts.compareTo(this.faces[i]) == 0 || !ft.verifyFont(this.faces[i])) continue;
            ts = this.faces[i];
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(this.faces[i]);
            mi.addActionListener(this);
            if (this.faces[i].compareTo(cfface) == 0) {
                mi.setSelected(true);
            }
            this.add(mi);
        }
    }

    public void actionPerformed(ActionEvent e) {
        byte charstyle;
        DocView docview = this.frame.getDocView();
        String s = e.getActionCommand();
        Object mi = e.getSource();
        boolean done = false;
        Options options = this.frame.getOptions();
        CharFormat defaultcf = docview.getDisplayCharFormat();
        CharFormat statementcf = docview.getStatementCharFormat();
        if (mi == this.mstyles) {
            String opttitle;
            StatementOptions so;
            Statement st = docview.findfocus();
            if (st != null) {
                so = new StatementOptions(st);
                opttitle = new String("Statement Format");
            } else {
                so = new StatementOptions(options);
                opttitle = new String("Default Statement Format");
            }
            StatementStyles ss = new StatementStyles(this.frame, so, opttitle);
            ss.setVisible(true);
            if (!so.isChanged()) {
                return;
            }
            if (st != null) {
                so.setStatementOptions(st, true);
                docview.repaint();
            } else {
                so.setStatementOptions(options);
            }
            return;
        }
        if (mi == this.mplain) {
            this.mbold.setSelected(false);
            this.mitalic.setSelected(false);
            this.munder.setSelected(false);
            charstyle = 0;
            done = true;
        }
        if (mi == this.mbold) {
            this.mplain.setSelected(false);
            done = true;
        }
        if (mi == this.mitalic) {
            this.mplain.setSelected(false);
            done = true;
        }
        if (mi == this.munder) {
            this.mplain.setSelected(false);
            done = true;
        }
        if (!(this.mitalic.isSelected() || this.mbold.isSelected() || this.munder.isSelected())) {
            this.mplain.setSelected(true);
        }
        if (done) {
            charstyle = 0;
            if (this.mbold.isSelected()) {
                charstyle = (byte)(charstyle | 2);
            }
            if (this.mitalic.isSelected()) {
                charstyle = (byte)(charstyle | 4);
            }
            if (this.munder.isSelected()) {
                charstyle = (byte)(charstyle | 1);
            }
            int charfont = defaultcf.getFace();
            short charsize = defaultcf.getSize();
            if (statementcf != null) {
                charfont = statementcf.getFace();
                charsize = statementcf.getSize();
            }
            CharFormat cf = new CharFormat(charfont, charsize, charstyle, this.fonttable);
            Statement st = docview.findfocus();
            if (st != null && st.isSelecting()) {
                st.updateSelectedCharFormatstyle(cf, charstyle);
                docview.flushrelease();
                docview.repaint();
            }
            docview.setStatementCharFormat(cf);
            return;
        }
        String face = "";
        int size = this.styles.getItemCount() - this.offset;
        for (int i = 0; i < size; ++i) {
            JRadioButtonMenuItem mit = (JRadioButtonMenuItem)this.styles.getItem(i + this.offset);
            if (mit != mi) {
                mit.setSelected(false);
                continue;
            }
            mit.setSelected(true);
            face = s;
        }
        int charfont = this.fonttable.whatNum(face);
        Statement st = null;
        st = docview.findfocus();
        charstyle = defaultcf.getStyle();
        short charsize = defaultcf.getSize();
        if (st == null) {
            CharFormat cf = new CharFormat(face, charsize, charstyle, this.fonttable);
            docview.setDisplayCharFormat(cf);
            docview.setStatementCharFormat(null);
            docview.repaint();
            this.frame.getOptions().setFont(face);
            return;
        }
        if (statementcf != null) {
            charstyle = statementcf.getStyle();
            charsize = statementcf.getSize();
        }
        CharFormat cf = new CharFormat(face, charsize, charstyle, this.fonttable);
        if (st != null && st.isSelecting()) {
            st.updateSelectedCharFormatfont(cf, cf.getFace(), charsize);
            docview.flushrelease();
            docview.repaint();
        }
        docview.setStatementCharFormat(cf);
    }

    public void updateMenu(CharFormat tcf) {
        String newface = tcf.getFontName();
        byte newstyle = tcf.getStyle();
        this.mplain.setSelected(true);
        this.mbold.setSelected(false);
        this.mitalic.setSelected(false);
        this.munder.setSelected(false);
        if ((newstyle & 2) == 2) {
            this.mplain.setSelected(false);
            this.mbold.setSelected(true);
        }
        if ((newstyle & 4) == 4) {
            this.mplain.setSelected(false);
            this.mitalic.setSelected(true);
        }
        if ((newstyle & 1) == 1) {
            this.mplain.setSelected(false);
            this.munder.setSelected(true);
        }
        int size = this.styles.getItemCount() - this.offset;
        for (int i = 0; i < size; ++i) {
            JRadioButtonMenuItem mit = (JRadioButtonMenuItem)this.styles.getItem(i + this.offset);
            String ss = mit.getText();
            if (newface.compareTo(ss) == 0) {
                mit.setSelected(true);
                continue;
            }
            mit.setSelected(false);
        }
    }
}

