/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.NoSuchElementException;
import java.util.Vector;

class TextStatement
extends Statement {
    public static final int TEXTMAX = 2000;
    public static final int TEXTEXTRA = 20;
    StatementFormat sf = null;
    CharFormat statementcf = null;
    Vector<Integer> rows;
    Vector<Integer> heights;
    Vector<Integer> lengths;
    int stlength;
    int stoffset;
    int stlastrow;
    int lastoffset;
    int nextoffset;
    short[] sizes;
    boolean calcsizes;
    Rectangle savedD;
    CharFormat savedCf;
    boolean isresource = false;
    boolean isSeeThrough = false;
    int seeThroughLevel = 0;
    String stringOfLabels = null;
    int firstChar = 0;
    int stheight;
    String backupStringOfLabels = null;
    byte[] backupText = null;
    boolean backupDirty = false;
    int backupLength = 0;
    StatementFormat backupSf = null;
    CharFormat backupStatementCf = null;
    boolean backedup = false;
    String backupLHead = null;
    String backupRHead = null;
    String backupLFoot = null;
    String backupRFoot = null;
    TextStatement seeThroughStatement = null;

    public TextStatement(Doc d, int anchor, Options opts) {
        int tl;
        this.sttop = 0;
        this.stleft = 0;
        this.stright = 0;
        this.stbottom = 0;
        this.stlastrow = 0;
        this.stoffset = 0;
        this.lastoffset = 0;
        this.focus = false;
        this.drawn = false;
        this.selecting = false;
        this.isanimage = false;
        this.dirty = false;
        this.rhead = null;
        this.lhead = null;
        this.rfoot = null;
        this.lfoot = null;
        this.rows = new Vector();
        this.heights = new Vector();
        this.lengths = new Vector();
        this.nextstatement = null;
        this.doc = d;
        this.options = opts;
        this.sb = d.getStatementBlock(anchor);
        this.text = new byte[2020];
        this.length = this.sb.getLength();
        this.savedD = new Rectangle(0, 0, 0, 0);
        this.savedCf = new CharFormat();
        this.calcsizes = true;
        this.sizes = new short[2020];
        int offset = 0;
        int i = tl = this.length;
        if (i > 80) {
            i = 80;
        }
        this.sb.getV2Data(this.text, offset, i);
        tl -= i;
        offset += i;
        int chain = this.sb.getChain();
        while (tl > 0) {
            ChainBlock cb = d.getChainBlock(chain);
            i = tl;
            if (i > 124) {
                i = 124;
            }
            cb.getData(this.text, offset, i);
            tl -= i;
            offset += i;
            chain = cb.getChain();
        }
        i = 0;
        while (0 != this.text[i]) {
            ++i;
        }
        this.length = i;
        this.stlength = this.sb.getLength();
        if (this.stlength > this.length) {
            this.sf = new StatementFormat(this.text, this.length + 1, this.stlength - 1);
            this.statementcf = this.sf.getStatementFormat();
        }
        if (this.sf == null) {
            this.sf = new StatementFormat();
            this.statementcf = this.sf.getStatementFormat();
        }
        if ((this.sb.getV2Fmt() & 2) == 2) {
            this.hfb = new HeadFootBlock(this.doc, this.sb.getHeadFoot());
            this.lhead = this.hfb.getLeftHead();
            this.rhead = this.hfb.getRightHead();
            this.lfoot = this.hfb.getLeftFoot();
            this.rfoot = this.hfb.getRightFoot();
        }
        this.labels = this.isolateLabels();
        this.firstChar = 0;
        if (this.options != null && this.options.getHideLabels() && this.text[0] == 40) {
            this.stringOfLabels = this.separateLabels();
        } else if (this.text[0] == 40) {
            for (i = 0; i < this.length; ++i) {
                if (this.text[i] != 41) continue;
                this.firstChar = i + 1;
                break;
            }
        }
    }

    public TextStatement(Doc d, int anchor) {
        int tl;
        this.sttop = 0;
        this.stleft = 0;
        this.stright = 0;
        this.stbottom = 0;
        this.stlastrow = 0;
        this.stoffset = 0;
        this.lastoffset = 0;
        this.focus = false;
        this.drawn = false;
        this.selecting = false;
        this.isanimage = false;
        this.dirty = false;
        this.rhead = null;
        this.lhead = null;
        this.rfoot = null;
        this.lfoot = null;
        this.isresource = true;
        this.nextstatement = null;
        this.doc = d;
        this.sb = d.getStatementBlock(anchor);
        this.text = new byte[2020];
        this.length = this.sb.getLength();
        int offset = 0;
        int i = tl = this.length;
        if (i > 80) {
            i = 80;
        }
        this.sb.getV2Data(this.text, offset, i);
        tl -= i;
        offset += i;
        int chain = this.sb.getChain();
        while (tl > 0) {
            ChainBlock cb = d.getChainBlock(chain);
            i = tl;
            if (i > 124) {
                i = 124;
            }
            cb.getData(this.text, offset, i);
            tl -= i;
            offset += i;
            chain = cb.getChain();
        }
        this.stlength = this.sb.getLength();
    }

    public String getLabelString() {
        if (this.stringOfLabels != null) {
            return this.stringOfLabels;
        }
        if (this.text[0] != 40) {
            return null;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.text[i] != 41) continue;
            return new String(this.text, 1, i - 1);
        }
        return new String(this.text, 1, this.length - 2);
    }

    public int getFirstChar() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getFirstChar();
        }
        return this.firstChar;
    }

    public byte[] getBytes() {
        if (this.options != null) {
            boolean seethrough = this.options.getSeeThrough();
            this.seeThroughStatement = !seethrough ? null : this.checkSeeThrough();
            if (this.seeThroughStatement != null) {
                return this.seeThroughStatement.getBytes();
            }
        }
        return this.text;
    }

    public boolean isDrawn() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.isDrawn();
        }
        return this.drawn;
    }

    public void clearDrawn() {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.clearDrawn();
            return;
        }
        this.drawn = false;
    }

    public void clearSelect() {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.clearSelect();
            return;
        }
        this.selecting = false;
    }

    public boolean isSelecting() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.isSelecting();
        }
        return this.selecting;
    }

    public int getTop() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getTop();
        }
        return this.sttop;
    }

    public int getBottom() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getBottom();
        }
        return this.stbottom;
    }

    public void markOn(Graphics g) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.markOn(g);
            return;
        }
        if (this.sttop != 0) {
            g.setColor(Color.lightGray);
            g.fillRect(this.stleft, this.sttop, this.stright - this.stleft, this.stbottom - this.sttop);
            g.setColor(Color.black);
        }
    }

    public void erase(Graphics g) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.erase(g);
            return;
        }
        if (this.sttop != 0) {
            g.setColor(Color.white);
            g.fillRect(this.stleft, this.sttop, this.stright - this.stleft, this.stbottom - this.sttop);
        }
    }

    public boolean isInStatement(int x, int y) {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.isInStatement(x, y);
        }
        return y >= this.sttop && y < this.stbottom;
    }

    public boolean isInFocus() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.isInFocus();
        }
        return this.focus;
    }

    public void setFocus(boolean f) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.setFocus(f);
            return;
        }
        this.focus = f;
    }

    public boolean isDirty() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.isDirty();
        }
        if (this.sb.isDirty()) {
            return true;
        }
        return this.dirty;
    }

    public void setDirty() {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.setDirty();
            return;
        }
        this.dirty = true;
    }

    public Doc getVDoc() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getVDoc();
        }
        return this.doc;
    }

    public int getVBlockNumber() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getVBlockNumber();
        }
        return this.sb.getBlockNumber();
    }

    public void unDo() {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.unDo();
            return;
        }
        if (this.backedup) {
            this.restoreStatement();
        }
    }

    public void setCalcsizes() {
        this.calcsizes = true;
    }

    public boolean putStatement(CharFormat cf) {
        int tchainblock;
        ChainBlock chain;
        int i;
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.putStatement(cf);
        }
        if (!this.isDirty()) {
            return false;
        }
        if (this.freed) {
            return false;
        }
        if (!this.isresource) {
            this.text = this.restoreText();
            this.sf.setLabelOffset(0);
            Vector tlabels = this.isolateLabels();
            this.comparelabels(this.labels, tlabels);
            this.labels = tlabels;
        }
        byte[] buf = new byte[12020];
        int len = this.length;
        for (i = 0; i < this.length; ++i) {
            buf[i] = this.text[i];
        }
        if (!this.isresource) {
            if (this.sf == null) {
                buf[this.length] = 0;
                len = this.length + 1;
            } else {
                i = this.sf.getFormatString(buf, len, this.length, cf);
                len = this.length + i;
            }
        }
        this.sb.putLength(len);
        this.sb.setTime();
        int offset = 0;
        i = this.sb.putV2Data(buf, offset, len);
        len -= i;
        offset += i;
        int chainblock = this.sb.getChain();
        this.sb.putChain(0);
        this.sb.putBlock();
        while (chainblock != 0) {
            chain = this.doc.getChainBlock(chainblock);
            tchainblock = chain.getChain();
            this.doc.freeBlock(chainblock);
            chainblock = tchainblock;
        }
        if (len != 0) {
            ChainBlock tchain = this.doc.getChainBlock();
            tchainblock = tchain.getBlockNumber();
            i = tchain.setData(buf, offset, len);
            len -= i;
            offset += i;
            this.sb.putChain(tchainblock);
            this.sb.putBlock();
            tchain.putBlock();
            chainblock = 0;
            chain = null;
            while (len > 0) {
                chain = this.doc.getChainBlock();
                chainblock = chain.getBlockNumber();
                i = chain.setData(buf, offset, len);
                len -= i;
                offset += i;
                tchain.setChain(chainblock);
                tchain.putBlock();
                tchainblock = chainblock;
                tchain = chain;
            }
            if (chainblock != 0) {
                chain.setChain(0);
                chain.putBlock();
            }
        }
        if (this.lhead != null) {
            if (this.hfb == null) {
                this.hfb = new HeadFootBlock(this.doc);
            }
            this.hfb.putLeftHead(this.lhead);
            this.hfb.putRightHead(this.rhead);
            this.hfb.putLeftFoot(this.lfoot);
            this.hfb.putRightFoot(this.rfoot);
            this.hfb.putBlock();
            int hfblk = this.hfb.getBlockNumber();
            this.sb.putHeadFoot(hfblk);
        }
        this.dirty = false;
        this.firstChar = 0;
        if (this.options != null && this.options.getHideLabels() && this.text[0] == 40) {
            this.stringOfLabels = this.separateLabels();
        } else if (this.text[0] == 40) {
            for (i = 0; i < this.length; ++i) {
                if (this.text[i] != 41) continue;
                this.firstChar = i + 1;
                break;
            }
        }
        return true;
    }

    public StatementBlock copyStatement() {
        TextStatement newst = (TextStatement)StatementFactory.make(this.doc, this.options, false);
        int savelength = this.length;
        newst.text = this.restoreText();
        newst.length = this.length;
        this.length = savelength;
        newst.sf = this.sf.copyStatementFormat(this.length);
        newst.sf.setLabelOffset(0);
        if (this.lhead != null) {
            newst.lhead = new String(this.lhead);
            newst.rhead = new String(this.rhead);
            newst.lfoot = new String(this.lfoot);
            newst.rfoot = new String(this.rfoot);
        }
        newst.dirty = true;
        newst.putStatement(this.sf.getStatementFormat());
        return newst.sb;
    }

    public TextStatement splitStatement(int index) {
        if (this.seeThroughStatement != null) {
            return null;
        }
        TextStatement newst = (TextStatement)StatementFactory.make(this.doc, this.options, false);
        newst.sf = this.sf.splitStatementFormat(index, this.length);
        int newlen = this.length - index;
        for (int i = 0; i < newlen; ++i) {
            newst.text[i] = this.text[index + i];
            this.text[index + i] = 0;
        }
        newst.length = newlen;
        newst.dirty = true;
        this.length = index;
        this.dirty = true;
        if (this.isCenter()) {
            newst.setCenter(true);
        }
        if (this.isRight()) {
            newst.setRight(true);
        }
        if (this.isEven()) {
            newst.setEven(true);
        }
        if (this.isOdd()) {
            newst.setOdd(true);
        }
        if (this.isNoHeaders()) {
            newst.setNoHeaders(true);
        }
        if (this.isNoLevels()) {
            newst.setNoLevels(true);
        }
        newst.setIndent(this.getIndent());
        newst.setRindent(this.getRindent());
        newst.setNeed(this.getNeed());
        this.statementcf = this.sf.getStatementFormat();
        newst.putStatement(this.statementcf);
        this.putStatement(this.statementcf);
        return newst;
    }

    public void joinStatement(TextStatement st) {
        if (this.seeThroughStatement != null) {
            return;
        }
        this.sf.joinStatementFormat(st.sf, st.length, this.length);
        for (int i = 0; i < st.length; ++i) {
            this.text[this.length + i] = st.text[i];
        }
        this.caretoffset = this.length;
        this.length += st.length;
        this.dirty = true;
        this.calcsizes = true;
        this.putStatement(this.statementcf);
    }

    public void setSelected(int begin, int end) {
        this.selecting = true;
        this.beginselect = begin;
        this.endselect = end;
    }

    protected void setSeeThrough() {
        this.isSeeThrough = true;
    }

    protected void setSeeThroughLevel(int level) {
        this.seeThroughLevel = level;
    }

    protected Vector getLabels() {
        return this.labels;
    }

    public Vector getRows() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getRows();
        }
        return (Vector)this.rows.clone();
    }

    public int getOffset() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getOffset();
        }
        return this.stoffset;
    }

    public int getLastOffset() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getLastOffset();
        }
        return this.lastoffset;
    }

    public int getNextOffset() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getNextOffset();
        }
        return this.nextoffset;
    }

    public int getLastRow() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getLastRow();
        }
        return this.stlastrow;
    }

    public int getTextMax() {
        if (this.stringOfLabels == null) {
            return 2000;
        }
        return 2000 - this.stringOfLabels.length() - 2;
    }

    public boolean isLabels() {
        return this.labels != null;
    }

    public int draw(Graphics g, Rectangle d, int top, int offset, MyCaret mycaret, boolean drawit, CharFormat dcf, Component c) {
        short spacing;
        int height;
        boolean seethrough;
        int indent = d.x;
        if (this.options.getShowLevel()) {
            indent += 20;
        }
        if (!d.equals(this.savedD) || !dcf.equals(this.savedCf)) {
            this.savedD = new Rectangle(d);
            this.savedCf = new CharFormat(dcf);
            this.calcsizes = true;
        }
        this.seeThroughStatement = !(seethrough = this.options.getSeeThrough()) ? null : this.checkSeeThrough();
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.draw(g, d, top, offset, mycaret, drawit, dcf, c);
        }
        CharFormat drawcf = dcf;
        if (this.statementcf != null) {
            drawcf = this.statementcf;
        }
        this.drawn = false;
        this.stoffset = offset;
        this.sttop = top;
        this.stleft = this.sb.getLevel() * 2 * 9 + indent;
        if (this.isSeeThrough) {
            this.stleft = this.seeThroughLevel * 2 * 9 + indent;
        }
        this.stright = d.width;
        this.computeOffsets(g, d.width - (this.stleft + 10), offset, drawcf);
        g.setFont(drawcf.getFont());
        FontMetrics fm = g.getFontMetrics();
        this.stheight = fm.getHeight();
        if (this.isSeeThrough) {
            g.setColor(new Color(140, 97, 54));
        } else {
            g.setColor(Color.black);
        }
        if (this.isPage() && !this.options.getPageMode()) {
            g.setColor(Color.red);
        }
        int place = top;
        int row = this.rows.indexOf(new Integer(offset));
        if (row < 0) {
            row = 0;
        }
        if ((height = this.heights.elementAt(row).intValue()) == 0) {
            height = this.stheight;
        }
        this.lastoffset = 0;
        this.nextoffset = 0;
        while (place < d.height - height) {
            this.drawn = true;
            int index = this.rows.elementAt(row);
            int rowlength = row < this.rows.size() - 1 ? this.rows.elementAt(row + 1) - index : this.length - index;
            int sleft = this.sb.getLevel() * 2 * 9 + indent;
            if (this.isSeeThrough) {
                sleft = this.seeThroughLevel * 2 * 9 + indent;
            }
            int linelength = this.lengths.elementAt(row);
            if (this.isCenter()) {
                sleft = d.x < 50 ? (d.width - linelength) / 2 : (d.width + d.x - linelength) / 2;
            }
            if (this.isRight()) {
                sleft = d.width - linelength;
            }
            if (drawit) {
                if (this.selecting && this.endselect != 0) {
                    int first = 0;
                    int last = 0;
                    int lineend = index + rowlength - 1;
                    if (index + rowlength == this.length) {
                        ++lineend;
                    }
                    if (index >= this.beginselect && index < this.endselect && lineend > this.endselect) {
                        first = index;
                        last = this.endselect;
                    } else if (this.beginselect > index && this.endselect < lineend) {
                        first = this.beginselect;
                        last = this.endselect;
                    } else if (this.beginselect > index && lineend > this.beginselect && this.endselect >= lineend) {
                        first = this.beginselect;
                        last = lineend;
                    } else if (index >= this.beginselect && this.endselect >= lineend) {
                        first = index;
                        last = lineend;
                    }
                    if (first + last != 0) {
                        Point p = this.computecaretxy(g, first, new Dimension(d.width, d.height), drawcf);
                        int selleft = p.x;
                        p = this.computecaretxy(g, last, new Dimension(d.width, d.height), drawcf);
                        int selright = p.x;
                        Color savecolor = g.getColor();
                        g.setColor(Color.lightGray);
                        g.setPaintMode();
                        g.fillRect(selleft, place, selright - selleft, height);
                        g.setColor(savecolor);
                    }
                }
                this.drawline(g, this.text, index, rowlength, sleft, place + height - 3, drawcf);
                if (index == 0 && this.options.getShowLevel() && !this.isNoLevels()) {
                    g.drawString(this.doc.whatsMyLevel(this.sb, "."), d.x, place + height - 3);
                }
            }
            this.lastoffset = index;
            place += height;
            this.nextoffset = 0;
            if (++row >= this.rows.size() || row >= this.options.getNlines()) break;
            height = this.heights.elementAt(row);
            this.nextoffset = this.rows.elementAt(row);
        }
        if (height == 0) {
            height = 12;
        }
        if (drawit && this.options.getShowDate()) {
            this.drawDateLine(g, d, place, height);
            place += height;
        }
        this.stlastrow = row - 1;
        if (place == top) {
            place = top + this.stheight;
        }
        if ((spacing = this.options.getSpacing()) == 1) {
            place += height;
        }
        if (spacing == 2) {
            place += height / 2;
        }
        if (spacing == 3) {
            place += height / 3;
        }
        this.stbottom = place;
        if (this.isSeeThrough) {
            this.stbottom = place;
        }
        if (mycaret != null && mycaret.isDocStatement(this.doc, this.getBlockNumber())) {
            this.caretoffset = mycaret.getOffset();
            Point p = this.computecaretxy(g, this.caretoffset, new Dimension(d.width, d.height), drawcf);
            if (this.caretoffset >= offset) {
                mycaret.setCaret(p.x - 1, p.y - 6);
                this.focus = true;
            }
        }
        return place;
    }

    private void drawline(Graphics g, byte[] text, int index, int rowlength, int x, int y, CharFormat dcf) {
        int i;
        int newx;
        CharFormat currentcf = dcf;
        g.setFont(currentcf.getFont());
        FontMetrics fm = g.getFontMetrics();
        int start = index;
        if (this.sf == null) {
            if (rowlength != 0) {
                g.drawBytes(text, index, rowlength, x, y);
            }
            return;
        }
        for (int count = rowlength; count > 0; --count) {
            CharFormat charcf = this.sf.getCharFormat(dcf, index);
            if (!charcf.isEqual(currentcf)) {
                if (start != index) {
                    newx = x;
                    g.drawBytes(text, start, index - start, x, y);
                    for (i = start; i < index; ++i) {
                        newx += this.sizes[i];
                    }
                    if (currentcf.isUnderline()) {
                        g.drawLine(x, y + 1, newx, y + 1);
                    }
                    x = newx;
                    start = index;
                }
                currentcf = charcf;
                g.setFont(currentcf.getFont());
                fm = g.getFontMetrics();
                ++index;
                continue;
            }
            ++index;
        }
        newx = x;
        if (start != index) {
            g.drawBytes(text, start, index - start, x, y);
            for (i = start; i < index; ++i) {
                newx += this.sizes[i];
            }
        }
        if (currentcf.isUnderline()) {
            g.drawLine(x, y + 1, newx, y + 1);
        }
    }

    public void playDraw(Graphics g, Rectangle d, CharFormat dcf) {
        boolean seethrough = this.options.getSeeThrough();
        this.seeThroughStatement = !seethrough ? null : this.checkSeeThrough();
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.playDraw(g, d, dcf);
            return;
        }
        if (!d.equals(this.savedD)) {
            this.savedD = new Rectangle(d);
            this.calcsizes = true;
        }
        int indent = d.x;
        if (this.options.getShowLevel()) {
            indent += 20;
        }
        CharFormat drawcf = dcf;
        if (this.statementcf != null) {
            drawcf = this.statementcf;
        }
        int stleft = this.sb.getLevel() * 2 * 9 + indent;
        if (this.isSeeThrough) {
            stleft = this.seeThroughLevel * 2 * 9 + indent;
        }
        this.calcsizes = true;
        this.computeOffsets(g, d.width - (stleft + 10), 0, drawcf);
    }

    private void computeOffsets(Graphics g, int width, int offset, CharFormat dcf) {
        int index;
        String textstr = new String(this.text, 0, this.length);
        if (!this.calcsizes) {
            return;
        }
        this.calcsizes = false;
        this.rows.removeAllElements();
        this.heights.removeAllElements();
        this.lengths.removeAllElements();
        int blank = 0;
        int tl = 0;
        int maxheight = 0;
        int blankheight = 0;
        int linelength = 0;
        this.rows.addElement(new Integer(index));
        CharFormat currentcf = this.sf.getCharFormat(dcf, index);
        g.setFont(currentcf.getFont());
        FontMetrics fm = g.getFontMetrics();
        for (index = offset; index < this.length; ++index) {
            CharFormat localcf;
            if (32 == this.text[index] || 13 == this.text[index] || 10 == this.text[index]) {
                blank = index;
                linelength = tl;
                blankheight = maxheight;
            }
            if (!currentcf.isEqual(localcf = this.sf.getCharFormat(dcf, index))) {
                currentcf = localcf;
                g.setFont(currentcf.getFont());
                fm = g.getFontMetrics();
            }
            int cw = fm.charWidth(textstr.charAt(index));
            this.sizes[index] = (short)cw;
            tl += cw;
            if (fm.getHeight() > maxheight) {
                maxheight = fm.getHeight();
            }
            if (tl < width && this.text[index] != 13 && this.text[index] != 10) continue;
            if (0 != blank) {
                index = blank + 1;
                maxheight = blankheight;
            }
            this.lengths.addElement(new Integer(linelength));
            this.heights.addElement(new Integer(maxheight));
            this.rows.addElement(new Integer(index));
            if (index == blank + 1) {
                --index;
            }
            maxheight = 0;
            tl = 0;
            blank = 0;
            linelength = 0;
        }
        this.lengths.addElement(new Integer(tl));
        this.heights.addElement(new Integer(maxheight));
    }

    public LabelString doubleClick(MyCaret mycaret) throws NoSuchElementException {
        int i;
        int linkoffset;
        int startbl = -1;
        int endbl = -1;
        int startbr = -1;
        int endbr = -1;
        String punct = " !?[](){}'\"";
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.doubleClick(mycaret);
        }
        if (linkoffset == -1) {
            throw new NoSuchElementException("<>");
        }
        byte style = this.sf.getCharFormat(null, linkoffset).getStyle();
        int temp = linkoffset;
        for (linkoffset = mycaret.getOffset(); linkoffset >= 0; --linkoffset) {
            if (this.options.getSDL() && style != 0) {
                byte tstyle = this.sf.getCharFormat(null, linkoffset).getStyle();
                if (tstyle != style) {
                    startbr = linkoffset;
                    break;
                }
            } else if (punct.indexOf(this.text[linkoffset]) != -1 && linkoffset != temp && startbl == -1) {
                startbl = linkoffset;
            }
            if (this.text[linkoffset] == 60) {
                startbr = linkoffset;
                break;
            }
            if (this.text[linkoffset] != 62 || linkoffset == temp) continue;
            if (startbl != -1) break;
            startbl = linkoffset;
            break;
        }
        temp = i = mycaret.getOffset();
        while (i < this.length) {
            if (this.options.getSDL() && style != 0) {
                if (this.sf.getCharFormat(null, i).getStyle() != style) {
                    endbr = i;
                    break;
                }
            } else if (punct.indexOf(this.text[i]) != -1 && endbl == -1) {
                endbl = i;
            }
            if (this.text[i] == 62) {
                endbr = i;
                break;
            }
            if (this.text[i] == 60 && i != temp) {
                if (endbl != -1) break;
                endbl = i;
                break;
            }
            ++i;
        }
        if (endbl == -1) {
            endbl = this.length;
        }
        if (startbr == -1 && this.options.getSCJ()) {
            this.beginselect = startbl + 1;
            this.endselect = endbl;
            this.selecting = true;
            return null;
        }
        if (startbr == -1) {
            linkoffset = startbl;
            i = endbl;
        }
        if (startbr != -1 && endbr == -1) {
            linkoffset = startbl;
            i = endbl;
        }
        if (startbr != -1 && endbr != -1) {
            linkoffset = startbr;
            i = endbr;
        }
        if (this.text[linkoffset + 1] == 32) {
            return null;
        }
        String label = new String(this.text, linkoffset + 1, i - linkoffset - 1);
        if (label.compareTo("") == 0) {
            return null;
        }
        LabelString ls = new LabelString(label, this.options, this.doc);
        return ls;
    }

    public boolean shiftClick(DocView docview, MouseEvent e, int x, int y) {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.shiftClick(docview, e, x, y);
        }
        if (!this.selecting) {
            return false;
        }
        CharFormat drawcf = docview.getDisplayCharFormat();
        if (this.statementcf != null) {
            drawcf = this.statementcf;
        }
        this.caretoffset = this.computecaretoffset(docview.getGraphics(), x, y, docview.getViewSize(), drawcf);
        if (this.caretoffset == -1) {
            return false;
        }
        if (this.caretoffset < this.beginselect) {
            this.beginselect = this.caretoffset;
        }
        if (this.caretoffset > this.endselect) {
            this.endselect = this.caretoffset;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int cursorKey(DocView docview, MyCaret mycaret, int code) {
        Point p;
        this.caretoffset = mycaret.getOffset();
        CharFormat drawcf = docview.getDisplayCharFormat();
        if (this.statementcf != null) {
            drawcf = this.statementcf;
        }
        if (code == 37) {
            if (this.caretoffset <= 0) return code;
            --this.caretoffset;
        } else if (code == 39) {
            if (this.caretoffset >= this.length) return code;
            ++this.caretoffset;
        } else if (code == 40) {
            if (this.length == 0) {
                return code;
            }
            p = mycaret.getCaretPoint();
            int x = p.x + 1;
            int y = p.y + 6;
            int row = this.getrow(x, y);
            if (row >= this.rows.size()) return code;
            y = y + this.getheight(row) - 1;
            this.caretoffset = this.computecaretoffset(docview.getGraphics(), x, y, docview.getViewSize(), drawcf);
            if (this.caretoffset == -1) {
                return code;
            }
        } else if (code == 38) {
            p = mycaret.getCaretPoint();
            int x = p.x + 1;
            int y = p.y + 6;
            int row = this.getrow(x, y);
            if (row <= 0) return code;
            y = y - this.getheight(row - 1) - 1;
            this.caretoffset = this.computecaretoffset(docview.getGraphics(), x, y, docview.getViewSize(), drawcf);
            if (this.caretoffset == -1) {
                return code;
            }
        }
        mycaret.setCaretStatement(this.doc, this.getBlockNumber(), this.caretoffset);
        p = this.computecaretxy(docview.getGraphics(), this.caretoffset, docview.getViewSize(), drawcf);
        mycaret.setCaret(p.x - 1, p.y - 6);
        mycaret.showCaret();
        return 0;
    }

    public boolean mouseDown(DocView docview, MyCaret mycaret, MouseEvent e, int x, int y) {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.mouseDown(docview, mycaret, e, x, y);
        }
        this.backupStatement();
        CharFormat drawcf = docview.getDisplayCharFormat();
        if (this.statementcf != null) {
            drawcf = this.statementcf;
        }
        this.selecting = false;
        this.beginselect = 0;
        this.endselect = 0;
        this.startselect = 0;
        if (this.isSeeThrough) {
            this.startselect = 0;
        }
        if (this.focus) {
            CharFormat tcf;
            this.caretoffset = this.computecaretoffset(docview.getGraphics(), x, y, docview.getViewSize(), drawcf);
            if (this.caretoffset != -1) {
                mycaret.setCaretStatement(this.doc, this.getBlockNumber(), this.caretoffset);
                this.caretoffset = mycaret.getOffset();
                Point p = this.computecaretxy(docview.getGraphics(), this.caretoffset, docview.getViewSize(), drawcf);
                mycaret.setHeight(this.stheight);
                mycaret.setCaret(p.x - 1, p.y - 6);
                mycaret.showCaret();
            }
            if ((tcf = this.caretoffset < 0 ? drawcf : (this.caretoffset == 0 ? this.sf.getCharFormat(drawcf, this.caretoffset) : this.sf.getCharFormat(drawcf, this.caretoffset - 1))).getFace() == 0) {
                tcf = new CharFormat(drawcf.getFace(), tcf.getSize(), tcf.getStyle(), drawcf.getFontTable());
            }
            if (tcf.getSize() == 0) {
                tcf = new CharFormat(tcf.getFace(), drawcf.getSize(), tcf.getStyle(), drawcf.getFontTable());
            }
            docview.getFrame().updateStyleMenus(tcf);
            if (!tcf.isEqual(docview.getDisplayCharFormat())) {
                docview.setStatementCharFormat(tcf);
            }
        }
        return true;
    }

    public boolean mouseUp(DocView docview, MouseEvent e, int x, int y) {
        return true;
    }

    public boolean mouseMove(DocView docview, MouseEvent e, int x, int y) {
        return true;
    }

    public boolean mouseDrag(DocView docview, MouseEvent e, int x, int y) {
        CharFormat currentcf = docview.getDisplayCharFormat();
        if (this.statementcf != null) {
            currentcf = this.statementcf;
        }
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.mouseDrag(docview, e, x, y);
        }
        if (!this.selecting) {
            this.selecting = true;
            this.beginselect = this.caretoffset;
            this.endselect = this.caretoffset;
            if (this.beginselect != -1) {
                this.startselect = this.beginselect;
            }
        } else {
            int i = this.computecaretoffset(docview.getGraphics(), x, y, docview.getViewSize(), currentcf);
            if (i != -1) {
                if (i <= this.startselect) {
                    this.beginselect = i;
                    this.endselect = this.startselect;
                } else if (i > this.startselect) {
                    this.endselect = i;
                    this.beginselect = this.startselect;
                }
            }
        }
        return true;
    }

    public boolean removeSelected() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.removeSelected();
        }
        if (this.selecting) {
            this.dirty = true;
            this.calcsizes = true;
            this.selecting = false;
            this.caretoffset = this.beginselect;
            for (int numselect = this.endselect - this.beginselect; numselect > 0; --numselect) {
                this.sf.deleteCharFormat(this.beginselect, this.length);
                for (int i = this.caretoffset; i < this.length - 1; ++i) {
                    this.text[i] = this.text[i + 1];
                }
                --this.length;
            }
            return true;
        }
        return false;
    }

    public void addSelectedLabel(CharFormat dcf) {
        String newLabel;
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.addSelectedLabel(dcf);
            return;
        }
        if (!this.selecting) {
            return;
        }
        CharFormat drawcf = dcf;
        if (this.statementcf != null) {
            drawcf = this.statementcf;
        }
        if (this.length + (newLabel = new String(this.text, this.beginselect, this.endselect - this.beginselect)).length() > 2000) {
            return;
        }
        if (this.stringOfLabels != null) {
            int oldOffset = this.stringOfLabels.length() + 2;
            this.stringOfLabels = new String(newLabel + "," + this.stringOfLabels);
            int insertLength = newLabel.length() + 1;
            for (int i = 0; i < insertLength; ++i) {
                this.sf.insertCharFormat(drawcf, 0, this.length);
            }
            this.sf.setLabelOffset(oldOffset + insertLength);
        } else {
            boolean parensExist = false;
            this.stringOfLabels = this.separateLabels();
            if (this.stringOfLabels == null) {
                this.stringOfLabels = newLabel;
            } else {
                this.stringOfLabels = new String(newLabel + "," + this.stringOfLabels);
                parensExist = true;
            }
            this.text = this.restoreText();
            this.sf.setLabelOffset(0);
            int insertLength = newLabel.length() + 1;
            if (!parensExist) {
                insertLength += 2;
            }
            for (int i = 0; i < insertLength; ++i) {
                this.sf.insertCharFormat(drawcf, 0, this.length);
            }
        }
        this.selecting = false;
        this.beginselect = 0;
        this.endselect = 0;
        this.dirty = true;
        this.calcsizes = true;
    }

    public void removeCharAtCursor() {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.removeCharAtCursor();
            return;
        }
        if (this.caretoffset > 0) {
            this.dirty = true;
            this.calcsizes = true;
            --this.caretoffset;
            this.sf.deleteCharFormat(this.caretoffset, this.length);
            for (int i = this.caretoffset; i < this.length - 1; ++i) {
                this.text[i] = this.text[i + 1];
            }
            --this.length;
            this.selecting = false;
        }
    }

    public int getCaretOffset() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getCaretOffset();
        }
        return this.caretoffset;
    }

    public void setCaretOffset(int co) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.setCaretOffset(co);
        }
        this.caretoffset = co;
    }

    public StatementFormat getStatementFormat() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getStatementFormat();
        }
        return this.sf;
    }

    public void insertString(String str, CharFormat cf) {
        byte[] strtext = str.getBytes();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.insertChar(strtext[i], cf);
        }
    }

    public void insertChar(int key, CharFormat cf) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.insertChar(key, cf);
            return;
        }
        if (this.caretoffset < 0) {
            return;
        }
        this.dirty = true;
        this.calcsizes = true;
        this.sf.insertCharFormat(cf, this.caretoffset, this.length);
        for (int i = this.length; i > this.caretoffset; --i) {
            this.text[i] = this.text[i - 1];
        }
        this.text[this.caretoffset] = (byte)key;
        ++this.length;
        ++this.caretoffset;
        this.selecting = false;
    }

    public void updateSelectedCharFormat(CharFormat ucf) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.updateSelectedCharFormat(ucf);
            return;
        }
        if (this.selecting) {
            int numselect = this.endselect - this.beginselect;
            for (int i = 0; i < numselect; ++i) {
                this.sf.updateCharFormat(ucf, this.beginselect + i);
            }
            this.dirty = true;
            this.calcsizes = true;
        }
    }

    public void updateSelectedCharFormatstyle(CharFormat ucf, int newstyle) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.updateSelectedCharFormatstyle(ucf, newstyle);
            return;
        }
        if (this.selecting) {
            int numselect = this.endselect - this.beginselect;
            for (int i = 0; i < numselect; ++i) {
                this.sf.updateCharFormatstyle(ucf, this.beginselect + i, newstyle);
            }
            this.dirty = true;
            this.calcsizes = true;
        }
    }

    public void updateSelectedCharFormatfont(CharFormat ucf, int newfont, int newsize) {
        if (this.seeThroughStatement != null) {
            this.seeThroughStatement.updateSelectedCharFormatfont(ucf, newfont, newsize);
            return;
        }
        if (this.selecting) {
            int numselect = this.endselect - this.beginselect;
            for (int i = 0; i < numselect; ++i) {
                this.sf.updateCharFormatfont(ucf, this.beginselect + i, newfont, newsize);
            }
            this.dirty = true;
            this.calcsizes = true;
        }
    }

    public CharFormat getCharFormat(int index) {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.getCharFormat(index);
        }
        return this.sf.getCharFormat(new CharFormat("Times", 12, 0, new FontTable()), index);
    }

    public String returnSelected() {
        if (this.seeThroughStatement != null) {
            return this.seeThroughStatement.returnSelected();
        }
        if (!this.selecting) {
            return null;
        }
        return new String(this.text, this.beginselect, this.endselect - this.beginselect);
    }

    private int getrow(int x, int y) {
        int rowy = this.sttop;
        int nrows = this.rows.size();
        for (int row = 0; row < nrows; ++row) {
            int h = this.heights.elementAt(row);
            if (rowy + h >= y) {
                return row;
            }
            rowy += h;
        }
        return 0;
    }

    private int getheight(int row) {
        int h = this.heights.elementAt(row);
        return h;
    }

    private int computecaretoffset(Graphics g, int x, int y, Dimension d, CharFormat dcf) {
        int nrows = this.rows.size();
        int rowy = this.sttop;
        int rowx = this.stleft;
        FontMetrics fm = g.getFontMetrics(dcf.getFont());
        if (this.length == 0) {
            return 0;
        }
        for (int i = 0; i < nrows; ++i) {
            int h;
            int o = this.rows.elementAt(i);
            int e = this.length;
            if (i < nrows - 1) {
                e = this.rows.elementAt(i + 1);
            }
            if (rowy + (h = this.heights.elementAt(i).intValue()) > y) {
                int j;
                int linelength = this.lengths.elementAt(i);
                if (this.isCenter()) {
                    rowx = (d.width - linelength) / 2;
                }
                if (this.isRight()) {
                    rowx = d.width - linelength;
                }
                for (j = o; j < e; ++j) {
                    if (rowx + this.sizes[j] / 2 > x) {
                        return j;
                    }
                    if ((rowx += this.sizes[j]) <= this.stright) continue;
                    return -1;
                }
                return j;
            }
            rowy += h;
        }
        return -1;
    }

    private Point computecaretxy(Graphics g, int of, Dimension d, CharFormat dcf) {
        int nrows = this.rows.size();
        FontMetrics fm = g.getFontMetrics(dcf.getFont());
        int h = fm.getHeight();
        int carety = this.sttop;
        int caretx = this.stleft;
        if (of > 2000) {
            return new Point(caretx, carety);
        }
        if (of < 0) {
            return new Point(caretx, carety);
        }
        int linelength = this.lengths.elementAt(0);
        if (this.length == 0) {
            carety = this.sttop + h;
        }
        int o = 0;
        int preo = 0;
        for (int i = 0; i < nrows; ++i) {
            o = this.rows.elementAt(i);
            h = this.heights.elementAt(i);
            if (o > of) break;
            linelength = this.lengths.elementAt(i);
            preo = o;
            carety += h;
        }
        o = preo;
        if (this.isCenter()) {
            caretx = (d.width - linelength) / 2;
        }
        if (this.isRight()) {
            caretx = d.width - linelength;
        }
        for (int j = o; j < of; ++j) {
            caretx += this.sizes[j];
        }
        return new Point(caretx, carety);
    }

    private Vector isolateLabels() {
        String s;
        Vector<String> v = null;
        int start = 0;
        int stop = 0;
        if (this.text[0] != 40) {
            return null;
        }
        for (int i = 1; i < this.length; ++i) {
            if (this.text[i] == 41) {
                stop = i;
                break;
            }
            if (start == 0 && this.text[i] == 32) continue;
            if (start == 0) {
                start = i;
            }
            if (this.text[i] != 44) continue;
            if (v == null) {
                v = new Vector();
            }
            s = new String(this.text, start, i - start);
            v.addElement(s);
            start = 0;
        }
        if (start != 0 && stop != 0) {
            if (v == null) {
                v = new Vector<String>();
            }
            s = new String(this.text, start, stop - start);
            v.addElement(s);
            start = 0;
        }
        return v;
    }

    protected void comparelabels(Vector oldlabels, Vector newlabels) {
        String os;
        int oldi;
        String ns;
        int newi;
        boolean found = false;
        Labels labels = this.doc.getLabels();
        if (oldlabels == null && newlabels == null) {
            return;
        }
        if (oldlabels == null) {
            int newsize = newlabels.size();
            for (int newi2 = 0; newi2 < newsize; ++newi2) {
                labels.addLabel((String)newlabels.elementAt(newi2), this.getBlockNumber());
            }
            return;
        }
        if (newlabels == null) {
            int oldsize = oldlabels.size();
            for (int oldi2 = 0; oldi2 < oldsize; ++oldi2) {
                labels.delLabel((String)oldlabels.elementAt(oldi2), this.getBlockNumber());
            }
            return;
        }
        int oldsize = oldlabels.size();
        int newsize = newlabels.size();
        for (newi = 0; newi < newsize; ++newi) {
            found = false;
            ns = (String)newlabels.elementAt(newi);
            for (oldi = 0; oldi < oldsize; ++oldi) {
                os = (String)oldlabels.elementAt(oldi);
                if (!os.equalsIgnoreCase(ns)) continue;
                found = true;
                break;
            }
            if (found) continue;
            labels.addLabel(ns, this.getBlockNumber());
        }
        for (oldi = 0; oldi < oldsize; ++oldi) {
            found = false;
            os = (String)oldlabels.elementAt(oldi);
            for (newi = 0; newi < newsize; ++newi) {
                ns = (String)newlabels.elementAt(newi);
                if (!ns.equalsIgnoreCase(os)) continue;
                found = true;
                break;
            }
            if (found) continue;
            labels.delLabel(os, this.getBlockNumber());
        }
    }

    private TextStatement checkSeeThrough() {
        int len = 0;
        if (this.stringOfLabels != null) {
            return null;
        }
        if (this.text[0] != 60) {
            return null;
        }
        for (int i = 1; i < this.length; ++i) {
            if (this.text[i] == 60) {
                return null;
            }
            if (this.text[i] != 62) continue;
            len = i + 1;
            break;
        }
        String link = new String(this.text, 0, len);
        LabelString ls = new LabelString(link, this.options, this.doc);
        ThWindow frame = this.options.getFrame();
        if (frame == null) {
            return null;
        }
        DocLink dl = new DocLink(frame, ls, 0, 0);
        Doc newd = dl.getDocument();
        if (newd == null) {
            return null;
        }
        int block = dl.getBlock();
        if (this.seeThroughStatement != null && this.seeThroughStatement.getDoc() == newd && this.seeThroughStatement.getBlockNumber() == block) {
            return this.seeThroughStatement;
        }
        TextStatement newcthru = (TextStatement)newd.getStatement(block, this.options);
        if (newcthru != null) {
            newcthru.setSeeThrough();
            newcthru.setSeeThroughLevel(this.sb.getLevel());
        }
        return newcthru;
    }

    private String separateLabels() {
        int i;
        String sOL = null;
        int li = 0;
        if (this.text[0] != 40) {
            return sOL;
        }
        for (i = 1; i < this.length; ++i) {
            if (this.text[i] != 41) continue;
            li = i;
            break;
        }
        if (li != 0) {
            sOL = new String(this.text, 1, li - 1);
            this.sf.setLabelOffset(++li);
            for (i = li; i < this.length + 1; ++i) {
                this.text[i - li] = this.text[i];
            }
            this.length -= li;
        }
        return sOL;
    }

    protected byte[] restoreText() {
        int i;
        if (this.stringOfLabels == null) {
            return this.text;
        }
        byte[] txt = new byte[2020];
        int outi = 0;
        byte[] buf = this.stringOfLabels.getBytes();
        txt[outi] = 40;
        ++outi;
        for (i = 0; i < this.stringOfLabels.length(); ++i) {
            txt[outi] = buf[i];
            ++outi;
        }
        txt[outi] = 41;
        ++outi;
        for (i = 0; i < this.length; ++i) {
            txt[outi] = this.text[i];
            ++outi;
        }
        txt[outi] = 0;
        this.length = this.length + this.stringOfLabels.length() + 2;
        this.stringOfLabels = null;
        return txt;
    }

    private void backupStatement() {
        this.backupSf = this.sf.copyStatementFormat(this.length);
        this.backupStatementCf = this.sf.getStatementFormat();
        this.backupLength = this.length;
        this.backupStringOfLabels = null;
        if (this.stringOfLabels != null) {
            this.backupStringOfLabels = new String(this.stringOfLabels);
        }
        if (this.backupText == null) {
            this.backupText = new byte[2020];
        }
        for (int i = 0; i < this.length; ++i) {
            this.backupText[i] = this.text[i];
        }
        this.backupDirty = this.isDirty();
        if (this.rhead != null) {
            this.backupRHead = new String(this.rhead);
        }
        if (this.lhead != null) {
            this.backupLHead = new String(this.lhead);
        }
        if (this.rfoot != null) {
            this.backupRFoot = new String(this.rfoot);
        }
        if (this.lfoot != null) {
            this.backupLFoot = new String(this.lfoot);
        }
        this.backedup = true;
    }

    private void restoreStatement() {
        this.sf = this.backupSf;
        this.statementcf = this.backupStatementCf;
        this.length = this.backupLength;
        if (this.backupStringOfLabels != null) {
            this.stringOfLabels = this.backupStringOfLabels;
        }
        this.dirty = this.backupDirty;
        for (int i = 0; i < this.length; ++i) {
            this.text[i] = this.backupText[i];
        }
        if (this.backupRHead != null) {
            this.rhead = this.backupRHead;
            this.backupRHead = null;
        }
        if (this.backupRFoot != null) {
            this.rfoot = this.backupRFoot;
            this.backupRFoot = null;
        }
        if (this.backupLHead != null) {
            this.lhead = this.backupLHead;
            this.backupLHead = null;
        }
        if (this.backupLFoot != null) {
            this.lfoot = this.backupLFoot;
            this.backupLFoot = null;
        }
        this.backedup = false;
        this.calcsizes = true;
    }
}

