/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Date;

class ThEdit
implements ThCommand {
    ThWindow frame;
    DocView docview;
    long lasttime;
    public static final int MOUSEDOWN = 1;
    public static final int MOUSEUP = 2;
    public static final int KEYDOWN = 3;
    public static final int KEYUP = 4;
    public static final int KEYPRESSED = 5;
    public static final int CURSORKEY = 6;

    ThEdit(ThWindow f) {
        this.frame = f;
        this.docview = this.frame.getDocView();
        this.lasttime = 0L;
    }

    public boolean cmdStart(int code) {
        return false;
    }

    public boolean cmdContinue(MouseEvent e) {
        return false;
    }

    public void cmdEnd() {
    }

    public void cmdCancel() {
    }

    public void editKey(int code, KeyEvent e) {
        TextStatement st;
        int character = e.getKeyChar();
        int kcode = e.getKeyCode();
        int mask = e.getModifiers();
        if ((mask & 4) == 4) {
            return;
        }
        boolean isShift = (mask & 1) == 1;
        char[] myc = new char[10];
        byte[] myb = new byte[10];
        myc[0] = (char)character;
        String mystr = new String(myc, 0, 1);
        myb = mystr.getBytes();
        character = myb[0];
        character &= 0xFF;
        if (code == 5) {
            Statement tst = this.docview.findfocus();
            st = null;
            if (tst != null && tst.isText()) {
                st = (TextStatement)tst;
            }
            if (tst != null && character == 9) {
                Date date = new Date();
                long time = date.getTime();
                if (time < this.lasttime + 1000L) {
                    return;
                }
                this.lasttime = time;
                this.doTab(tst, mask);
                return;
            }
            if (st != null && st.isText()) {
                if (st.removeSelected()) {
                    this.frame.getMyCaret().setCaretStatement(st.getVDoc(), st.getVBlockNumber(), st.getCaretOffset());
                    if (character == 8) {
                        this.docview.repaintselected(st);
                        return;
                    }
                }
                if (character == 8) {
                    if (st.isText() && st.getCaretOffset() < 1) {
                        if ((st = this.dojoin(st)) == null) {
                            return;
                        }
                        this.frame.getMyCaret().setCaretStatement(st.getVDoc(), st.getVBlockNumber(), st.getCaretOffset());
                        return;
                    }
                    st.removeCharAtCursor();
                    this.frame.getMyCaret().setCaretStatement(st.getVDoc(), st.getVBlockNumber(), st.getCaretOffset());
                    this.docview.repaintselected(st);
                } else if (character >= 32 && character < 127 || character > 159 || character == 10 && isShift || character == 13 && isShift) {
                    if (st.getLength() > st.getTextMax()) {
                        this.doBeep();
                        st.clearSelect();
                        this.docview.repaintselected(st);
                        return;
                    }
                    CharFormat cf = this.docview.getStatementCharFormat() != null ? this.docview.getStatementCharFormat() : (st.getCaretOffset() < 1 ? new CharFormat() : st.getStatementFormat().getCharFormat(new CharFormat(), st.getCaretOffset() - 1));
                    st.insertChar(character, cf);
                    this.frame.getMyCaret().setCaretStatement(st.getVDoc(), st.getVBlockNumber(), st.getCaretOffset());
                    this.docview.repaintselected(st);
                } else if (character == 10 && !isShift) {
                    this.doSplit(st);
                }
                return;
            }
        }
        if (code == 4) {
            // empty if block
        }
        if (code == 3) {
            // empty if block
        }
        if (code == 6) {
            MyCaret mycaret = this.frame.getMyCaret();
            Statement tst = this.docview.findfocus();
            st = null;
            if (tst != null && tst.isText()) {
                st = (TextStatement)tst;
            }
            if (st != null) {
                int caction = st.cursorKey(this.docview, mycaret, kcode);
                Point p = mycaret.getCaretPoint();
                Rectangle r = this.docview.getBounds();
                if (p.y + 6 >= r.height - 1) {
                    this.docview.scrollLineDown();
                }
                if (caction != 0) {
                    Statement ttst;
                    int tblock;
                    if (caction == 39 || caction == 40) {
                        tblock = tst.getBlockNumber();
                        ttst = this.docview.getLastStatement();
                        if (ttst == st) {
                            this.docview.scrollLineDown();
                            this.docview.recompute();
                            tst = this.docview.findstatementbyblock(tblock);
                        }
                        if ((tst = tst.getNextStatement()) != null && tst.isText() && tst.isDrawn()) {
                            int x = 10;
                            if (caction == 40) {
                                p = mycaret.getCaretPoint();
                                x = p.x + 1;
                            }
                            int y = tst.getTop() + 2;
                            MouseEvent me = new MouseEvent(this.docview, 500, 0L, 0, x, y, 1, false);
                            this.mouseDown(me, x, y);
                            return;
                        }
                    }
                    if (caction == 37 || caction == 38) {
                        tblock = tst.getBlockNumber();
                        ttst = this.docview.getFirstStatement();
                        if (ttst == st) {
                            this.docview.scrollLineUp();
                            this.docview.recompute();
                            tst = this.docview.findstatementbyblock(tblock);
                        }
                        if ((tst = this.docview.findpreviousstatement(tst)) != null && tst.isText()) {
                            Dimension d = this.docview.getViewSize();
                            int x = d.width - 2;
                            if (caction == 38) {
                                p = mycaret.getCaretPoint();
                                x = p.x + 1;
                            }
                            int y = tst.getBottom() - 8;
                            MouseEvent me = new MouseEvent(this.docview, 500, 0L, 0, x, y, 1, false);
                            this.mouseDown(me, x, y);
                            this.docview.repaint();
                            return;
                        }
                    }
                }
            }
        }
    }

    private void doBeep() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    private void doTab(Statement st, int modifiers) {
        int block = st.getBlockNumber();
        int nextblock = st.getNext();
        int upblock = st.getUp();
        int downblock = st.getDown();
        int prevblock = st.getPrev();
        ThMove thmove = new ThMove(this.frame);
        if ((modifiers & 1) == 1) {
            if (upblock != 0) {
                if (nextblock != 0) {
                    if (downblock != 0) {
                        StatementBlock downsb = st.getDoc().getStatementBlock(downblock);
                        int next = downsb.getNext();
                        while (next != 0) {
                            downsb = st.getDoc().getStatementBlock(next);
                            next = downsb.getNext();
                        }
                        thmove.moveGroup(st.getDoc().getStatementBlock(nextblock), null, downsb, 0);
                    } else {
                        thmove.moveGroup(st.getDoc().getStatementBlock(nextblock), null, st.getStatementBlock(), 1);
                    }
                }
                thmove.moveBranch(st.getStatementBlock(), st.getDoc().getStatementBlock(upblock), 0);
            }
        } else {
            if (prevblock != 0) {
                StatementBlock prevsb = st.getDoc().getStatementBlock(prevblock);
                int tblk = prevsb.getDown();
                if (tblk != 0) {
                    StatementBlock downsb = st.getDoc().getStatementBlock(tblk);
                    int next = downsb.getNext();
                    while (next != 0) {
                        downsb = st.getDoc().getStatementBlock(next);
                        next = downsb.getNext();
                    }
                    thmove.moveBranch(st.getStatementBlock(), downsb, 0);
                } else {
                    thmove.moveBranch(st.getStatementBlock(), prevsb, 1);
                }
            }
            if (downblock != 0 && (modifiers & 8) != 8) {
                StatementBlock downsb = st.getDoc().getStatementBlock(downblock);
                thmove.moveGroup(downsb, null, st.getStatementBlock(), 0);
            }
            this.docview.insertedBranch(st.getStatementBlock());
        }
    }

    private void doSplit(TextStatement st) {
        TextStatement newst = st.splitStatement(st.getCaretOffset());
        StatementBlock newsb = newst.getStatementBlock();
        StatementBlock anchorblock = st.getStatementBlock();
        newst = null;
        if (anchorblock.getDown() != 0) {
            new ThInsert(this.frame).insertAfter(st, newsb);
            StatementBlock plexsb = anchorblock.getDoc().getStatementBlock(anchorblock.getDown());
            new ThMove(this.frame).movePlex(plexsb, newsb, 1);
        } else {
            new ThInsert(this.frame).insertAfter(st, newsb);
        }
    }

    private TextStatement dojoin(TextStatement st) {
        StatementBlock mysb = st.getStatementBlock();
        if (st.isLabels()) {
            this.frame.errormsg("Can't join labelled statemen");
            return null;
        }
        int prev = mysb.getPrev();
        if (prev == 0) {
            this.doBeep();
            return null;
        }
        this.frame.getWindowManager().flushAllWindows(st.getDoc());
        Statement prevst = st.getDoc().getStatement(prev, this.docview.getFrame().getOptions());
        if (prevst.isImage()) {
            this.frame.errormsg("can't join images");
            return null;
        }
        StatementBlock prevsb = prevst.getStatementBlock();
        if (prevsb.getDown() != 0 && mysb.getDown() != 0) {
            this.frame.errormsg("Both can't have plex");
            return null;
        }
        if (mysb.getDown() != 0) {
            StatementBlock mydown = st.getDoc().getStatementBlock(mysb.getDown());
            new ThMove(this.docview.getFrame()).movePlex(mydown, prevsb, 1);
        }
        ((TextStatement)prevst).joinStatement(st);
        mysb.removeBranch();
        st.freeStatement();
        this.frame.getWindowManager().repaintAllWindows(prevst.getDoc());
        st = (TextStatement)prevst;
        return st;
    }

    public boolean editMouse(int code, MouseEvent e) {
        switch (code) {
            case 1: {
                return this.mouseDown(e, e.getX(), e.getY());
            }
        }
        return true;
    }

    private boolean mouseDown(MouseEvent e, int x, int y) {
        Statement st;
        MyCaret mycaret = this.frame.getMyCaret();
        int modifiers = e.getModifiers();
        if ((modifiers & 1) != 0 && (st = this.docview.findfocus()) != null && st.isText() && st.isSelecting() && ((TextStatement)st).shiftClick(this.docview, e, x, y)) {
            this.docview.repaintselected(st);
            return true;
        }
        mycaret.clearCaret();
        mycaret.hideCaret();
        this.docview.clearselect();
        this.docview.clearSelected();
        this.docview.setStatementCharFormat(null);
        st = this.docview.findstatement(x, y);
        if (st != null && st.isText()) {
            StatementFormat sf = ((TextStatement)st).getStatementFormat();
            CharFormat cf = sf.getStatementFormat();
            this.docview.setStatementCharFormat(cf);
        }
        this.docview.repaint();
        if (this.docview.clickGadget(e, x, y)) {
            return true;
        }
        if (this.docview.clickStatement(e, x, y)) {
            st = this.docview.findfocus();
            if (st != null) {
                if (st.isPage()) {
                    this.frame.updateReorgMenu(false, true);
                } else if (st.getDown() != 0) {
                    this.frame.updateReorgMenu(true, false);
                } else {
                    this.frame.updateReorgMenu(false, false);
                }
            }
            return true;
        }
        return false;
    }
}

