/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JFileChooser;

class ThExport
implements ThCommand {
    ThWindow frame;
    Doc doc;
    ExportProgress exp;
    int type = 2;
    int length = 70;
    boolean format = false;
    boolean isClipboard = false;
    public static final int BRANCH = 1;
    public static final int FILE = 2;
    public static final int IMAGE = 3;
    String EOL = "\r";
    String Hext = ".html";
    boolean dobranch = false;
    boolean dohtml = false;
    boolean doascii = false;
    boolean doimage = false;
    boolean doindent = false;
    File file;

    public ThExport(ThWindow fr, Doc d) {
        this.frame = fr;
        this.doc = d;
        Properties sysp = System.getProperties();
        this.EOL = sysp.getProperty("line.separator");
    }

    public boolean cmdStart(int code) {
        SimpleResponse r = new SimpleResponse();
        JExportChoice d = new JExportChoice(this.frame, r);
        d.setVisible(true);
        int res = r.getResponse();
        if (res == 1) {
            return false;
        }
        if ((res & 7) == 3) {
            this.type = 1;
        }
        if ((res & 7) == 2) {
            this.type = 2;
        }
        if ((res & 7) == 4) {
            this.type = 3;
        }
        if ((res & 8) == 8) {
            this.dohtml = true;
        }
        if ((res & 0x10) == 16) {
            this.doascii = true;
        }
        if ((res & 0x20) == 32) {
            this.doindent = true;
        }
        String doFormat = r.getStringRes();
        if (this.doascii && doFormat.compareTo("format") == 0) {
            this.format = true;
            this.length = 70;
            String number = r.getStringRes2();
            try {
                Integer maxL = new Integer(number);
                int i = maxL;
                if (i > 0) {
                    this.length = i;
                }
            }
            catch (Exception e) {}
        } else {
            this.format = false;
        }
        this.isClipboard = r.getClipboard();
        if (this.type != 2) {
            return true;
        }
        this.frame.disableControls();
        this.doTheExport(null);
        this.frame.enableControls();
        return false;
    }

    public boolean cmdContinue(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Statement s = this.frame.getDocView().findstatement(x, y);
        if (s == null) {
            return true;
        }
        this.frame.disableControls();
        this.doTheExport(s);
        this.frame.enableControls();
        return false;
    }

    public void cmdCancel() {
        this.frame.enableControls();
    }

    public void cmdEnd() {
    }

    private void doTheExport(Statement s) {
        String selected = new String("");
        Statement st = null;
        if (this.type == 2) {
            st = this.doc.getStatement(this.doc.getFirstBlock(), this.frame.getOptions());
        }
        if (this.type == 1) {
            st = s;
        }
        if (this.type == 3) {
            st = s;
        }
        this.frame.getWindowManager().flushAllWindows(this.doc);
        if (this.isClipboard) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.okExport(this.type, bos, this.format, this.length, st);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (cb != null) {
                StringSelection ss = new StringSelection(bos.toString());
                cb.setContents(ss, null);
            }
            return;
        }
        JFileChooser file_dialog = new JFileChooser(this.frame.getHome());
        file_dialog.setDialogType(1);
        file_dialog.setDialogTitle("Create Output File");
        if (this.dohtml) {
            selected = new String(this.doc.getFullname() + this.Hext);
        }
        if (this.doascii) {
            selected = new String(this.doc.getFullname() + ".txt");
        }
        if (this.type == 3) {
            if (((ImageStatement)st).isGIF()) {
                selected = new String(this.doc.getFullname() + ".gif");
            }
            if (((ImageStatement)st).isJPG()) {
                selected = new String(this.doc.getFullname() + ".jpg");
            }
        }
        File selectedfile = new File(selected);
        file_dialog.setSelectedFile(selectedfile);
        int retval = file_dialog.showSaveDialog(this.frame);
        if (retval == 0) {
            FileOutputStream fos;
            this.file = file_dialog.getSelectedFile();
            try {
                fos = new FileOutputStream(this.file);
            }
            catch (IOException ioe) {
                fos = null;
            }
            if (fos != null) {
                this.okExport(this.type, fos, this.format, this.length, st);
            }
        }
    }

    private void okExport(int type, OutputStream os, boolean format, int length, Statement st) {
        this.exp = new ExportProgress(this.frame, "Exporting.. ");
        if (type == 3) {
            this.doIMAGEExport(os, st);
        } else if (this.dohtml) {
            this.doHTMLExport(type, os, st, this.file, this.doindent);
        } else if (this.doascii) {
            this.doASCIIExport(type, os, format, length, st);
        }
        this.exp.setVisible(false);
        this.exp.dispose();
    }

    private void doHTMLExport(int type, OutputStream ostream, Statement st, File file, boolean doindent) {
        HTMLExp htmlexp = new HTMLExp(this.doc, ostream, this.frame, this.EOL, this.Hext, file, this.exp);
        this.frame.getDocView().flush();
        if (st != null) {
            if (type == 2) {
                htmlexp.exportHTML(st, false, doindent);
            }
            if (type == 1) {
                htmlexp.exportHTML(st, true, doindent);
            }
        }
    }

    private void doASCIIExport(int type, OutputStream ostream, boolean format, int length, Statement st) {
        ASCIIExp asciiexp = new ASCIIExp(this.doc, ostream, this.frame, this.EOL, this.exp);
        this.frame.getDocView().flush();
        if (st != null) {
            if (type == 2) {
                asciiexp.exportASCII(st, false, format, length);
            }
            if (type == 1) {
                asciiexp.exportASCII(st, true, format, length);
            }
        }
    }

    private void doIMAGEExport(OutputStream ostream, Statement st) {
        if (st != null) {
            byte[] buf = st.getBytes();
            if (!st.isImage()) {
                this.frame.errormsg("Statement not Image");
                return;
            }
            try {
                ostream.write(buf, 0, buf.length);
                ostream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

