/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseEvent;

class ThInsert
implements ThCommand {
    ThWindow frame;
    DocView docview;
    static final int INSERTMARK = 1;
    static final int INSERTAFTER = 2;
    static final int INSERTABOVE = 3;
    static final int INSERTUP = 4;
    static final int INSERTDOWN = 5;
    static final int INSERTIMAGE = 6;
    int inserttype = 0;
    boolean insertimage = false;

    ThInsert(ThWindow f) {
        this.frame = f;
        this.docview = this.frame.getDocView();
        this.docview.flush();
    }

    public boolean cmdStart(int code) {
        this.insertimage = false;
        if (code == 1) {
            return this.insertMark();
        }
        if (code == 2) {
            return this.insertAfter();
        }
        if (code == 3) {
            return this.insertAbove();
        }
        if (code == 4) {
            return this.insertUp();
        }
        if (code == 5) {
            return this.insertDown();
        }
        if (code == 6) {
            this.insertimage = true;
            return this.insertMark();
        }
        return false;
    }

    public boolean cmdContinue(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.inserttype == 1) {
            Statement s = this.docview.findstatement(x, y);
            if (s == null) {
                return true;
            }
            this.frame.enableControls();
            int block = s.getBlockNumber();
            this.docview.addMarkStatement(block);
            this.docview.repaint();
            SimpleResponse r = new SimpleResponse();
            JInsertConfirm d = new JInsertConfirm(this.frame, r, x, y);
            d.setVisible(true);
            int res = r.getResponse();
            this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
            int level = 0;
            if (res == 1) {
                level = -2;
            }
            if (res == 2) {
                level = -1;
            }
            if (res == 3) {
                level = 0;
            }
            if (res == 4) {
                level = 1;
            }
            if (res != 5) {
                this.doInsert(level, s, null);
            }
        }
        return false;
    }

    public boolean insertAfter(Statement s, StatementBlock sb) {
        this.doInsert(0, s, sb);
        return false;
    }

    public boolean insertAfter() {
        this.doInsert(0, null, null);
        return false;
    }

    public boolean insertUp() {
        this.doInsert(-1, null, null);
        return false;
    }

    public boolean insertDown() {
        this.doInsert(1, null, null);
        return false;
    }

    public boolean insertAbove() {
        this.doInsert(-2, null, null);
        return false;
    }

    private void doInsert(int level, Statement s, StatementBlock newblock) {
        int b;
        Options options = this.frame.getOptions();
        if (s == null) {
            s = this.docview.findfocus();
        }
        if (s == null) {
            return;
        }
        Doc doc = s.getDoc();
        StatementBlock anchorblock = s.getStatementBlock();
        if (newblock == null) {
            newblock = doc.getStatementBlock();
            if (level == 0) {
                newblock.putV2Fmt(s.getV2Fmt());
                newblock.putV2Need(s.getNeed());
                newblock.putV2Indent(s.getIndent());
                newblock.putV2Rindent(s.getRindent());
            } else {
                newblock.putV2Fmt(options.getV2FMT());
                newblock.putV2Need(options.getNeed());
                newblock.putV2Indent(options.getIndent());
                newblock.putV2Rindent(options.getRIndent());
                this.docview.setStatementCharFormat(null);
            }
        }
        this.frame.getWindowManager().flushAllWindows(doc);
        if (level == -2) {
            level = 1;
            b = anchorblock.getUp();
            if (b == 0) {
                this.frame.errormsg("No Up from here");
                return;
            }
            anchorblock = doc.getStatementBlock(b);
        }
        b = anchorblock.insertBranch(newblock, level, this.docview.getAnchorBlock());
        newblock = doc.getStatementBlock(b);
        if (!this.insertimage) {
            this.frame.getWindowManager().repaintAllWindows(doc);
            this.docview.clearFocus();
            MyCaret mycaret = this.frame.getMyCaret();
            mycaret.clearCaret();
            mycaret.setCaretStatement(doc, newblock.getBlockNumber(), 0);
            this.docview.insertedBranch(newblock);
        } else {
            this.doGetImage(newblock);
            this.frame.getWindowManager().flushAllWindows(doc);
            this.docview.insertedBranch(newblock);
            this.frame.getWindowManager().repaintAllWindows(doc);
        }
    }

    public void cmdEnd() {
    }

    public void cmdCancel() {
        this.frame.enableControls();
    }

    public boolean insertMark() {
        this.inserttype = 1;
        this.frame.disableControls();
        return true;
    }

    void doGetImage(StatementBlock newblock) {
        newblock.setImage(true);
        ImageStatement st = (ImageStatement)newblock.getDoc().getStatement(newblock.getBlockNumber(), this.frame.getOptions());
        st.getStatementImage(this.frame);
    }
}

