/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.NoSuchElementException;

class ThJump
implements ThCommand {
    ThWindow frame;
    DocView docview;
    static final int JUMPLINK = 1;
    static final int JUMPRETURN = 2;
    static final int JUMPCTL = 3;
    static final int JUMPDOUBLECLICK = 4;
    static final int JUMPMARK = 5;
    static final int JUMPLINKMARK = 6;
    static final int JUMPPRED = 7;
    static final int JUMPSUCC = 8;
    static final int JUMPUP = 9;
    static final int JUMPDOWN = 10;
    static final int JUMPNEXT = 11;
    static final int JUMPPREV = 12;
    static final int JUMPORIGIN = 13;
    static final int JUMPLINKCURSOR = 14;
    static final int JUMPLINKSELECTED = 15;
    int jumptype = 0;
    boolean more;

    ThJump(ThWindow f) {
        this.frame = f;
        this.docview = this.frame.getDocView();
        this.docview.flush();
    }

    public boolean cmdStart(int code) {
        if (code == 5) {
            return this.jumpMark(5);
        }
        if (code == 1) {
            return this.jumpLink();
        }
        if (code == 3) {
            return this.jumpCtl();
        }
        if (code == 7) {
            return this.jumpMark(7);
        }
        if (code == 8) {
            return this.jumpMark(8);
        }
        if (code == 9) {
            return this.jumpMark(9);
        }
        if (code == 10) {
            return this.jumpMark(10);
        }
        return false;
    }

    public boolean cmdContinue(MouseEvent e) {
        int y;
        int x = e.getX();
        Statement s = this.docview.findstatement(x, y = e.getY());
        if (s == null) {
            return true;
        }
        this.frame.enableControls();
        Doc doc = s.getDoc();
        if (this.jumptype != 5) {
            if (this.jumptype == 7) {
                int pred = s.getPredecessor(this.docview.getClipping(), this.frame.getOptions(), this.docview);
                s = pred != 0 ? doc.getStatement(pred, this.frame.getOptions()) : null;
            } else if (this.jumptype == 8) {
                int succ = s.getSuccessor(this.docview.getClipping());
                s = succ != 0 ? doc.getStatement(succ, this.frame.getOptions()) : null;
            } else if (this.jumptype == 9) {
                int up = s.getUp();
                if (up != 0) {
                    s = doc.getStatement(up, this.frame.getOptions());
                }
            } else if (this.jumptype == 10) {
                int down = s.getDown();
                if (down != 0) {
                    s = doc.getStatement(down, this.frame.getOptions());
                }
            } else if (this.jumptype == 6) {
                this.doubleClick(e, x, y);
                return false;
            }
        }
        if (s != null) {
            DocLink dl = new DocLink(doc, s.getBlockNumber());
            this.dojump(dl, x, y, false, false);
        }
        return false;
    }

    public void cmdEnd() {
    }

    public void cmdCancel() {
        this.frame.enableControls();
    }

    public boolean jumpNext(int x, int y) {
        int blk = this.docview.getAnchorBlock();
        StatementBlock sb = this.frame.getDoc().getStatementBlock(blk);
        blk = sb.getNext();
        if (blk == 0) {
            this.frame.errormsg("No Next");
            return false;
        }
        DocLink dl = new DocLink(sb.getDoc(), blk);
        this.dojump(dl, x, y, false, false);
        return false;
    }

    public boolean jumpPrev(int x, int y) {
        int blk = this.docview.getAnchorBlock();
        StatementBlock sb = this.frame.getDoc().getStatementBlock(blk);
        blk = sb.getPrev();
        if (blk == 0) {
            this.frame.errormsg("No Previous");
            return false;
        }
        DocLink dl = new DocLink(sb.getDoc(), blk);
        this.dojump(dl, x, y, false, false);
        return false;
    }

    public boolean jumpOrigin(int x, int y) {
        StatementBlock pageHead;
        int origin = this.frame.getOptions().getPageMode() ? ((pageHead = this.frame.getDoc().whatsMyPage(this.frame.getDoc().getStatementBlock(this.docview.getAnchorBlock()))) == null ? this.frame.getDoc().getFirstBlock() : pageHead.getBlockNumber()) : this.frame.getDoc().getFirstBlock();
        DocLink dl = new DocLink(this.frame.getDoc(), origin);
        this.dojump(dl, x, y, false, false);
        return false;
    }

    public boolean jumpRet(int x, int y, boolean quick) {
        if (quick) {
            try {
                DocLink dl = this.frame.getMyReturn().getReturn();
                this.dojump(dl, x, y, true, true);
            }
            catch (NoSuchElementException e) {
                this.frame.errormsg("No Return point");
            }
            return false;
        }
        try {
            DocLink dl = this.frame.getMyReturn().selectReturn(this.frame, x, y);
            this.dojump(dl, x, y, false, true);
        }
        catch (NoSuchElementException e) {
            this.frame.errormsg("No Return Selected");
        }
        return false;
    }

    private void dojump(DocLink dl, int x, int y, boolean quick, boolean jr) {
        ThWindow jumptarget;
        Doc dldoc = dl.getDocument();
        int i = dl.getBlock(this.frame, x, y);
        if (i == -1) {
            return;
        }
        DocLink currentDocLink = new DocLink(this.frame.getDoc(), this.docview.getAnchorBlock());
        if (dldoc == this.frame.getDoc()) {
            this.docview.addMarkStatement(i);
            this.docview.repaint();
        }
        int res = quick ? 2 : this.jumpConfirm(x, y);
        this.frame.getWindowManager().clearAllMarkedAllWindows(this.frame.getDoc());
        if (res == 2 && this.frame.getOptions().getNoJumpConfirm() && (jumptarget = this.frame.getWindowManager().getJumpTarget()) != null && jumptarget != this.frame) {
            jumptarget.setDoc(dl, true);
            return;
        }
        if (res == 2) {
            int clip = 5;
            clip = this.docview.getClipping();
            this.frame.setDoc(dldoc, false);
            this.docview.setClipping(clip);
            this.docview.setAnchorBlock(i);
            try {
                DocLink lastReturn = this.frame.getMyReturn().getCurrent();
                if (!jr && !currentDocLink.compare(lastReturn)) {
                    this.frame.getMyReturn().addReturn(currentDocLink);
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            this.frame.getMyReturn().addReturn(dl);
            this.docview.repaint();
        }
        if (res == 3) {
            Rectangle fbounds = this.frame.getBounds();
            try {
                String winname = dl.getDocument().getFilename();
                ThWindow tframe = this.frame.getWindowManager().makeWindow(winname, fbounds.x + 40, fbounds.y + 40, 400, 200);
                tframe.setDoc(dl, true);
                tframe.setVisible(true);
                if (this.frame.getDoc() == tframe.getDoc()) {
                    this.frame.getDoc().incrementOpencount();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void jumpLinkCursor(int x, int y) {
        Statement s = this.docview.findfocus();
        if (s == null) {
            this.frame.errormsg("No cursor found");
            return;
        }
        if (!s.isText()) {
            this.frame.errormsg("Image Statement");
            return;
        }
        try {
            LabelString ls = s.doubleClick(this.frame.getMyCaret());
            this.jumpLabelString(ls, x, y);
        }
        catch (NoSuchElementException ex) {
            this.frame.errormsg(ex.getMessage() + " Not Found");
        }
    }

    public void jumpLinkSelected(int x, int y) {
        Statement s = this.docview.findfocus();
        if (s == null) {
            return;
        }
        if (!s.isText()) {
            this.frame.errormsg("Image Statement");
            return;
        }
        String str = s.returnSelected();
        if (str == null) {
            this.frame.errormsg("No String Selected");
            return;
        }
        try {
            LabelString ls = new LabelString(str, this.frame.getOptions(), s.getVDoc());
            this.jumpLabelString(ls, x, y);
        }
        catch (NoSuchElementException ex) {
            this.frame.errormsg(ex.getMessage() + " Not Found");
        }
    }

    public void jumpLabelString(LabelString ls, int x, int y) {
        DocLink dl = new DocLink(this.frame, ls, x, y);
        if (dl.getDocument() == null) {
            this.frame.errormsg(dl.getMsg());
            return;
        }
        this.dojump(dl, x, y, false, false);
    }

    public boolean jumpLink() {
        Point p = this.frame.getMouse();
        int x = p.x;
        int y = p.y;
        SimpleResponse r = new SimpleResponse();
        JJumpLink djl = new JJumpLink(this.frame, r, x, y);
        djl.setVisible(true);
        int res = r.getResponse();
        if (res == 5 || res == 4) {
            try {
                LabelString ls = new LabelString(r.getStringRes(), this.frame.getOptions(), this.frame.getDoc());
                this.jumpLabelString(ls, x, y);
            }
            catch (NoSuchElementException e) {
                this.frame.errormsg(e.getMessage() + " Not Found");
            }
        } else {
            if (res == 2) {
                boolean more = this.jumpMark(5);
                if (more) {
                    this.jumptype = 6;
                }
                return more;
            }
            if (res == 3) {
                LabelString ls;
                try {
                    DocManager docmanager = this.frame.getDocManager();
                    ls = docmanager.findDoc(this.frame);
                }
                catch (IOException ioe) {
                    ls = null;
                }
                this.frame.setDoc(ls, true);
                this.frame.getDocView().repaint();
            } else {
                this.frame.errormsg(r.toString());
            }
        }
        return false;
    }

    public boolean jumpCtl() {
        Point p = this.frame.getMouse();
        int x = p.x;
        int y = p.y;
        SimpleResponse r = new SimpleResponse();
        JMenuJump d = new JMenuJump(this.frame, r, x, y);
        d.setVisible(true);
        int res = r.getResponse();
        if (res == 2) {
            this.more = this.jumpLink();
            if (this.more) {
                this.jumptype = 6;
            }
            return this.more;
        }
        if (res == 3) {
            this.frame.updateMouse(x += 54, y);
            this.more = this.jumpMark(8);
            return this.more;
        }
        if (res == 4) {
            this.frame.updateMouse(x += 108, y);
            this.jumpOrigin(x, y);
            return false;
        }
        if (res == 5) {
            this.frame.updateMouse(x, y += 18);
            this.more = this.jumpMark(9);
            return this.more;
        }
        if (res == 6) {
            this.frame.updateMouse(x += 54, y += 18);
            this.more = this.jumpMark(7);
            return this.more;
        }
        if (res == 7) {
            this.frame.updateMouse(x += 108, y += 18);
            this.jumpRet(x, y, false);
            return false;
        }
        this.frame.errormsg(r.toString());
        return false;
    }

    public boolean doubleClick(MouseEvent e, int x, int y) {
        Statement st = this.docview.findstatement(x, y);
        if (st != null) {
            if (st.isImage()) {
                return false;
            }
            try {
                LabelString ls = st.doubleClick(this.frame.getMyCaret());
                if (ls != null) {
                    this.jumpLabelString(ls, x, y);
                } else {
                    this.docview.repaint();
                }
            }
            catch (NoSuchElementException ex) {
                this.frame.errormsg(ex.getMessage() + " Not Found");
            }
        }
        return false;
    }

    public boolean jumpMark(int type) {
        this.jumptype = type;
        this.frame.disableControls();
        return true;
    }

    private int jumpConfirm(int x, int y) {
        if (this.frame.getOptions().getNoJumpConfirm()) {
            return 2;
        }
        SimpleResponse r = new SimpleResponse();
        JJumpConfirm d = new JJumpConfirm(this.frame, r, x, y);
        d.setVisible(true);
        return r.getResponse();
    }
}

