/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.Timer;

class ThWindow
extends JFrame
implements WindowListener {
    public static int ACTIONVERT = 19;
    public static int BUTTONVERT = 19;
    VBar vbar;
    DocView docview;
    ActionPanel actions;
    JMenuBar menubar;
    FileMenu mfile;
    EditMenu medit;
    JumpMenu mjump;
    OtherMenu mother;
    ReorgMenu mreorg;
    StylesMenu mstyle;
    SizeMenu msize;
    OptionsMenu moptions;
    FontTable fonttable = new FontTable();
    boolean windowclosed = false;
    boolean quited = false;
    boolean isfirst = true;
    Timer poller;
    CharFormat cformat = new CharFormat("Times", 12, 0, this.fonttable);
    JPanel mainpane;
    JPanel highlightpane;
    JLayeredPane layeredpane;
    MyCaret mycaret;
    MyReturn myreturn = new MyReturn();
    Options options;
    DocManager docmanager;
    WindowManager windowmanager;
    String home;
    long lasttime = 0L;
    Doc doc = null;
    int mouseX = 0;
    int mouseY = 0;
    String title;
    String name;

    public ThWindow(int x, int y, int width, int height, String nm, DocManager dm, Options op, WindowManager wm) throws IOException {
        this.docmanager = dm;
        this.mycaret = new MyCaret();
        this.options = op;
        this.windowmanager = wm;
        this.name = nm;
        Rectangle mybounds = new Rectangle();
        mybounds.setBounds(x, y, width, height);
        this.fixbounds(mybounds);
        this.setBounds(mybounds);
        this.initwindow();
        this.home = "/";
        this.home = System.getProperty("user.home");
        this.home = this.home + File.separator;
        this.addWindowListener(this);
    }

    private void fixbounds(Rectangle b) {
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                virtualBounds = virtualBounds.union(gc[i].getBounds());
            }
        }
        if (b.x < virtualBounds.x) {
            b.x = virtualBounds.x;
        }
        if (b.y < virtualBounds.y) {
            b.y = virtualBounds.y;
        }
        if (b.x + b.width > virtualBounds.width) {
            b.x = 50;
            b.x = virtualBounds.width - b.width - 1;
        }
        if (b.y + b.height > virtualBounds.height) {
            b.y = 50;
            b.y = virtualBounds.height - b.height - 1;
        }
        if (b.x < virtualBounds.x) {
            b.width -= virtualBounds.x - b.x;
            b.x = virtualBounds.x;
        }
        if (b.y < virtualBounds.y) {
            b.height -= virtualBounds.y - b.y;
            b.y = virtualBounds.y;
        }
    }

    public OtherMenu getother() {
        return this.mother;
    }

    public void updateMouse(int x, int y) {
        this.mouseX = x;
        this.mouseY = y;
    }

    public Point getMouse() {
        return new Point(this.mouseX, this.mouseY);
    }

    public int controloffset() {
        return 0;
    }

    public int menuoffset(int item) {
        return 0;
    }

    public DocView getDocView() {
        return this.docview;
    }

    public WindowManager getWindowManager() {
        return this.windowmanager;
    }

    public DocManager getDocManager() {
        return this.docmanager;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public Point getOrigin() {
        return this.getLocation();
    }

    public String getHome() {
        return this.home;
    }

    public MyReturn getMyReturn() {
        return this.myreturn;
    }

    public Options getOptions() {
        return this.options;
    }

    public MyCaret getMyCaret() {
        return this.mycaret;
    }

    public VBar getVbar() {
        return this.vbar;
    }

    public ActionPanel getActions() {
        return this.actions;
    }

    public void updateOptionsMenu() {
        this.moptions.updateMenu(this.options);
    }

    public void updateSaveMenu(boolean en) {
        this.mfile.updateSaveMenu(en);
    }

    public void updateRevertMenu(boolean en) {
        this.mfile.updateRevertMenu(en);
    }

    public void updateRegistration(boolean en) {
        this.mfile.updateRegistration(en);
    }

    public void enableControls() {
        this.actions.enableControls();
    }

    public void disableControls() {
        this.actions.disableControls();
    }

    public void setDoc(DocLink dl, boolean setreturn) {
        Doc d = dl.getDocument();
        int block = dl.getBlock();
        this.setDoc(d, true);
        this.docview.setAnchorBlock(block);
        this.enableControls();
    }

    public void setDoc(LabelString ls, boolean setreturn) {
        if (ls == null) {
            return;
        }
        String docname = ls.getFilename();
        if (docname == null) {
            return;
        }
        Doc d = this.docmanager.openDoc(docname);
        if (d == null) {
            this.errormsg("file unknown");
        } else {
            int block;
            Labels labels = d.getLabels();
            this.setDoc(d, setreturn);
            try {
                DocLink dl = labels.lookupLabel(ls.getLabel());
                block = dl.getBlock();
            }
            catch (NoSuchElementException e) {
                block = d.getFirstBlock();
            }
            this.docview.setAnchorBlock(block);
        }
        this.enableControls();
        this.docview.repaint();
    }

    public void setDoc(Doc d, boolean setreturn) {
        this.doc = d;
        if (this.isfirst) {
            this.setOptions();
            Rectangle myb = this.getBounds();
            this.setLocation(myb.x - 1, myb.y - 1);
            this.setOptions();
            this.isfirst = false;
        }
        this.title = this.doc.getFilename();
        this.setTitle(this.title);
        this.docview.setDoc(this.doc);
        int firstblock = this.doc.getFirstBlock();
        this.docview.setAnchorBlock(firstblock);
        if (setreturn) {
            this.myreturn.addReturn(new DocLink(this.doc, firstblock));
        }
        this.home = d.getHome();
        this.docview.repaint();
    }

    public void setOptions() {
        this.options = this.doc.getOptions(this);
        this.docview.setOptions(this.options);
        Rectangle bounds = this.options.getWindowRect();
        this.fixbounds(bounds);
        this.setBounds(bounds);
        this.setLocation(bounds.x, bounds.y);
        short i = this.options.getClipping();
        this.actions.setClipping(i);
        this.docview.setClipping(i);
        this.moptions.updateMenu(this.options);
        this.cformat = new CharFormat(this.options.getFont(), this.options.getFontSize(), 0, this.fonttable);
        this.docview.setDisplayCharFormat(this.cformat);
        this.updateStyleMenus(this.cformat);
    }

    public void errormsg(String s) {
        this.actions.setMessage(s);
        this.actions.emsgRepaint();
    }

    private void initwindow() {
        this.vbar = new VBar(this);
        this.docview = new DocView(this, this.vbar, this.mycaret, this.options);
        this.docview.setDisplayCharFormat(this.cformat);
        this.menubar = new JMenuBar();
        this.mfile = new FileMenu(this);
        this.medit = new EditMenu(this);
        this.mjump = new JumpMenu(this);
        this.mreorg = new ReorgMenu(this);
        this.mstyle = new StylesMenu(this);
        this.msize = new SizeMenu(this);
        this.mother = new OtherMenu(this);
        this.moptions = new OptionsMenu(this);
        this.menubar.add(this.mfile);
        this.menubar.add(this.medit);
        this.menubar.add(this.mjump);
        this.menubar.add(this.mreorg);
        this.menubar.add(this.moptions);
        this.menubar.add(this.mstyle);
        this.menubar.add(this.msize);
        this.menubar.add(this.mother);
        this.setJMenuBar(this.menubar);
        this.actions = new ActionPanel(this);
        this.mainpane = new JPanel();
        this.mainpane.setLayout(new BorderLayout(0, 0));
        this.mainpane.add("North", this.actions);
        this.mainpane.add("Center", this.docview);
        this.mainpane.add("East", this.vbar);
        this.mainpane.add("South", Box.createRigidArea(new Dimension(16, 16)));
        this.layeredpane = new JLayeredPane();
        this.layeredpane.add((Component)this.mainpane, new Integer(100));
        this.layeredpane.add((Component)this.mycaret, new Integer(200));
        this.highlightpane = new JPanel();
        this.highlightpane.setBackground(Color.white);
        this.layeredpane.add((Component)this.highlightpane, new Integer(50));
        this.getContentPane().add((Component)this.layeredpane, "Center");
        this.setVisible(true);
        Dimension dd = this.layeredpane.getSize();
        this.mainpane.setSize(dd);
        this.layeredpane.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                Dimension dd = ThWindow.this.layeredpane.getSize();
                ThWindow.this.mainpane.setSize(dd);
                ThWindow.this.mainpane.setVisible(false);
                ThWindow.this.mainpane.setVisible(true);
            }
        });
        this.poller = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ThWindow.this.docview.mypoll();
            }
        });
        this.poller.start();
    }

    public void addDrag(JComponent comp) {
        this.layeredpane.add((Component)comp, new Integer(300));
    }

    public void removeDrag(JComponent comp) {
        this.layeredpane.remove(comp);
    }

    public void updateStyleMenus(CharFormat tcf) {
        this.mstyle.updateMenu(tcf);
        this.msize.updateMenu(tcf);
    }

    public void updateReorgMenu(boolean mp, boolean cp) {
        this.mreorg.updateMenu(mp, cp);
    }

    public void updateUndo(boolean undo) {
        this.medit.updateUndo(undo);
    }

    public void updateCutCopy(boolean selected) {
        this.medit.updateCutCopy(selected);
    }

    public void updatePaste() {
        this.medit.updatePaste();
    }

    public void updateAddLabel(boolean al) {
        this.mother.updateAddLabel(al);
    }

    public void doClose() {
        this.poller.stop();
        this.docview.flush();
        this.docmanager.closeDoc(this.doc, this);
    }

    public void doFlush(Doc d) {
        if (d != this.doc) {
            return;
        }
        this.docview.flushrelease();
    }

    public void doRepaint(Doc d) {
        if (d != this.doc) {
            return;
        }
        this.docview.repaint();
    }

    public void doAddMarkStatement(int block) {
        this.docview.addMarkStatement(block);
        this.docview.repaint();
    }

    public void doClearAllMarked() {
        this.docview.clearAllMarked();
        this.docview.repaint();
    }

    public void doRevert(Doc d) {
        if (d != this.doc) {
            return;
        }
        this.docview.doRevertSeeThrough();
        this.docview.flushrelease();
        int anchor = this.doc.doRevert();
        if (anchor != 0) {
            this.docview.setAnchorBlock(anchor);
        }
        this.docview.repaint();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.windowclosed) {
            return;
        }
        if (this.quited) {
            return;
        }
        this.windowclosed = true;
        this.dispose();
        this.windowmanager.doClose(this);
    }

    public void windowActivated(WindowEvent e) {
        if (this.windowclosed) {
            return;
        }
        if (this.quited) {
            return;
        }
        this.mycaret.resumeCaret();
        if (this.windowmanager.numWindows() != 1) {
            this.windowmanager.flushAllWindows(this.doc);
            this.windowmanager.repaintAllWindows(this.doc);
        }
    }

    public void windowDeactivated(WindowEvent e) {
        if (this.windowclosed) {
            return;
        }
        if (this.quited) {
            return;
        }
        this.mycaret.suspendCaret();
        this.mycaret.hideCaret();
    }
}

