/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Date;
import java.util.Vector;

class VBar
extends Scrollbar
implements AdjustmentListener {
    ThWindow frame;
    Vector lock = new Vector();
    int lockvalue = 0;
    int position;
    int lastposition = 0;
    long lasttime = 0L;
    boolean ignoreSetPosition = false;

    public VBar(ThWindow f) {
        super(1);
        this.setValues(0, 1, 0, 10000);
        this.addAdjustmentListener(this);
        this.setBlockIncrement(1);
        this.setUnitIncrement(1);
        this.frame = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustmentValueChanged(AdjustmentEvent e) {
        DocView docview = this.frame.getDocView();
        Date date = new Date();
        long time = date.getTime();
        int sbv = e.getValue();
        int type = e.getAdjustmentType();
        switch (type) {
            case 601: {
                break;
            }
            case 1: {
                docview.scrollLineDown();
                this.lasttime = time;
                break;
            }
            case 2: {
                docview.scrollLineUp();
                this.lasttime = time;
                break;
            }
            case 4: {
                docview.scrollPageDown();
                this.lasttime = time;
                break;
            }
            case 3: {
                docview.scrollPageUp();
                this.lasttime = time;
                break;
            }
            case 5: {
                boolean busy;
                Vector vector = this.lock;
                synchronized (vector) {
                    busy = this.lockvalue == 1;
                    this.lockvalue = 1;
                }
                if (busy) break;
                this.ignoreSetPosition = true;
                docview.scrollBarPosition();
                this.ignoreSetPosition = false;
                vector = this.lock;
                synchronized (vector) {
                    this.lockvalue = 0;
                    break;
                }
            }
        }
    }

    public int getBlkPosition(Doc doc) {
        int nstatements = doc.getNStatements();
        if (nstatements == 0) {
            return 0;
        }
        int max = this.getMaximum();
        int pos = this.getValue();
        pos = pos * nstatements / max + 1;
        return doc.positionToBlock(pos);
    }

    public void setPosition(int block, Doc doc) {
        if (this.ignoreSetPosition) {
            return;
        }
        this.position = doc.getPosition(block);
        int nstatements = doc.getNStatements();
        int max = this.getMaximum();
        this.position = nstatements != 0 ? this.position * max / nstatements : 0;
        if (this.position == 0) {
            this.position = 1;
        }
        this.setValue(this.position);
    }

    public void updateVbar() {
        if (this.position == this.lastposition) {
            return;
        }
        this.lastposition = this.position;
    }
}

