/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class WindowManager {
    Hashtable<String, ThWindow> directory = new Hashtable();
    DocManager docmanager = new DocManager();
    Options options = new Options();
    ThWindow jumptarget;
    int nwindows = 0;

    public ThWindow makeWindow(int x, int y, int width, int height) throws IOException {
        String name = "Window 1";
        ThWindow f = null;
        f = new ThWindow(x, y, width, height, name, this.docmanager, this.options, this);
        ++this.nwindows;
        this.directory.put(name, f);
        return f;
    }

    public int numWindows() {
        return this.nwindows;
    }

    public ThWindow makeWindow(String name, int x, int y, int width, int height) throws IOException {
        ThWindow f = null;
        f = new ThWindow(x, y, width, height, name, this.docmanager, this.options, this);
        ++this.nwindows;
        this.directory.put(name, f);
        return f;
    }

    public void doClose(ThWindow window) {
        window.doClose();
        this.directory.remove(window.name);
        --this.nwindows;
        if (this.nwindows == 0) {
            this.docmanager.closeAllDoc(window);
            System.exit(0);
        }
        window.dispose();
    }

    public ThWindow anyWindow() {
        ThWindow frame = null;
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            frame = e.nextElement();
        }
        return frame;
    }

    public void quit(ThWindow window) {
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            frame.doClose();
            if (frame == window) continue;
            frame.dispose();
        }
        this.docmanager.closeAllDoc(window);
        window.dispose();
        System.exit(0);
    }

    public void setJumpTarget(ThWindow jt) {
        this.jumptarget = jt;
    }

    public ThWindow getJumpTarget() {
        return this.jumptarget;
    }

    public void flushAllWindows(Doc d) {
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            frame.doFlush(d);
        }
    }

    public void repaintAllWindows(Doc d) {
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            frame.doRepaint(d);
        }
    }

    public void revertAllWindows(Doc d) {
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            frame.doRevert(d);
        }
    }

    public void addMarkStatementAllWindows(int block, Doc d) {
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            if (frame.getDoc() != d) continue;
            frame.doAddMarkStatement(block);
        }
    }

    public void clearAllMarkedAllWindows(Doc d) {
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            if (frame.getDoc() != d) continue;
            frame.doClearAllMarked();
        }
    }

    public ThWindow getEmptyFrame(String filename) {
        Doc doc = null;
        int oX = 0;
        int oY = 0;
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            Point p = frame.getOrigin();
            doc = frame.getDoc();
            if (p.getX() > (double)oX) {
                oX = (int)p.getX();
            }
            if (p.getY() > (double)oY) {
                oY = (int)p.getY();
            }
            if (doc == null) {
                return frame;
            }
            String tstring = new String(doc.getFullname() + ".tkr");
            if (filename.compareToIgnoreCase(tstring) != 0) continue;
            return frame;
        }
        try {
            return this.makeWindow(doc.getFilename(), oX + 40, oY + 40, 600, 400);
        }
        catch (IOException io) {
            return null;
        }
    }

    public void replaceAnchor(Doc d, StatementBlock sb) {
        Enumeration<ThWindow> e = this.directory.elements();
        while (e.hasMoreElements()) {
            ThWindow frame = e.nextElement();
            if (frame.getDoc() != d) continue;
            DocView docview = frame.getDocView();
            docview.flush();
            if (docview.getAnchorBlock() == sb.getBlockNumber()) {
                if (sb.getNext() != 0) {
                    docview.setAnchorBlock(sb.getNext());
                } else if (sb.getPrev() != 0) {
                    docview.setAnchorBlock(sb.getPrev());
                } else if (sb.getUp() != 0) {
                    docview.setAnchorBlock(sb.getUp());
                }
            }
            docview.repaint();
        }
    }
}

